/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.utils;

import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.FullIdent;
import com.puppycrawl.tools.checkstyle.checks.naming.AccessModifier;
import com.puppycrawl.tools.checkstyle.utils.CommonUtil;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;

public final class CheckUtil {
    private static final int BASE_2 = 2;
    private static final int BASE_8 = 8;
    private static final int BASE_10 = 10;
    private static final int BASE_16 = 16;
    private static final int SETTER_GETTER_MAX_CHILDREN = 7;
    private static final int SETTER_BODY_SIZE = 3;
    private static final int GETTER_BODY_SIZE = 2;
    private static final Pattern UNDERSCORE_PATTERN = Pattern.compile("_");
    private static final Pattern SETTER_PATTERN = Pattern.compile("^set[A-Z].*");
    private static final Pattern GETTER_PATTERN = Pattern.compile("^(is|get)[A-Z].*");

    private CheckUtil() {
    }

    public static FullIdent createFullType(DetailAST typeAST) {
        DetailAST ast = typeAST;
        while (ast.findFirstToken(17) != null) {
            ast = ast.findFirstToken(17);
        }
        return FullIdent.createFullIdent(ast.getFirstChild());
    }

    public static boolean isEqualsMethod(DetailAST ast) {
        boolean equalsMethod = false;
        if (ast.getType() == 9) {
            DetailAST nameNode;
            String name;
            boolean staticOrAbstract;
            DetailAST modifiers = ast.findFirstToken(5);
            boolean bl = staticOrAbstract = modifiers.findFirstToken(64) != null || modifiers.findFirstToken(40) != null;
            if (!staticOrAbstract && "equals".equals(name = (nameNode = ast.findFirstToken(58)).getText())) {
                DetailAST paramsNode = ast.findFirstToken(20);
                equalsMethod = paramsNode.getChildCount() == 1;
            }
        }
        return equalsMethod;
    }

    public static boolean isElseIf(DetailAST ast) {
        DetailAST parentAST = ast.getParent();
        return ast.getType() == 83 && (CheckUtil.isElse(parentAST) || CheckUtil.isElseWithCurlyBraces(parentAST));
    }

    private static boolean isElse(DetailAST ast) {
        return ast.getType() == 92;
    }

    private static boolean isElseWithCurlyBraces(DetailAST ast) {
        return ast.getType() == 7 && ast.getChildCount() == 2 && CheckUtil.isElse(ast.getParent());
    }

    public static double parseDouble(String text, int type) {
        double result;
        String txt = UNDERSCORE_PATTERN.matcher(text).replaceAll("");
        switch (type) {
            case 140: 
            case 142: {
                result = Double.parseDouble(txt);
                break;
            }
            case 137: 
            case 141: {
                int radix = 10;
                if (txt.startsWith("0x") || txt.startsWith("0X")) {
                    radix = 16;
                    txt = txt.substring(2);
                } else if (txt.startsWith("0b") || txt.startsWith("0B")) {
                    radix = 2;
                    txt = txt.substring(2);
                } else if (CommonUtil.startsWithChar(txt, '0')) {
                    radix = 8;
                    txt = txt.substring(1);
                }
                result = CheckUtil.parseNumber(txt, radix, type);
                break;
            }
            default: {
                result = Double.NaN;
            }
        }
        return result;
    }

    private static double parseNumber(String text, int radix, int type) {
        double result;
        String txt = text;
        if (CommonUtil.endsWithChar(txt, 'L') || CommonUtil.endsWithChar(txt, 'l')) {
            txt = txt.substring(0, txt.length() - 1);
        }
        if (txt.isEmpty()) {
            result = 0.0;
        } else {
            boolean negative;
            boolean bl = negative = txt.charAt(0) == '-';
            result = type == 137 ? (negative ? (double)Integer.parseInt(txt, radix) : (double)Integer.parseUnsignedInt(txt, radix)) : (negative ? (double)Long.parseLong(txt, radix) : (double)Long.parseUnsignedLong(txt, radix));
        }
        return result;
    }

    public static DetailAST getFirstNode(DetailAST node) {
        DetailAST currentNode = node;
        for (DetailAST child = node.getFirstChild(); child != null; child = child.getNextSibling()) {
            DetailAST newNode = CheckUtil.getFirstNode(child);
            if (!CheckUtil.isBeforeInSource(newNode, currentNode)) continue;
            currentNode = newNode;
        }
        return currentNode;
    }

    public static boolean isBeforeInSource(DetailAST ast1, DetailAST ast2) {
        return ast1.getLineNo() < ast2.getLineNo() || ast1.getLineNo() == ast2.getLineNo() && ast1.getColumnNo() < ast2.getColumnNo();
    }

    public static List<String> getTypeParameterNames(DetailAST node) {
        DetailAST typeParameters = node.findFirstToken(165);
        ArrayList<String> typeParameterNames = new ArrayList<String>();
        if (typeParameters != null) {
            DetailAST typeParam = typeParameters.findFirstToken(166);
            typeParameterNames.add(typeParam.findFirstToken(58).getText());
            for (DetailAST sibling = typeParam.getNextSibling(); sibling != null; sibling = sibling.getNextSibling()) {
                if (sibling.getType() != 166) continue;
                typeParameterNames.add(sibling.findFirstToken(58).getText());
            }
        }
        return typeParameterNames;
    }

    public static List<DetailAST> getTypeParameters(DetailAST node) {
        DetailAST typeParameters = node.findFirstToken(165);
        ArrayList<DetailAST> typeParams = new ArrayList<DetailAST>();
        if (typeParameters != null) {
            DetailAST typeParam = typeParameters.findFirstToken(166);
            typeParams.add(typeParam);
            for (DetailAST sibling = typeParam.getNextSibling(); sibling != null; sibling = sibling.getNextSibling()) {
                if (sibling.getType() != 166) continue;
                typeParams.add(sibling);
            }
        }
        return typeParams;
    }

    public static boolean isSetterMethod(DetailAST ast) {
        boolean setterMethod = false;
        if (ast.getType() == 9 && ast.getChildCount() == 7) {
            DetailAST slist;
            boolean singleParam;
            DetailAST type = ast.findFirstToken(13);
            String name = type.getNextSibling().getText();
            boolean matchesSetterFormat = SETTER_PATTERN.matcher(name).matches();
            boolean voidReturnType = type.findFirstToken(49) != null;
            DetailAST params = ast.findFirstToken(20);
            boolean bl = singleParam = params.getChildCount(21) == 1;
            if (matchesSetterFormat && voidReturnType && singleParam && (slist = ast.findFirstToken(7)) != null && slist.getChildCount() == 3) {
                DetailAST expr = slist.getFirstChild();
                setterMethod = expr.getFirstChild().getType() == 80;
            }
        }
        return setterMethod;
    }

    public static boolean isGetterMethod(DetailAST ast) {
        boolean getterMethod = false;
        if (ast.getType() == 9 && ast.getChildCount() == 7) {
            DetailAST slist;
            boolean noParams;
            DetailAST type = ast.findFirstToken(13);
            String name = type.getNextSibling().getText();
            boolean matchesGetterFormat = GETTER_PATTERN.matcher(name).matches();
            boolean noVoidReturnType = type.findFirstToken(49) == null;
            DetailAST params = ast.findFirstToken(20);
            boolean bl = noParams = params.getChildCount(21) == 0;
            if (matchesGetterFormat && noVoidReturnType && noParams && (slist = ast.findFirstToken(7)) != null && slist.getChildCount() == 2) {
                DetailAST expr = slist.getFirstChild();
                getterMethod = expr.getType() == 88;
            }
        }
        return getterMethod;
    }

    public static boolean isNonVoidMethod(DetailAST methodDefAst) {
        DetailAST typeAST;
        boolean returnValue = false;
        if (methodDefAst.getType() == 9 && (typeAST = methodDefAst.findFirstToken(13)).findFirstToken(49) == null) {
            returnValue = true;
        }
        return returnValue;
    }

    public static boolean isReceiverParameter(DetailAST parameterDefAst) {
        return parameterDefAst.getType() == 21 && parameterDefAst.findFirstToken(58) == null;
    }

    public static AccessModifier getAccessModifierFromModifiersToken(DetailAST modifiersToken) {
        if (modifiersToken == null || modifiersToken.getType() != 5) {
            throw new IllegalArgumentException("expected non-null AST-token with type 'MODIFIERS'");
        }
        AccessModifier accessModifier = AccessModifier.PACKAGE;
        for (DetailAST token = modifiersToken.getFirstChild(); token != null; token = token.getNextSibling()) {
            int tokenType = token.getType();
            if (tokenType == 62) {
                accessModifier = AccessModifier.PUBLIC;
                continue;
            }
            if (tokenType == 63) {
                accessModifier = AccessModifier.PROTECTED;
                continue;
            }
            if (tokenType != 61) continue;
            accessModifier = AccessModifier.PRIVATE;
        }
        return accessModifier;
    }

    public static Set<String> parseClassNames(String ... classNames) {
        HashSet<String> illegalClassNames = new HashSet<String>();
        for (String name : classNames) {
            illegalClassNames.add(name);
            int lastDot = name.lastIndexOf(46);
            if (lastDot == -1 || lastDot >= name.length() - 1) continue;
            String shortName = name.substring(name.lastIndexOf(46) + 1);
            illegalClassNames.add(shortName);
        }
        return illegalClassNames;
    }
}

