/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.check;

import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.source.formatter.BNDSettings;
import com.liferay.source.formatter.check.BaseFileCheck;
import com.liferay.source.formatter.check.util.BNDSourceUtil;
import com.liferay.source.formatter.util.GradleBuildFile;
import com.liferay.source.formatter.util.GradleDependency;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;

public class UpgradeGradleIncludeResourceCheck
extends BaseFileCheck {
    @Override
    protected String doProcess(String fileName, String absolutePath, String content) throws IOException {
        if (!absolutePath.endsWith("/build.gradle")) {
            return content;
        }
        return this._formatDependencies(fileName, content);
    }

    private String _formatDependencies(String fileName, String content) throws IOException {
        List<String> includeResourceJars = this._getIncludeResourceJars(fileName = StringUtil.replace(fileName, '\\', '/'));
        if (ListUtil.isEmpty(includeResourceJars)) {
            return content;
        }
        GradleBuildFile gradleBuildFile = new GradleBuildFile(content);
        List<GradleDependency> gradleDependencies = gradleBuildFile.getGradleDependencies();
        Iterator<GradleDependency> iterator = gradleDependencies.iterator();
        while (iterator.hasNext()) {
            GradleDependency gradleDependency = iterator.next();
            boolean hasDependency = false;
            for (String includeResourceJar : includeResourceJars) {
                String dependencyConfiguration = gradleDependency.getConfiguration();
                if (!includeResourceJar.contains(gradleDependency.getName()) || dependencyConfiguration.equals("compileInclude")) continue;
                hasDependency = true;
                break;
            }
            if (hasDependency) continue;
            iterator.remove();
        }
        if (gradleDependencies.isEmpty()) {
            return content;
        }
        for (GradleDependency gradleDependency : gradleDependencies) {
            gradleBuildFile.insertGradleDependency("compileInclude", gradleDependency.getGroup(), gradleDependency.getName(), gradleDependency.getVersion());
        }
        gradleBuildFile.deleteGradleDependencies(gradleDependencies);
        String source = gradleBuildFile.getSource();
        return source.concat("\n\nliferayOSGi {\n\texpandCompileInclude = true\n}");
    }

    private List<String> _getIncludeResourceJars(String fileName) throws IOException {
        BNDSettings bndSettings = this.getBNDSettings(fileName);
        if (bndSettings == null) {
            return null;
        }
        String bndSettingsContent = bndSettings.getContent();
        List<String> includeResourceJars = BNDSourceUtil.getDefinitionValues(bndSettingsContent, "-includeresource");
        includeResourceJars.addAll(BNDSourceUtil.getDefinitionValues(bndSettingsContent, "Include-Resource"));
        return includeResourceJars;
    }
}

