/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.util;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.module.util.SystemBundleUtil;
import com.liferay.portal.kernel.util.Validator;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.SortedMap;
import java.util.function.Consumer;
import org.osgi.util.tracker.ServiceTracker;

public class SystemCheckerUtil {
    private static final Log _log = LogFactoryUtil.getLog(SystemCheckerUtil.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void runSystemCheckers(Consumer<String> infoConsumer, Consumer<String> warnConsumer) {
        ServiceTracker serviceTracker = new ServiceTracker(SystemBundleUtil.getBundleContext(), "com.liferay.portal.osgi.debug.SystemChecker", null);
        serviceTracker.open(true);
        SortedMap trackedMap = serviceTracker.getTracked();
        Collection systemCheckers = trackedMap.values();
        infoConsumer.accept("Available checkers: " + systemCheckers);
        try {
            for (Object systemChecker : systemCheckers) {
                StringBundler sb = new StringBundler(5);
                sb.append("Running \"");
                Class<?> clazz = systemChecker.getClass();
                try {
                    Method method = clazz.getMethod("getName", new Class[0]);
                    method.setAccessible(true);
                    String name = (String)method.invoke(systemChecker, new Object[0]);
                    sb.append(name);
                    sb.append("\". You can run this by itself with command \"");
                    method = clazz.getMethod("getOSGiCommand", new Class[0]);
                    method.setAccessible(true);
                    sb.append(method.invoke(systemChecker, new Object[0]));
                    sb.append("\" in gogo shell.");
                    infoConsumer.accept(sb.toString());
                    method = clazz.getMethod("check", new Class[0]);
                    method.setAccessible(true);
                    String result = (String)method.invoke(systemChecker, new Object[0]);
                    if (Validator.isNull(result)) {
                        infoConsumer.accept(name + " check result: No issues were found.");
                        continue;
                    }
                    warnConsumer.accept(name + " check result: " + result);
                }
                catch (ReflectiveOperationException reflectiveOperationException) {
                    _log.error(reflectiveOperationException);
                }
            }
        }
        finally {
            serviceTracker.close();
        }
    }
}

