/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checkstyle.check;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.tools.ToolsUtil;
import com.liferay.source.formatter.checkstyle.check.BaseCheck;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.FullIdent;
import java.util.List;
import java.util.Objects;

public abstract class BaseAsUsedCheck
extends BaseCheck {
    private static final String _MSG_ADD_TO_STRING = "to.string.add";
    private static final String _MSG_INLINE_VARIABLE = "variable.inline";
    private static final String _MSG_MOVE_VARIABLE_AFTER_BRANCHING_STATEMENT = "variable.move.after.branching.statement";
    private static final String _MSG_MOVE_VARIABLE_INSIDE_IF_STATEMENT = "variable.move.inside.if.statement";
    private static final String _MSG_USE_STRING_VALUE_OF = "string.value.of.use";

    protected void checkInline(DetailAST assignDetailAST, String variableName, DetailAST identDetailAST, List<DetailAST> dependentIdentDetailASTList) {
        if (!variableName.equals(identDetailAST.getText())) {
            return;
        }
        DetailAST assignExpressionDetailAST = this._getAssignExpressionDetailAST(assignDetailAST);
        if (assignExpressionDetailAST == null) {
            return;
        }
        String assignExpressionType = null;
        boolean chainStyle = false;
        if (assignExpressionDetailAST.getType() == 27) {
            if (this._hasChainStyle(assignExpressionDetailAST, "build", "create.*", "map", "put")) {
                if (this._isInsideStatementClause(identDetailAST)) {
                    return;
                }
                chainStyle = true;
            } else {
                if (this.getStartLineNumber(assignExpressionDetailAST) != this.getEndLineNumber(assignExpressionDetailAST) && (this.hasParentWithTokenType(identDetailAST, ARITHMETIC_OPERATOR_TOKEN_TYPES) || this.hasParentWithTokenType(identDetailAST, RELATIONAL_OPERATOR_TOKEN_TYPES)) && this.hasParentWithTokenType(identDetailAST, 27) || this._isInsideStatementClause(identDetailAST) && this.hasParentWithTokenType(identDetailAST, RELATIONAL_OPERATOR_TOKEN_TYPES)) {
                    return;
                }
                if (!this._matchesGetOrSetCall(assignExpressionDetailAST, identDetailAST, variableName)) {
                    return;
                }
            }
            assignExpressionType = "method call";
        } else if (assignExpressionDetailAST.getType() == 136) {
            DetailAST objBlockDetailAST = assignExpressionDetailAST.findFirstToken(6);
            if (objBlockDetailAST != null) {
                return;
            }
            List<DetailAST> typeArgumentsDetailASTList = null;
            DetailAST parentDetailAST = assignDetailAST.getParent();
            typeArgumentsDetailASTList = parentDetailAST.getType() == 10 ? this.getAllChildTokens(parentDetailAST, true, 163) : this.getAllChildTokens(assignDetailAST, true, 163);
            if (!typeArgumentsDetailASTList.isEmpty()) {
                return;
            }
            DetailAST elistDetailAST = assignExpressionDetailAST.findFirstToken(34);
            if (elistDetailAST == null || elistDetailAST.getChildCount() > 0) {
                return;
            }
            assignExpressionType = "new instance";
        } else {
            return;
        }
        if (this._isInsideMockitoMethodCall(identDetailAST)) {
            return;
        }
        DetailAST parentDetailAST = identDetailAST.getParent();
        if (parentDetailAST.getType() == 132) {
            parentDetailAST = parentDetailAST.getParent();
        }
        boolean toString = false;
        if (parentDetailAST.getType() == 59) {
            FullIdent fullIdent = FullIdent.createFullIdent((DetailAST)parentDetailAST);
            if (!Objects.equals(fullIdent.getText(), variableName + ".toString")) {
                return;
            }
            toString = true;
        } else if (parentDetailAST.getType() != 28) {
            return;
        }
        int endLineNumber = this.getEndLineNumber(assignDetailAST);
        for (DetailAST dependentIdentDetailAST : dependentIdentDetailASTList) {
            if (!variableName.equals(dependentIdentDetailAST.getText()) || this.equals(dependentIdentDetailAST, identDetailAST) || dependentIdentDetailAST.getLineNo() <= endLineNumber) continue;
            return;
        }
        parentDetailAST = this.getParentWithTokenType(identDetailAST, 181, 85, 91, 136, 67, 95, 84);
        if (parentDetailAST != null && parentDetailAST.getLineNo() >= assignDetailAST.getLineNo()) {
            return;
        }
        int emptyLineCount = 0;
        for (int i = endLineNumber; i <= identDetailAST.getLineNo(); ++i) {
            if (!Validator.isNull(this.getLine(i - 1)) || ++emptyLineCount <= 1) continue;
            return;
        }
        if (!toString) {
            this.log(assignDetailAST, _MSG_INLINE_VARIABLE, new Object[]{variableName, assignExpressionType, identDetailAST.getLineNo()});
        } else if (chainStyle) {
            String variableTypeName = this.getVariableTypeName(identDetailAST, variableName, false);
            if (variableTypeName.equals("JSONArray") || variableTypeName.equals("JSONObject")) {
                this.log(identDetailAST, _MSG_ADD_TO_STRING, new Object[]{assignDetailAST.getLineNo()});
            }
        } else {
            this.log(identDetailAST, _MSG_USE_STRING_VALUE_OF, new Object[]{assignDetailAST.getLineNo(), identDetailAST.getLineNo()});
        }
    }

    protected void checkMoveAfterBranchingStatement(DetailAST detailAST, DetailAST assignDetailAST, String variableName, DetailAST firstDependentIdentDetailAST, int actionLineNumber) {
        int endLineNumber = this.getEndLineNumber(assignDetailAST);
        DetailAST lastBranchingStatementDetailAST = this._getLastBranchingStatementDetailAST(detailAST, endLineNumber, this._getClosestParentLineNumber(firstDependentIdentDetailAST, endLineNumber));
        if (lastBranchingStatementDetailAST == null) {
            return;
        }
        int lineNumber = lastBranchingStatementDetailAST.getLineNo();
        if (actionLineNumber == -1 || actionLineNumber > lineNumber) {
            this.log(assignDetailAST, _MSG_MOVE_VARIABLE_AFTER_BRANCHING_STATEMENT, new Object[]{variableName, lastBranchingStatementDetailAST.getText(), lastBranchingStatementDetailAST.getLineNo()});
        }
    }

    protected void checkMoveInsideIfStatement(DetailAST assignDetailAST, DetailAST nameDetailAST, String variableName, DetailAST firstDependentIdentDetailAST, DetailAST lastDependentIdentDetailAST, int actionLineNumber) {
        DetailAST elseOrIfStatementDetailAST = this._getElseOrIfStatementDetailAST(firstDependentIdentDetailAST, this.getEndLineNumber(assignDetailAST));
        if (elseOrIfStatementDetailAST == null) {
            return;
        }
        DetailAST parentDetailAST = this.getParentWithTokenType(elseOrIfStatementDetailAST, 181, 85, 91, 136, 67, 95, 84);
        if (parentDetailAST != null && parentDetailAST.getLineNo() >= assignDetailAST.getLineNo()) {
            return;
        }
        DetailAST slistDetailAST = elseOrIfStatementDetailAST.findFirstToken(7);
        if (this.getEndLineNumber(slistDetailAST) <= lastDependentIdentDetailAST.getLineNo()) {
            return;
        }
        if (actionLineNumber != -1) {
            DetailAST grandParentDetailAST;
            parentDetailAST = elseOrIfStatementDetailAST;
            while ((grandParentDetailAST = parentDetailAST.getParent()).getType() == 92 || grandParentDetailAST.getType() == 83) {
                parentDetailAST = grandParentDetailAST;
            }
            if (actionLineNumber < parentDetailAST.getLineNo()) {
                return;
            }
        }
        if (elseOrIfStatementDetailAST.getType() == 92) {
            this.log(nameDetailAST, _MSG_MOVE_VARIABLE_INSIDE_IF_STATEMENT, new Object[]{variableName, "else", elseOrIfStatementDetailAST.getLineNo()});
        } else {
            parentDetailAST = elseOrIfStatementDetailAST.getParent();
            if (parentDetailAST.getType() == 92) {
                this.log(nameDetailAST, _MSG_MOVE_VARIABLE_INSIDE_IF_STATEMENT, new Object[]{variableName, "else if", elseOrIfStatementDetailAST.getLineNo()});
            } else {
                this.log(nameDetailAST, _MSG_MOVE_VARIABLE_INSIDE_IF_STATEMENT, new Object[]{variableName, "if", elseOrIfStatementDetailAST.getLineNo()});
            }
        }
    }

    protected int getActionLineNumber(DetailAST detailAST) {
        String actionNameRegex = StringBundler.concat("_?(re|un)?(add|calculate|channel|close|copy|create|decode|delete|", "encode|execute|finish|import|increment|manage|next|open|post|put|", "read|register|resolve|run|send|set|start|stop|test|transform|", "update|upsert|zip)([A-Z].*)?");
        if (this._containsMethodName(detailAST, actionNameRegex, "currentTimeMillis", "getCurrentTimeMillis", "nextVersion", "toString") || this._containsVariableType(detailAST, "ActionQueue", "File")) {
            return detailAST.getLineNo();
        }
        if (detailAST.getType() != 10) {
            return -1;
        }
        List<DetailAST> dependentIdentDetailASTList = this.getDependentIdentDetailASTList(detailAST, detailAST.getLineNo(), true);
        for (DetailAST dependentIdentDetailAST : dependentIdentDetailASTList) {
            String methodName;
            DetailAST parentDetailAST;
            DetailAST elistDetailAST = this.getParentWithTokenType(dependentIdentDetailAST, 34);
            if (elistDetailAST == null || (parentDetailAST = elistDetailAST.getParent()).getType() != 27 || !(methodName = this.getMethodName(parentDetailAST)).matches(actionNameRegex)) continue;
            return dependentIdentDetailAST.getLineNo();
        }
        return -1;
    }

    private boolean _containsMethodName(DetailAST variableDefinitionDetailAST, String ... methodNameRegexArray) {
        List<DetailAST> methodCallDetailASTList = this.getAllChildTokens(variableDefinitionDetailAST, true, 27);
        for (DetailAST methodCallDetailAST : methodCallDetailASTList) {
            String methodName = this.getMethodName(methodCallDetailAST);
            for (String methodNameRegex : methodNameRegexArray) {
                if (!methodName.matches(methodNameRegex)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean _containsVariableType(DetailAST variableDefinitionDetailAST, String ... variableTypeNames) {
        List<DetailAST> identDetailASTList = this.getAllChildTokens(variableDefinitionDetailAST, true, 58);
        for (DetailAST identDetailAST : identDetailASTList) {
            if (!ArrayUtil.contains(variableTypeNames, this.getVariableTypeName(identDetailAST, identDetailAST.getText(), false))) continue;
            return true;
        }
        return false;
    }

    private DetailAST _getAssignExpressionDetailAST(DetailAST assignDetailAST) {
        DetailAST firstChildDetailAST = assignDetailAST.getFirstChild();
        if (firstChildDetailAST == null) {
            return null;
        }
        if (firstChildDetailAST.getType() == 28) {
            return firstChildDetailAST.getFirstChild();
        }
        if (firstChildDetailAST.getType() == 58) {
            return firstChildDetailAST.getNextSibling();
        }
        return null;
    }

    private int _getClosestParentLineNumber(DetailAST firstNameDetailAST, int lineNumber) {
        int closestLineNumber = firstNameDetailAST.getLineNo();
        DetailAST parentDetailAST = firstNameDetailAST.getParent();
        while (parentDetailAST.getLineNo() > lineNumber) {
            closestLineNumber = parentDetailAST.getLineNo();
            parentDetailAST = parentDetailAST.getParent();
        }
        return closestLineNumber;
    }

    private DetailAST _getElseOrIfStatementDetailAST(DetailAST detailAST, int lineNumber) {
        DetailAST elseOrIfStatementDetailAST = null;
        DetailAST slistDetailAST = this.getParentWithTokenType(detailAST, 7);
        while (slistDetailAST != null && slistDetailAST.getLineNo() >= lineNumber) {
            DetailAST parentDetailAST = slistDetailAST.getParent();
            if (parentDetailAST.getType() == 92 || parentDetailAST.getType() == 83) {
                elseOrIfStatementDetailAST = parentDetailAST;
            }
            slistDetailAST = this.getParentWithTokenType(slistDetailAST, 7);
        }
        return elseOrIfStatementDetailAST;
    }

    private DetailAST _getLastBranchingStatementDetailAST(DetailAST detailAST, int start, int end) {
        DetailAST lastBranchingStatementDetailAST = null;
        List<DetailAST> branchingStatementDetailASTList = this.getAllChildTokens(detailAST, true, 86, 87, 88, 90);
        for (DetailAST branchingStatementDetailAST : branchingStatementDetailASTList) {
            int lineNumber = this.getEndLineNumber(branchingStatementDetailAST);
            if (start >= lineNumber || end <= lineNumber) continue;
            DetailAST branchedStatementDetailAST = null;
            branchedStatementDetailAST = branchingStatementDetailAST.getType() == 86 || branchingStatementDetailAST.getType() == 87 ? this.getParentWithTokenType(branchingStatementDetailAST, 85, 91, 84) : this.getParentWithTokenType(branchingStatementDetailAST, 8, 181, 9);
            if (branchedStatementDetailAST == null || branchedStatementDetailAST.getLineNo() >= start || lastBranchingStatementDetailAST != null && branchingStatementDetailAST.getLineNo() <= lastBranchingStatementDetailAST.getLineNo()) continue;
            lastBranchingStatementDetailAST = branchingStatementDetailAST;
        }
        return lastBranchingStatementDetailAST;
    }

    private boolean _hasChainStyle(DetailAST methodCallDetailAST, String ... methodNameRegexArray) {
        int startLineNumber = this.getStartLineNumber(methodCallDetailAST);
        String line = this.getLine(startLineNumber - 1);
        if (!line.endsWith("(") || ToolsUtil.getLevel(line) != 1) {
            return false;
        }
        for (String methodNameRegex : methodNameRegexArray) {
            if (!line.matches(".*[\\.>]" + methodNameRegex + "\\(")) continue;
            int level = 1;
            for (int i = startLineNumber + 1; i <= this.getEndLineNumber(methodCallDetailAST); ++i) {
                line = StringUtil.trim(this.getLine(i - 1));
                if (line.startsWith(").") && level == 1) {
                    return true;
                }
                level += ToolsUtil.getLevel(line);
            }
        }
        return false;
    }

    private boolean _isInsideMockitoMethodCall(DetailAST detailAST) {
        DetailAST methodCallDetailAST = this.getParentWithTokenType(detailAST, 27);
        if (methodCallDetailAST == null) {
            return false;
        }
        for (String name : this.getNames(methodCallDetailAST, true)) {
            if (!Objects.equals(name, "Mockito")) continue;
            return true;
        }
        return false;
    }

    private boolean _isInsideStatementClause(DetailAST detailAST) {
        DetailAST parentDetailAST = detailAST.getParent();
        DetailAST grandParentDetailAST;
        while ((grandParentDetailAST = parentDetailAST.getParent()) != null) {
            if (grandParentDetailAST.getType() == 91) {
                return parentDetailAST.getType() == 36 || parentDetailAST.getType() == 156 || parentDetailAST.getType() == 35 || parentDetailAST.getType() == 37;
            }
            if (grandParentDetailAST.getType() == 95) {
                return parentDetailAST.getType() == 176;
            }
            if (grandParentDetailAST.getType() == 84) {
                return parentDetailAST.getType() == 28;
            }
            parentDetailAST = grandParentDetailAST;
        }
        return false;
    }

    private boolean _matchesGetOrSetCall(DetailAST assignMethodCallDetailAST, DetailAST identDetailAST, String variableName) {
        String methodName = this.getMethodName(assignMethodCallDetailAST);
        if (methodName.matches("(?i)_?get" + variableName)) {
            return true;
        }
        DetailAST parentDetailAST = identDetailAST.getParent();
        if (parentDetailAST.getType() != 28) {
            return false;
        }
        if ((parentDetailAST = parentDetailAST.getParent()).getType() != 34 || parentDetailAST.getChildCount() != 1) {
            return false;
        }
        if ((parentDetailAST = parentDetailAST.getParent()).getType() != 27) {
            return false;
        }
        methodName = this.getMethodName(parentDetailAST);
        return methodName.matches("(?i)_?set" + variableName);
    }
}

