/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checkstyle.check;

import com.liferay.petra.string.StringBundler;
import com.liferay.source.formatter.checkstyle.check.BaseCheck;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class ExceptionCheck
extends BaseCheck {
    private static final String _MSG_UNNECESSARY_EXCEPTION = "exception.unnecessary";

    public int[] getDefaultTokens() {
        return new int[]{9};
    }

    @Override
    protected void doVisitToken(DetailAST detailAST) {
        DetailAST modifiersDetailAST = detailAST.findFirstToken(5);
        if (modifiersDetailAST == null || !modifiersDetailAST.branchContains(61)) {
            return;
        }
        List<String> exceptionNames = this._getExceptionNames(detailAST);
        if (exceptionNames.isEmpty() || exceptionNames.contains("Exception")) {
            return;
        }
        this._checkException(detailAST, exceptionNames);
    }

    private void _checkException(DetailAST methodDefinitionDetailAST, List<String> exceptionNames) {
        DetailAST classDefinitionDetailAST = null;
        DetailAST parentDetailAST = methodDefinitionDetailAST;
        while ((parentDetailAST = this.getParentWithTokenType(parentDetailAST, 14, 15)) != null) {
            classDefinitionDetailAST = parentDetailAST;
        }
        if (classDefinitionDetailAST == null) {
            return;
        }
        String methodName = this.getName(methodDefinitionDetailAST);
        List<DetailAST> identDetailASTList = this.getAllChildTokens(classDefinitionDetailAST, true, 58);
        boolean calledByMethodWithException = false;
        for (DetailAST identDetailAST : identDetailASTList) {
            List<String> methodExceptionNames;
            if (!methodName.equals(identDetailAST.getText())) continue;
            parentDetailAST = this.getParentWithTokenType(identDetailAST, 181, 95, 180);
            if (parentDetailAST != null) {
                return;
            }
            parentDetailAST = this.getParentWithTokenType(identDetailAST, 8, 9);
            if (parentDetailAST == null) {
                return;
            }
            DetailAST nameDetailAST = parentDetailAST.findFirstToken(58);
            if (methodName.equals(nameDetailAST.getText()) || (methodExceptionNames = this._getExceptionNames(parentDetailAST)).isEmpty()) continue;
            if (methodExceptionNames.size() == 1 && Objects.equals(methodExceptionNames.get(0), "Exception")) {
                calledByMethodWithException = true;
                continue;
            }
            return;
        }
        if (calledByMethodWithException) {
            this.log(methodDefinitionDetailAST, _MSG_UNNECESSARY_EXCEPTION, new Object[]{methodName, this._getExceptionNamesString(exceptionNames)});
        }
    }

    private List<String> _getExceptionNames(DetailAST detailAST) {
        DetailAST literalThrowsDetailAST = detailAST.findFirstToken(81);
        if (literalThrowsDetailAST == null) {
            return Collections.emptyList();
        }
        return this.getNames(literalThrowsDetailAST, false);
    }

    private String _getExceptionNamesString(List<String> exceptionNames) {
        StringBundler sb = new StringBundler();
        for (int i = 0; i < exceptionNames.size(); ++i) {
            sb.append("'");
            sb.append(exceptionNames.get(i));
            sb.append("'");
            if (i < exceptionNames.size() - 2) {
                sb.append(", ");
                continue;
            }
            if (i >= exceptionNames.size() - 1) continue;
            sb.append(" and ");
        }
        return sb.toString();
    }
}

