/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.util;

public class PrimitiveLongList {
    private long[] _elements;
    private int _elementsSize;

    public PrimitiveLongList() {
        this._elements = new long[10];
    }

    public PrimitiveLongList(int capacity) {
        this._elements = new long[capacity];
    }

    public void add(long value) {
        this._checkCapacity(this._elementsSize + 1);
        this._elements[this._elementsSize++] = value;
    }

    public void addAll(long[] values) {
        this._checkCapacity(this._elementsSize + values.length);
        System.arraycopy(values, 0, this._elements, this._elementsSize, values.length);
        this._elementsSize += values.length;
    }

    public long[] getArray() {
        this._trim();
        return this._elements;
    }

    public int size() {
        return this._elementsSize;
    }

    private void _checkCapacity(int minSize) {
        int oldSize = this._elements.length;
        if (minSize > oldSize) {
            long[] previousElements = this._elements;
            int newCapacity = oldSize * 3 / 2 + 1;
            if (newCapacity < minSize) {
                newCapacity = minSize;
            }
            this._elements = new long[newCapacity];
            System.arraycopy(previousElements, 0, this._elements, 0, this._elementsSize);
        }
    }

    private void _trim() {
        int oldSize = this._elements.length;
        if (this._elementsSize < oldSize) {
            long[] previousElements = this._elements;
            this._elements = new long[this._elementsSize];
            System.arraycopy(previousElements, 0, this._elements, 0, this._elementsSize);
        }
    }
}

