/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.check;

import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.source.formatter.SourceFormatterExcludes;
import com.liferay.source.formatter.check.BaseFileCheck;
import com.liferay.source.formatter.util.FileUtil;
import com.liferay.source.formatter.util.GradleBuildFile;
import com.liferay.source.formatter.util.GradleDependency;
import com.liferay.source.formatter.util.SourceFormatterUtil;
import java.io.File;
import java.io.IOException;
import java.util.List;

public class GradleMissingDependenciesForUpgradeJava21Check
extends BaseFileCheck {
    @Override
    public boolean isLiferaySourceCheck() {
        return true;
    }

    @Override
    protected String doProcess(String fileName, String absolutePath, String content) throws IOException {
        if (!absolutePath.endsWith("/build.gradle")) {
            return content;
        }
        int x = absolutePath.lastIndexOf(47);
        File bndFile = new File(absolutePath.substring(0, x + 1) + "bnd.bnd");
        if (!bndFile.exists()) {
            return content;
        }
        String dirName = absolutePath.substring(0, x);
        int y = dirName.lastIndexOf(47);
        String shortDirName = dirName.substring(y + 1);
        List<String> javaFileNames = SourceFormatterUtil.scanForFileNames(absolutePath.substring(0, x + 1), new String[0], new String[]{"**/*.java"}, new SourceFormatterExcludes(), false);
        for (String javaFileName : javaFileNames) {
            String javaFileContent = FileUtil.read(new File(javaFileName));
            if (javaFileContent.contains("import javax.annotation.")) {
                content = shortDirName.endsWith("-test") ? this._fixMissingDependencies(content, "testIntegrationImplementation", "javax.annotation", "javax.annotation-api", "1.3.2") : this._fixMissingDependencies(content, "compileOnly", "javax.annotation", "javax.annotation-api", "1.3.2");
            }
            if (!javaFileContent.contains("import javax.xml.bind.annotation.")) continue;
            if (shortDirName.endsWith("-test")) {
                content = this._fixMissingDependencies(content, "testIntegrationImplementation", "javax.xml.bind", "jaxb-api", "2.3.0");
                continue;
            }
            content = this._fixMissingDependencies(content, "compileOnly", "javax.xml.bind", "jaxb-api", "2.3.0");
        }
        return content;
    }

    private String _fixMissingDependencies(String content, String configuration, String group, String name, String version) {
        GradleBuildFile gradleBuildFile = new GradleBuildFile(content);
        for (GradleDependency gradleDependency : gradleBuildFile.getGradleDependencies()) {
            String gradleDependencyConfiguration = gradleDependency.getConfiguration();
            String gradleDependencyGroup = gradleDependency.getGroup();
            String gradleDependencyName = gradleDependency.getName();
            if (!StringUtil.equals(gradleDependencyConfiguration, configuration) || !StringUtil.equals(gradleDependencyGroup, group) || !StringUtil.equals(gradleDependencyName, name)) continue;
            return content;
        }
        gradleBuildFile.insertGradleDependency(configuration, group, name, version);
        return gradleBuildFile.getSource();
    }
}

