/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checkstyle.check;

import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.source.formatter.checkstyle.check.BaseCheck;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.utils.AnnotationUtil;

public class BrandNameCheck
extends BaseCheck {
    private static final String[] _BRAND_NAMES = new String[]{"FreeMarker", "JavaScript"};
    private static final String _MSG_RENAME = "rename";

    public int[] getDefaultTokens() {
        return new int[]{14, 154, 15, 9, 21, 178, 10};
    }

    @Override
    protected void doVisitToken(DetailAST detailAST) {
        if (detailAST.getType() == 9 && AnnotationUtil.containsAnnotation((DetailAST)detailAST, (String)"Override")) {
            return;
        }
        String name = this.getName(detailAST);
        String tokenTypeName = this.getTokenTypeName(detailAST);
        for (String brandName : _BRAND_NAMES) {
            String lowerCaseTypeName;
            String lowerCaseBrandName = StringUtil.toLowerCase(brandName);
            if ((detailAST.getType() == 21 || detailAST.getType() == 178 || detailAST.getType() == 10) && (lowerCaseTypeName = StringUtil.toLowerCase(this.getTypeName(detailAST, false))).contains(lowerCaseBrandName)) continue;
            if (name.startsWith(lowerCaseBrandName)) {
                String newName = StringUtil.lowerCaseFirstLetter(brandName) + name.substring(lowerCaseBrandName.length());
                this.log(detailAST, _MSG_RENAME, new Object[]{tokenTypeName, name, newName});
                return;
            }
            String upperCaseBrandName = StringUtil.upperCaseFirstLetter(lowerCaseBrandName);
            int x = name.indexOf(upperCaseBrandName);
            if (x == -1) continue;
            String newName = name.substring(0, x) + brandName + name.substring(x + brandName.length());
            this.log(detailAST, _MSG_RENAME, new Object[]{tokenTypeName, name, newName});
            return;
        }
    }
}

