<%--
/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */
--%>

<%@ include file="/dynamic_include/init.jsp" %>

<aui:script sandbox="<%= true %>">
	var onShare = function(data) {
		if (window.Analytics) {
			Analytics.send(
				'shared',
				'SocialBookmarks',
				{
					className: data.className,
					classPK: data.classPK,
					type: data.type,
					url: data.url
				}
			);
		}
	}

	var onDestroyPortlet = function() {
		Liferay.detach('socialBookmarks:share', onShare);
		Liferay.detach('destroyPortlet', onDestroyPortlet);
	}

	Liferay.on('socialBookmarks:share', onShare);
	Liferay.on('destroyPortlet', onDestroyPortlet);
</aui:script>