/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.site.navigation.internal.upgrade.v3_0_0;

import com.liferay.asset.kernel.model.AssetVocabulary;
import com.liferay.asset.kernel.service.AssetVocabularyLocalService;
import com.liferay.document.library.kernel.model.DLFileEntry;
import com.liferay.journal.model.JournalArticle;
import com.liferay.journal.service.JournalArticleLocalService;
import com.liferay.knowledge.base.model.KBArticle;
import com.liferay.knowledge.base.service.KBArticleLocalService;
import com.liferay.object.model.ObjectDefinition;
import com.liferay.object.model.ObjectEntry;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.dao.jdbc.AutoBatchPreparedStatementUtil;
import com.liferay.portal.kernel.model.ExternalReferenceCodeModel;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.service.LayoutLocalService;
import com.liferay.portal.kernel.service.PersistedModelLocalService;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.portal.kernel.util.UnicodePropertiesBuilder;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.service.PersistedModelLocalServiceRegistryUtil;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.Objects;

public class SiteNavigationMenuItemExternalReferenceCodeUpgradeProcess
extends UpgradeProcess {
    private final AssetVocabularyLocalService _assetVocabularyLocalService;
    private final JournalArticleLocalService _journalArticleLocalService;
    private final KBArticleLocalService _kbArticleLocalService;
    private final LayoutLocalService _layoutLocalService;

    public SiteNavigationMenuItemExternalReferenceCodeUpgradeProcess(AssetVocabularyLocalService assetVocabularyLocalService, JournalArticleLocalService journalArticleLocalService, KBArticleLocalService kbArticleLocalService, LayoutLocalService layoutLocalService) {
        this._assetVocabularyLocalService = assetVocabularyLocalService;
        this._journalArticleLocalService = journalArticleLocalService;
        this._kbArticleLocalService = kbArticleLocalService;
        this._layoutLocalService = layoutLocalService;
    }

    protected void doUpgrade() throws Exception {
        try (PreparedStatement preparedStatement1 = this.connection.prepareStatement("select ctCollectionId, siteNavigationMenuItemId, type_, typeSettings from SiteNavigationMenuItem");
             PreparedStatement preparedStatement2 = AutoBatchPreparedStatementUtil.concurrentAutoBatch((Connection)this.connection, (String)"update SiteNavigationMenuItem set typeSettings = ? where ctCollectionId = ? and siteNavigationMenuItemId = ?");
             ResultSet resultSet = preparedStatement1.executeQuery();){
            while (resultSet.next()) {
                this._upgradeSiteNavigationMenuItem(preparedStatement2, resultSet);
            }
            preparedStatement2.executeBatch();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void _upgradeSiteNavigationMenuItem(PreparedStatement preparedStatement2, ResultSet resultSet) throws Exception {
        String externalReferenceCode;
        UnicodeProperties typeSettingsUnicodeProperties;
        block29: {
            AssetVocabulary persistedModel = null;
            typeSettingsUnicodeProperties = UnicodePropertiesBuilder.fastLoad((String)resultSet.getString("typeSettings")).build();
            String className = typeSettingsUnicodeProperties.getProperty("className");
            String type = resultSet.getString("type_");
            if (Objects.equals(type, "asset_vocabulary")) {
                persistedModel = this._assetVocabularyLocalService.fetchAssetVocabularyByUuidAndGroupId(typeSettingsUnicodeProperties.getProperty("uuid"), GetterUtil.getLong((String)typeSettingsUnicodeProperties.getProperty("groupId")));
            } else if (Objects.equals(type, JournalArticle.class.getName())) {
                persistedModel = this._journalArticleLocalService.getLatestArticle(GetterUtil.getLong((String)typeSettingsUnicodeProperties.getProperty("classPK")));
            } else if (Objects.equals(type, KBArticle.class.getName())) {
                persistedModel = this._kbArticleLocalService.getLatestKBArticle(GetterUtil.getLong((String)typeSettingsUnicodeProperties.getProperty("classPK")));
            } else if (Objects.equals(type, "layout")) {
                persistedModel = this._layoutLocalService.fetchLayoutByUuidAndGroupId(typeSettingsUnicodeProperties.getProperty("layoutUuid"), GetterUtil.getLong((String)typeSettingsUnicodeProperties.getProperty("groupId")), GetterUtil.getBoolean((String)typeSettingsUnicodeProperties.getProperty("privateLayout")));
            } else {
                if (className == null) {
                    return;
                }
                if (className.equals(FileEntry.class.getName())) {
                    className = DLFileEntry.class.getName();
                } else if (className.contains(ObjectDefinition.class.getName())) {
                    className = ObjectEntry.class.getName();
                }
                PersistedModelLocalService persistedModelLocalService = PersistedModelLocalServiceRegistryUtil.getPersistedModelLocalService((String)className);
                persistedModel = persistedModelLocalService.getPersistedModel((Serializable)Long.valueOf(GetterUtil.getLong((String)typeSettingsUnicodeProperties.getProperty("classPK"))));
            }
            if (persistedModel == null) {
                return;
            }
            externalReferenceCode = null;
            if (Objects.equals(className, "com.liferay.commerce.product.model.CPDefinition")) {
                String sql = StringBundler.concat((Object[])new Object[]{"select CProduct.externalReferenceCode from CProduct inner ", "join CPDefinition on CProduct.CProductId = CPDefinition.", "CProductId where CPDefinition.cpDefinitionId = ", GetterUtil.getLong((String)typeSettingsUnicodeProperties.getProperty("classPK"))});
                try (PreparedStatement preparedStatement3 = this.connection.prepareStatement(sql);
                     ResultSet resultSet3 = preparedStatement3.executeQuery();){
                    if (resultSet3.next()) {
                        externalReferenceCode = resultSet3.getString("externalReferenceCode");
                    }
                    break block29;
                }
            }
            if (persistedModel instanceof ExternalReferenceCodeModel) {
                ExternalReferenceCodeModel externalReferenceCodeModel = (ExternalReferenceCodeModel)persistedModel;
                externalReferenceCode = externalReferenceCodeModel.getExternalReferenceCode();
            }
        }
        if (Validator.isNull(externalReferenceCode)) {
            return;
        }
        typeSettingsUnicodeProperties.setProperty("externalReferenceCode", externalReferenceCode);
        preparedStatement2.setString(1, typeSettingsUnicodeProperties.toString());
        preparedStatement2.setLong(2, resultSet.getLong("ctCollectionId"));
        preparedStatement2.setLong(3, resultSet.getLong("siteNavigationMenuItemId"));
        preparedStatement2.addBatch();
    }
}

