/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.site.navigation.internal.model.listener;

import com.liferay.portal.kernel.exception.ModelListenerException;
import com.liferay.portal.kernel.model.BaseModelListener;
import com.liferay.portal.kernel.model.ModelListener;
import com.liferay.site.navigation.model.SiteNavigationMenu;
import com.liferay.staging.model.listener.StagingModelListener;

import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

/**
 * @author Máté Thurzó
 */
@Component(service = ModelListener.class)
public class SiteNavigationMenuStagingModelListener
	extends BaseModelListener<SiteNavigationMenu> {

	@Override
	public void onAfterCreate(SiteNavigationMenu siteNavigationMenu)
		throws ModelListenerException {

		_stagingModelListener.onAfterCreate(siteNavigationMenu);
	}

	@Override
	public void onAfterRemove(SiteNavigationMenu siteNavigationMenu)
		throws ModelListenerException {

		_stagingModelListener.onAfterRemove(siteNavigationMenu);
	}

	@Override
	public void onAfterUpdate(
			SiteNavigationMenu originalSiteNavigationMenu,
			SiteNavigationMenu siteNavigationMenu)
		throws ModelListenerException {

		_stagingModelListener.onAfterUpdate(siteNavigationMenu);
	}

	@Reference
	private StagingModelListener<SiteNavigationMenu> _stagingModelListener;

}