/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.site.navigation.internal.change.tracking.spi.reference;

import com.liferay.change.tracking.spi.reference.TableReferenceDefinition;
import com.liferay.change.tracking.spi.reference.builder.ChildTableReferenceInfoBuilder;
import com.liferay.change.tracking.spi.reference.builder.ParentTableReferenceInfoBuilder;
import com.liferay.portal.kernel.service.persistence.BasePersistence;
import com.liferay.site.navigation.model.SiteNavigationMenuItemTable;
import com.liferay.site.navigation.model.SiteNavigationMenuTable;
import com.liferay.site.navigation.service.persistence.SiteNavigationMenuItemPersistence;

import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

/**
 * @author Samuel Trong Tran
 */
@Component(service = TableReferenceDefinition.class)
public class SiteNavigationMenuItemTableReferenceDefinition
	implements TableReferenceDefinition<SiteNavigationMenuItemTable> {

	@Override
	public void defineChildTableReferences(
		ChildTableReferenceInfoBuilder<SiteNavigationMenuItemTable>
			childTableReferenceInfoBuilder) {
	}

	@Override
	public void defineParentTableReferences(
		ParentTableReferenceInfoBuilder<SiteNavigationMenuItemTable>
			parentTableReferenceInfoBuilder) {

		parentTableReferenceInfoBuilder.groupedModel(
			SiteNavigationMenuItemTable.INSTANCE
		).parentColumnReference(
			SiteNavigationMenuItemTable.INSTANCE.siteNavigationMenuItemId,
			SiteNavigationMenuItemTable.INSTANCE.parentSiteNavigationMenuItemId
		).singleColumnReference(
			SiteNavigationMenuItemTable.INSTANCE.siteNavigationMenuId,
			SiteNavigationMenuTable.INSTANCE.siteNavigationMenuId
		);
	}

	@Override
	public BasePersistence<?> getBasePersistence() {
		return _siteNavigationMenuItemPersistence;
	}

	@Override
	public SiteNavigationMenuItemTable getTable() {
		return SiteNavigationMenuItemTable.INSTANCE;
	}

	@Reference
	private SiteNavigationMenuItemPersistence
		_siteNavigationMenuItemPersistence;

}