/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.site.navigation.internal.model.listener;

import com.liferay.portal.kernel.exception.ModelListenerException;
import com.liferay.portal.kernel.model.BaseModelListener;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.ModelListener;
import com.liferay.site.navigation.constants.SiteNavigationConstants;
import com.liferay.site.navigation.model.SiteNavigationMenu;
import com.liferay.site.navigation.service.SiteNavigationMenuLocalService;

import java.util.List;

import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

/**
 * @author Eudaldo Alonso
 */
@Component(immediate = true, service = ModelListener.class)
public class GroupModelListener extends BaseModelListener<Group> {

	@Override
	public void onBeforeRemove(Group group) throws ModelListenerException {
		try {
			List<SiteNavigationMenu> siteNavigationMenus =
				_siteNavigationMenuLocalService.getSiteNavigationMenus(
					group.getGroupId());

			for (SiteNavigationMenu siteNavigationMenu : siteNavigationMenus) {
				if (siteNavigationMenu.getType() ==
						SiteNavigationConstants.TYPE_PRIMARY) {

					continue;
				}

				_siteNavigationMenuLocalService.deleteSiteNavigationMenu(
					siteNavigationMenu);
			}

			SiteNavigationMenu primarySiteNavigationMenu =
				_siteNavigationMenuLocalService.fetchPrimarySiteNavigationMenu(
					group.getGroupId());

			if (primarySiteNavigationMenu != null) {
				_siteNavigationMenuLocalService.deleteSiteNavigationMenu(
					primarySiteNavigationMenu);
			}
		}
		catch (Exception exception) {
			throw new ModelListenerException(exception);
		}
	}

	@Reference
	private SiteNavigationMenuLocalService _siteNavigationMenuLocalService;

}