/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.site.navigation.model.impl;

import aQute.bnd.annotation.ProviderType;

import com.liferay.petra.string.StringPool;
import com.liferay.site.navigation.constants.SiteNavigationConstants;

/**
 * @author Brian Wing Shun Chan
 */
@ProviderType
public class SiteNavigationMenuImpl extends SiteNavigationMenuBaseImpl {

	public String getTypeKey() {
		String navigationTypeKey = StringPool.BLANK;

		if (getType() == SiteNavigationConstants.TYPE_PRIMARY) {
			navigationTypeKey = "primary-navigation";
		}
		else if (getType() == SiteNavigationConstants.TYPE_PRIVATE) {
			navigationTypeKey = "private-navigation";
		}
		else if (getType() == SiteNavigationConstants.TYPE_SECONDARY) {
			navigationTypeKey = "secondary-navigation";
		}
		else if (getType() == SiteNavigationConstants.TYPE_SOCIAL) {
			navigationTypeKey = "social-navigation";
		}

		return navigationTypeKey;
	}

	public boolean isPrimary() {
		if (getType() == SiteNavigationConstants.TYPE_PRIMARY) {
			return true;
		}

		return false;
	}

}