/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

function main() {
	const EMAIL_REGEX = /^[\w-.]+@([\w-]+\.)+[\w-]{2,4}$/g;
	const EMAIL_INPUT_ID = '_com_liferay_login_web_portlet_LoginPortlet_login';
	const PASSWORD_INPUT_ID =
		'_com_liferay_login_web_portlet_LoginPortlet_password';

	const emailInput = document.getElementById(EMAIL_INPUT_ID);
	const passwordInput = document.getElementById(PASSWORD_INPUT_ID);
	const [emailLabel, passwordLabel] = document.querySelectorAll(
		'div.form-group label'
	);

	const TEXT_VARIANT = {
		danger: 'text-danger',
		success: 'text-success',
	};

	const isEmailValid = (email) => {
		const regex = new RegExp(EMAIL_REGEX);

		return regex.test(email);
	};

	function onInputChange(element, validation) {
		if (validation) {
			element.classList.remove(TEXT_VARIANT.danger);
			element.classList.add(TEXT_VARIANT.success);

			return;
		}

		element.classList.remove(TEXT_VARIANT.success);
		element.classList.add(TEXT_VARIANT.danger);
	}

	emailInput.addEventListener('change', () =>
		onInputChange(emailLabel, isEmailValid(emailInput.value))
	);

	passwordInput.addEventListener('change', () =>
		onInputChange(passwordLabel, passwordInput.value !== '')
	);
}

if (!themeDisplay.isSignedIn()) {
	main();
}
