/* eslint-disable no-undef */
/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

const button = fragmentElement.querySelector('.cookie-banner-button');
const cookieBanner = fragmentElement.querySelector('.cookie-banner');

const editMode = document.body.classList.contains('has-edit-mode-menu');

function handleButtonClick() {
	hideBanner();

	localStorage.setItem('liferay.cookie.consent', 'accepted');
}

function hideBanner() {
	cookieBanner.style.display = 'none';
}

function main() {
	if (!editMode) {
		if (localStorage.getItem('liferay.cookie.consent') === 'accepted') {
			hideBanner();
		}
		else {
			button.addEventListener('click', handleButtonClick);
		}
	}
}

main();
