/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.site.initializer.extender.internal;

import com.liferay.commerce.account.util.CommerceAccountRoleHelper;
import com.liferay.commerce.currency.service.CommerceCurrencyLocalService;
import com.liferay.commerce.initializer.util.CPDefinitionsImporter;
import com.liferay.commerce.initializer.util.CPOptionsImporter;
import com.liferay.commerce.initializer.util.CPSpecificationOptionsImporter;
import com.liferay.commerce.initializer.util.CommerceInventoryWarehousesImporter;
import com.liferay.commerce.initializer.util.PortletSettingsImporter;
import com.liferay.commerce.inventory.model.CommerceInventoryWarehouse;
import com.liferay.commerce.model.CommerceOrder;
import com.liferay.commerce.notification.service.CommerceNotificationTemplateLocalService;
import com.liferay.commerce.product.model.CPDefinition;
import com.liferay.commerce.product.model.CPInstance;
import com.liferay.commerce.product.model.CommerceChannel;
import com.liferay.commerce.product.service.CPDefinitionLocalService;
import com.liferay.commerce.product.service.CPInstanceLocalService;
import com.liferay.commerce.product.service.CPMeasurementUnitLocalService;
import com.liferay.commerce.product.service.CommerceCatalogLocalService;
import com.liferay.commerce.product.service.CommerceChannelLocalService;
import com.liferay.commerce.product.service.CommerceChannelService;
import com.liferay.headless.commerce.admin.catalog.dto.v1_0.Catalog;
import com.liferay.headless.commerce.admin.catalog.dto.v1_0.Option;
import com.liferay.headless.commerce.admin.catalog.dto.v1_0.ProductOption;
import com.liferay.headless.commerce.admin.catalog.dto.v1_0.ProductSpecification;
import com.liferay.headless.commerce.admin.catalog.resource.v1_0.CatalogResource;
import com.liferay.headless.commerce.admin.catalog.resource.v1_0.OptionResource;
import com.liferay.headless.commerce.admin.catalog.resource.v1_0.ProductOptionResource;
import com.liferay.headless.commerce.admin.catalog.resource.v1_0.ProductSpecificationResource;
import com.liferay.headless.commerce.admin.channel.dto.v1_0.Channel;
import com.liferay.headless.commerce.admin.channel.resource.v1_0.ChannelResource;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONFactory;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.json.JSONUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.service.LayoutLocalService;
import com.liferay.portal.kernel.service.ResourcePermissionLocalService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.permission.ModelPermissionsFactory;
import com.liferay.portal.kernel.settings.GroupServiceSettingsLocator;
import com.liferay.portal.kernel.settings.ModifiableSettings;
import com.liferay.portal.kernel.settings.Settings;
import com.liferay.portal.kernel.settings.SettingsFactory;
import com.liferay.portal.kernel.settings.SettingsLocator;
import com.liferay.portal.kernel.transaction.TransactionCommitCallbackUtil;
import com.liferay.portal.kernel.util.Accessor;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.SetUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.portal.kernel.util.UnicodePropertiesBuilder;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.vulcan.pagination.Page;
import com.liferay.site.initializer.extender.internal.util.SiteInitializerUtil;
import java.io.InputStream;
import java.math.BigDecimal;
import java.net.URL;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletContext;
import org.osgi.framework.Bundle;
import org.osgi.framework.wiring.BundleWiring;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={CommerceSiteInitializer.class})
public class CommerceSiteInitializer {
    private static final Log _log = LogFactoryUtil.getLog(CommerceSiteInitializer.class);
    @Reference
    private CatalogResource.Factory _catalogResourceFactory;
    @Reference
    private ChannelResource.Factory _channelResourceFactory;
    @Reference
    private CommerceAccountRoleHelper _commerceAccountRoleHelper;
    @Reference
    private CommerceCatalogLocalService _commerceCatalogLocalService;
    @Reference
    private CommerceChannelLocalService _commerceChannelLocalService;
    @Reference
    private CommerceChannelService _commerceChannelService;
    @Reference
    private CommerceCurrencyLocalService _commerceCurrencyLocalService;
    @Reference
    private CommerceInventoryWarehousesImporter _commerceInventoryWarehousesImporter;
    @Reference
    private CommerceNotificationTemplateLocalService _commerceNotificationTemplateLocalService;
    @Reference
    private CPDefinitionLocalService _cpDefinitionLocalService;
    @Reference
    private CPDefinitionsImporter _cpDefinitionsImporter;
    @Reference
    private CPInstanceLocalService _cpInstanceLocalService;
    @Reference
    private CPMeasurementUnitLocalService _cpMeasurementUnitLocalService;
    @Reference
    private CPOptionsImporter _cpOptionsImporter;
    @Reference
    private CPSpecificationOptionsImporter _cpSpecificationOptionsImporter;
    @Reference
    private GroupLocalService _groupLocalService;
    @Reference
    private JSONFactory _jsonFactory;
    @Reference
    private LayoutLocalService _layoutLocalService;
    @Reference
    private OptionResource.Factory _optionResourceFactory;
    @Reference
    private PortletSettingsImporter _portletSettingsImporter;
    @Reference
    private ProductOptionResource.Factory _productOptionResourceFactory;
    @Reference
    private ProductSpecificationResource.Factory _productSpecificationResourceFactory;
    @Reference
    private ResourcePermissionLocalService _resourcePermissionLocalService;
    @Reference
    private SettingsFactory _settingsFactory;

    public void addCPDefinitions(Bundle bundle, Map<String, String> documentsStringUtilReplaceValues, Map<String, String> objectDefinitionIdsStringUtilReplaceValues, ServiceContext serviceContext, ServletContext servletContext) throws Exception {
        Channel channel = this._addCommerceChannel(serviceContext, servletContext);
        if (channel == null) {
            return;
        }
        this._addCommerceCatalogs(bundle, channel, this._addCommerceInventoryWarehouses(serviceContext, servletContext), serviceContext, servletContext);
        this._addCommerceNotificationTemplates(bundle, channel.getId(), documentsStringUtilReplaceValues, objectDefinitionIdsStringUtilReplaceValues, serviceContext, servletContext);
    }

    public void addPortletSettings(ClassLoader classLoader, ServiceContext serviceContext, ServletContext servletContext) throws Exception {
        String resourcePath = "/site-initializer/portlet-settings.json";
        String json = SiteInitializerUtil.read(resourcePath, servletContext);
        if (json == null) {
            return;
        }
        Group group = this._groupLocalService.getCompanyGroup(serviceContext.getCompanyId());
        this._portletSettingsImporter.importPortletSettings(JSONFactoryUtil.createJSONArray((String)json), classLoader, "/site-initializer/portlet-settings/", serviceContext.getScopeGroupId(), group.getGroupId(), serviceContext.getUserId());
    }

    public long getCommerceChannelGroupId(long siteGroupId) {
        CommerceChannel commerceChannel = this._commerceChannelLocalService.fetchCommerceChannelBySiteGroupId(siteGroupId);
        return commerceChannel.getGroupId();
    }

    public String getCommerceOrderClassName() {
        return CommerceOrder.class.getName();
    }

    private void _addCommerceCatalogs(Bundle bundle, Channel channel, List<CommerceInventoryWarehouse> commerceInventoryWarehouses, ServiceContext serviceContext, ServletContext servletContext) throws Exception {
        Set resourcePaths = servletContext.getResourcePaths("/site-initializer/commerce-catalogs");
        if (SetUtil.isEmpty((Set)resourcePaths)) {
            return;
        }
        CatalogResource.Builder builder = this._catalogResourceFactory.create();
        CatalogResource catalogResource = builder.user(serviceContext.fetchUser()).build();
        for (String resourcePath : resourcePaths) {
            if (resourcePath.endsWith(".options.json") || resourcePath.endsWith(".products.json") || resourcePath.endsWith(".products.specifications.json") || resourcePath.endsWith(".products.subscriptions.properties.json") || !resourcePath.endsWith(".json")) continue;
            String json = SiteInitializerUtil.read(resourcePath, servletContext);
            JSONObject jsonObject = JSONFactoryUtil.createJSONObject((String)json);
            String assetVocabularyName = jsonObject.getString("assetVocabularyName");
            jsonObject.remove("assetVocabularyName");
            Catalog catalog = Catalog.toDTO((String)String.valueOf(jsonObject));
            if (catalog == null) {
                _log.error((Object)("Unable to transform commerce catalog from JSON: " + json));
                continue;
            }
            catalog = catalogResource.postCatalog(catalog);
            this._addCPOptions(catalog, StringUtil.replaceLast((String)resourcePath, (String)".json", (String)".options.json"), serviceContext, servletContext);
            this._addCPDefinitions(assetVocabularyName, bundle, catalog, channel, commerceInventoryWarehouses, StringUtil.replaceLast((String)resourcePath, (String)".json", (String)".products.json"), serviceContext, servletContext);
            this._addCommerceProductSpecifications(StringUtil.replaceLast((String)resourcePath, (String)".json", (String)".products.specifications.json"), serviceContext, servletContext);
            TransactionCommitCallbackUtil.registerCallback(() -> {
                this._addCPInstanceSubscriptions(StringUtil.replaceLast((String)resourcePath, (String)".json", (String)".products.subscriptions.properties.json"), serviceContext, servletContext);
                return null;
            });
        }
    }

    private Channel _addCommerceChannel(ServiceContext serviceContext, ServletContext servletContext) throws Exception {
        String resourcePath = "/site-initializer/commerce-channel.json";
        String json = SiteInitializerUtil.read(resourcePath, servletContext);
        if (json == null) {
            return null;
        }
        ChannelResource.Builder channelResourceBuilder = this._channelResourceFactory.create();
        ChannelResource channelResource = channelResourceBuilder.user(serviceContext.fetchUser()).build();
        JSONObject jsonObject = JSONFactoryUtil.createJSONObject((String)json);
        jsonObject.put("siteGroupId", serviceContext.getScopeGroupId());
        Channel channel = Channel.toDTO((String)jsonObject.toString());
        if (channel == null) {
            _log.error((Object)("Unable to transform commerce channel from JSON: " + json));
            return null;
        }
        channel = channelResource.postChannel(channel);
        this._addDefaultCPDisplayLayout(channel, StringUtil.replaceLast((String)resourcePath, (String)".json", (String)".default-cp-display-layout.json"), serviceContext, servletContext);
        this._addModelResourcePermissions(CommerceChannel.class.getName(), String.valueOf(channel.getId()), StringUtil.replaceLast((String)resourcePath, (String)".json", (String)".model-resource-permissions.json"), serviceContext, servletContext);
        Settings settings = this._settingsFactory.getSettings((SettingsLocator)new GroupServiceSettingsLocator(serviceContext.getScopeGroupId(), "com.liferay.commerce.account"));
        ModifiableSettings modifiableSettings = settings.getModifiableSettings();
        modifiableSettings.setValue("commerceSiteType", String.valueOf(0));
        modifiableSettings.store();
        this._commerceAccountRoleHelper.checkCommerceAccountRoles(serviceContext);
        this._commerceCurrencyLocalService.importDefaultValues(serviceContext);
        this._cpMeasurementUnitLocalService.importDefaultValues(serviceContext);
        return channel;
    }

    private List<CommerceInventoryWarehouse> _addCommerceInventoryWarehouses(ServiceContext serviceContext, ServletContext servletContext) throws Exception {
        return this._commerceInventoryWarehousesImporter.importCommerceInventoryWarehouses(JSONFactoryUtil.createJSONArray((String)SiteInitializerUtil.read("/site-initializer/commerce-inventory-warehouses.json", servletContext)), serviceContext.getScopeGroupId(), serviceContext.getUserId());
    }

    private void _addCommerceNotificationTemplate(Bundle bundle, long commerceChannelId, Map<String, String> documentsStringUtilReplaceValues, Map<String, String> objectDefinitionIdsStringUtilReplaceValues, String resourcePath, ServiceContext serviceContext, ServletContext servletContext) throws Exception {
        String json = SiteInitializerUtil.read(resourcePath + "commerce-notification-template.json", servletContext);
        if (Validator.isNull((String)json)) {
            return;
        }
        JSONObject commerceNotificationTemplateJSONObject = JSONFactoryUtil.createJSONObject((String)json);
        CommerceChannel commerceChannel = this._commerceChannelLocalService.getCommerceChannel(commerceChannelId);
        JSONObject bodyJSONObject = this._jsonFactory.createJSONObject();
        Enumeration enumeration = bundle.findEntries(resourcePath, "*.html", false);
        if (enumeration != null) {
            while (enumeration.hasMoreElements()) {
                URL url = (URL)enumeration.nextElement();
                bodyJSONObject.put(FileUtil.getShortFileName((String)FileUtil.stripExtension((String)url.getPath())), StringUtil.replace((String)StringUtil.read((InputStream)url.openStream()), (String)"[$", (String)"$]", documentsStringUtilReplaceValues));
            }
        }
        this._commerceNotificationTemplateLocalService.addCommerceNotificationTemplate(serviceContext.getUserId(), commerceChannel.getGroupId(), commerceNotificationTemplateJSONObject.getString("name"), commerceNotificationTemplateJSONObject.getString("description"), commerceNotificationTemplateJSONObject.getString("from"), SiteInitializerUtil.toMap(commerceNotificationTemplateJSONObject.getString("fromName")), commerceNotificationTemplateJSONObject.getString("to"), commerceNotificationTemplateJSONObject.getString("cc"), commerceNotificationTemplateJSONObject.getString("bcc"), StringUtil.replace((String)commerceNotificationTemplateJSONObject.getString("type"), (String)"[$", (String)"$]", objectDefinitionIdsStringUtilReplaceValues), commerceNotificationTemplateJSONObject.getBoolean("enabled"), SiteInitializerUtil.toMap(commerceNotificationTemplateJSONObject.getString("subject")), SiteInitializerUtil.toMap(bodyJSONObject.toString()), serviceContext);
    }

    private void _addCommerceNotificationTemplates(Bundle bundle, long commerceChannelId, Map<String, String> documentsStringUtilReplaceValues, Map<String, String> objectDefinitionIdsStringUtilReplaceValues, ServiceContext serviceContext, ServletContext servletContext) throws Exception {
        Set resourcePaths = servletContext.getResourcePaths("/site-initializer/commerce-notification-templates");
        if (SetUtil.isEmpty((Set)resourcePaths)) {
            return;
        }
        for (String resourcePath : resourcePaths) {
            this._addCommerceNotificationTemplate(bundle, commerceChannelId, documentsStringUtilReplaceValues, objectDefinitionIdsStringUtilReplaceValues, resourcePath, serviceContext, servletContext);
        }
    }

    private void _addCommerceProductSpecifications(String resourcePath, ServiceContext serviceContext, ServletContext servletContext) throws Exception {
        ProductSpecificationResource.Builder productSpecificationResourceBuilder = this._productSpecificationResourceFactory.create();
        ProductSpecificationResource productSpecificationResource = productSpecificationResourceBuilder.user(serviceContext.fetchUser()).build();
        String json = SiteInitializerUtil.read(resourcePath, servletContext);
        JSONArray jsonArray = JSONFactoryUtil.createJSONArray((String)json);
        this._cpSpecificationOptionsImporter.importCPSpecificationOptions(jsonArray, serviceContext.getScopeGroupId(), serviceContext.getUserId());
        for (int i = 0; i < jsonArray.length(); ++i) {
            final JSONObject jsonObject = jsonArray.getJSONObject(i);
            final CPDefinition cpDefinition = this._cpDefinitionLocalService.fetchCPDefinitionByCProductExternalReferenceCode(jsonObject.getString("cpDefinitionExternalReferenceCode"), serviceContext.getCompanyId());
            if (cpDefinition == null) continue;
            ProductSpecification productSpecification = new ProductSpecification(){
                {
                    this.productId = cpDefinition.getCPDefinitionId();
                    this.specificationKey = jsonObject.getString("key");
                    this.value = JSONUtil.toStringMap((JSONObject)jsonObject.getJSONObject("productSpecificationValue"));
                }
            };
            productSpecificationResource.postProductIdProductSpecification(Long.valueOf(cpDefinition.getCPDefinitionId()), productSpecification);
        }
    }

    private void _addCPDefinitions(String assetVocabularyName, Bundle bundle, Catalog catalog, Channel channel, List<CommerceInventoryWarehouse> commerceInventoryWarehouses, String resourcePath, ServiceContext serviceContext, ServletContext servletContext) throws Exception {
        String json = SiteInitializerUtil.read(resourcePath, servletContext);
        if (json == null) {
            return;
        }
        BundleWiring bundleWiring = (BundleWiring)bundle.adapt(BundleWiring.class);
        Group commerceCatalogGroup = this._commerceCatalogLocalService.getCommerceCatalogGroup(catalog.getId().longValue());
        this._cpDefinitionsImporter.importCPDefinitions(JSONFactoryUtil.createJSONArray((String)json), assetVocabularyName, commerceCatalogGroup.getGroupId(), channel.getId().longValue(), ListUtil.toLongArray(commerceInventoryWarehouses, (Accessor)CommerceInventoryWarehouse.COMMERCE_INVENTORY_WAREHOUSE_ID_ACCESSOR), bundleWiring.getClassLoader(), StringUtil.replace((String)resourcePath, (String)".json", (String)"/"), serviceContext.getScopeGroupId(), serviceContext.getUserId());
    }

    private void _addCPInstanceSubscriptions(String resourcePath, ServiceContext serviceContext, ServletContext servletContext) throws Exception {
        String json = SiteInitializerUtil.read(resourcePath, servletContext);
        if (json == null) {
            return;
        }
        ProductOptionResource.Builder productOptionResourceBuilder = this._productOptionResourceFactory.create();
        ProductOptionResource productOptionResource = productOptionResourceBuilder.user(serviceContext.fetchUser()).build();
        OptionResource.Builder optionResourceBuilder = this._optionResourceFactory.create();
        OptionResource optionResource = optionResourceBuilder.user(serviceContext.fetchUser()).build();
        JSONArray jsonArray = JSONFactoryUtil.createJSONArray((String)json);
        for (int i = 0; i < jsonArray.length(); ++i) {
            JSONObject subscriptionPropertiesJSONObject = jsonArray.getJSONObject(i);
            Page optionsPage = optionResource.getOptionsPage(null, optionResource.toFilter(StringBundler.concat((String[])new String[]{"name eq '", StringUtil.toLowerCase((String)subscriptionPropertiesJSONObject.getString("optionName")), "'"})), null, null);
            final Option option = (Option)optionsPage.fetchFirstItem();
            if (option == null) continue;
            ProductOption[] productOptions = new ProductOption[]{new ProductOption(){
                {
                    this.facetable = option.getFacetable();
                    this.fieldType = option.getFieldType().toString();
                    this.key = option.getKey();
                    this.name = option.getName();
                    this.optionId = option.getId();
                    this.required = option.getRequired();
                    this.skuContributor = option.getSkuContributor();
                }
            }};
            CPDefinition cpDefinition = this._cpDefinitionLocalService.fetchCPDefinitionByCProductExternalReferenceCode(subscriptionPropertiesJSONObject.getString("cpDefinitionExternalReferenceCode"), serviceContext.getCompanyId());
            productOptionResource.postProductIdProductOptionsPage(Long.valueOf(cpDefinition.getCProductId()), productOptions);
            this._cpInstanceLocalService.buildCPInstances(cpDefinition.getCPDefinitionId(), serviceContext);
            JSONArray cpInstancePropertiesJSONArray = subscriptionPropertiesJSONObject.getJSONArray("cpInstanceProperties");
            if (cpInstancePropertiesJSONArray == null) continue;
            for (int j = 0; j < cpInstancePropertiesJSONArray.length(); ++j) {
                JSONObject cpInstancePropertiesJSONObject = cpInstancePropertiesJSONArray.getJSONObject(j);
                this._updateCPInstanceProperties(cpDefinition, cpInstancePropertiesJSONObject);
            }
        }
    }

    private void _addCPOptions(Catalog catalog, String resourcePath, ServiceContext serviceContext, ServletContext servletContext) throws Exception {
        String json = SiteInitializerUtil.read(resourcePath, servletContext);
        if (json == null) {
            return;
        }
        Group commerceCatalogGroup = this._commerceCatalogLocalService.getCommerceCatalogGroup(catalog.getId().longValue());
        this._cpOptionsImporter.importCPOptions(JSONFactoryUtil.createJSONArray((String)json), commerceCatalogGroup.getGroupId(), serviceContext.getUserId());
    }

    private void _addDefaultCPDisplayLayout(Channel channel, String resourcePath, ServiceContext serviceContext, ServletContext servletContext) throws Exception {
        String json = SiteInitializerUtil.read(resourcePath, servletContext);
        if (json == null) {
            return;
        }
        JSONObject jsonObject = JSONFactoryUtil.createJSONObject((String)json);
        Layout layout = this._layoutLocalService.fetchLayoutByFriendlyURL(serviceContext.getScopeGroupId(), jsonObject.getBoolean("privateLayout"), jsonObject.getString("friendlyURL"));
        if (layout == null) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)("Unable to create a default product commerce product display layout from JSON: " + json));
            }
            return;
        }
        CommerceChannel commerceChannel = this._commerceChannelService.getCommerceChannel(channel.getId().longValue());
        Settings settings = this._settingsFactory.getSettings((SettingsLocator)new GroupServiceSettingsLocator(commerceChannel.getGroupId(), "com.liferay.commerce.product.display.layout"));
        ModifiableSettings modifiableSettings = settings.getModifiableSettings();
        modifiableSettings.setValue("productLayoutUuid", layout.getUuid());
        modifiableSettings.store();
    }

    private void _addModelResourcePermissions(String className, String primKey, String resourcePath, ServiceContext serviceContext, ServletContext servletContext) throws Exception {
        String json = SiteInitializerUtil.read(resourcePath, servletContext);
        if (json == null) {
            return;
        }
        JSONArray jsonArray = JSONFactoryUtil.createJSONArray((String)json);
        for (int i = 0; i < jsonArray.length(); ++i) {
            JSONObject jsonObject = jsonArray.getJSONObject(i);
            this._resourcePermissionLocalService.addModelResourcePermissions(serviceContext.getCompanyId(), serviceContext.getScopeGroupId(), serviceContext.getUserId(), className, primKey, ModelPermissionsFactory.create((Map)HashMapBuilder.put((Object)jsonObject.getString("roleName"), (Object)ArrayUtil.toStringArray((JSONArray)jsonObject.getJSONArray("actionIds"))).build(), null));
        }
    }

    private void _updateCPInstanceProperties(CPDefinition cpDefinition, JSONObject cpInstancePropertiesJSONObject) throws Exception {
        CPInstance cpInstance = this._cpInstanceLocalService.getCPInstance(cpDefinition.getCPDefinitionId(), cpInstancePropertiesJSONObject.getString("cpInstanceSku"));
        if (cpInstance == null) {
            return;
        }
        String propertyType = cpInstancePropertiesJSONObject.getString("propertyType");
        if (StringUtil.equals((String)propertyType, (String)"CREATE_SUBSCRIPTION")) {
            JSONObject subscriptionTypeSettingsJSONObject = cpInstancePropertiesJSONObject.getJSONObject("subscriptionTypeSettings");
            this._cpInstanceLocalService.updateSubscriptionInfo(cpInstance.getCPInstanceId(), cpInstancePropertiesJSONObject.getBoolean("overrideSubscriptionInfo"), cpInstancePropertiesJSONObject.getBoolean("subscriptionEnabled"), cpInstancePropertiesJSONObject.getInt("subscriptionLength"), cpInstancePropertiesJSONObject.getString("subscriptionType"), UnicodePropertiesBuilder.create((Map)JSONUtil.toStringMap((JSONObject)subscriptionTypeSettingsJSONObject), (boolean)true).build(), cpInstancePropertiesJSONObject.getLong("maxSubscriptionCycles"), cpInstancePropertiesJSONObject.getBoolean("deliverySubscriptionEnabled"), cpInstancePropertiesJSONObject.getInt("deliverySubscriptionLength"), cpInstancePropertiesJSONObject.getString("deliverySubscriptionType"), new UnicodeProperties(), cpInstancePropertiesJSONObject.getLong("deliveryMaxSubscriptionCycles"));
        } else if (StringUtil.equals((String)propertyType, (String)"UPDATE_PRICE")) {
            cpInstance.setPrice(BigDecimal.valueOf(cpInstancePropertiesJSONObject.getLong("skuPrice")));
            cpInstance.setPromoPrice(BigDecimal.valueOf(cpInstancePropertiesJSONObject.getLong("skuPromoPrice")));
            this._cpInstanceLocalService.updateCPInstance(cpInstance);
        }
    }
}

