/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.site.initializer.extender.internal.file.backed.servlet;

import com.liferay.site.initializer.extender.internal.file.backed.util.PathUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class FileBackedServletContextDelegate {
    private final File _file;
    private final String _fileKey;
    private final String _servletContextName;

    public FileBackedServletContextDelegate(File file, String fileKey, String servletContextName) {
        this._file = file;
        this._fileKey = fileKey;
        this._servletContextName = servletContextName;
    }

    public String getContextPath() {
        return "/o/file-backed-site-initializer/" + this._fileKey;
    }

    public URL getResource(String path) throws MalformedURLException {
        File file = new File(this._file, PathUtil.removePrefix(path));
        if (file.exists()) {
            URI uri = file.toURI();
            return uri.toURL();
        }
        return null;
    }

    public InputStream getResourceAsStream(String path) {
        File file = new File(this._file, PathUtil.removePrefix(path));
        if (file.exists()) {
            try {
                return new FileInputStream(file);
            }
            catch (FileNotFoundException fileNotFoundException) {
                throw new IllegalStateException(fileNotFoundException);
            }
        }
        return null;
    }

    public Set<String> getResourcePaths(String path) {
        File searchDirectoryFile = new File(this._file, PathUtil.removePrefix(path));
        if (!searchDirectoryFile.exists()) {
            return Collections.emptySet();
        }
        HashSet<String> resourcePaths = new HashSet<String>();
        if (!path.endsWith("/")) {
            path = path.concat("/");
        }
        for (File file : searchDirectoryFile.listFiles()) {
            String resourcePath = path.concat(file.getName());
            if (file.isDirectory()) {
                resourcePath = resourcePath.concat("/");
            }
            resourcePaths.add(resourcePath);
        }
        return resourcePaths;
    }

    public String getServletContextName() {
        return this._servletContextName;
    }
}

