/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.site.initializer.extender.internal.file.backed.osgi;

import com.liferay.portal.kernel.json.JSONFactory;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.ProxyUtil;
import com.liferay.site.initializer.extender.internal.file.backed.util.PathUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.DirectoryStream;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.List;
import org.osgi.framework.BundleContext;
import org.osgi.framework.wiring.BundleWiring;

public class FileBackedBundleDelegate {
    private static final Log _log = LogFactoryUtil.getLog(FileBackedBundleDelegate.class);
    private final BundleContext _bundleContext;
    private final ClassLoader _classLoader;
    private final File _file;
    private final JSONFactory _jsonFactory;
    private final String _siteInitializerName;
    private final String _symbolicName;

    public FileBackedBundleDelegate(BundleContext bundleContext, File file, JSONFactory jsonFactory, String symbolicName) throws Exception {
        this._bundleContext = bundleContext;
        this._file = file;
        this._jsonFactory = jsonFactory;
        this._symbolicName = symbolicName;
        URI uri = file.toURI();
        this._classLoader = new URLClassLoader(new URL[]{uri.toURL()}, null){

            @Override
            public InputStream getResourceAsStream(String name) {
                return super.getResourceAsStream(PathUtil.removePrefix(name));
            }

            @Override
            public Enumeration<URL> getResources(String name) throws IOException {
                return super.getResources(PathUtil.removePrefix(name));
            }
        };
        File jsonFile = new File(file, "site-initializer.json");
        if (jsonFile.exists()) {
            JSONObject jsonObject = this._jsonFactory.createJSONObject(FileUtil.read((File)jsonFile));
            this._siteInitializerName = jsonObject.getString("name", this._file.getName());
        } else {
            this._siteInitializerName = this._file.getName();
        }
    }

    public <T> T adapt(Class<T> clazz) {
        if (clazz != BundleWiring.class) {
            throw new IllegalArgumentException("Unsupported clazz " + String.valueOf(clazz));
        }
        return (T)ProxyUtil.newDelegateProxyInstance((ClassLoader)clazz.getClassLoader(), clazz, (Object)new Object(){

            public ClassLoader getClassLoader() {
                return FileBackedBundleDelegate.this._classLoader;
            }
        }, null);
    }

    public Enumeration<URL> findEntries(String path, final String filePattern, boolean recurse) throws IOException {
        Path rootPathObject = this._file.toPath();
        Path searchPathObject = rootPathObject.resolve(PathUtil.removePrefix(path));
        if (Files.notExists(searchPathObject, new LinkOption[0])) {
            return Collections.emptyEnumeration();
        }
        final ArrayList<URL> urls = new ArrayList<URL>();
        if (recurse) {
            Files.walkFileTree(searchPathObject, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult preVisitDirectory(Path dirPath, BasicFileAttributes basicFileAttributes) throws IOException {
                    FileBackedBundleDelegate.this._collect(urls, dirPath, filePattern);
                    return FileVisitResult.CONTINUE;
                }
            });
        } else {
            this._collect(urls, rootPathObject, filePattern);
        }
        return Collections.enumeration(urls);
    }

    public BundleContext getBundleContext() {
        return this._bundleContext;
    }

    public URL getEntry(String path) {
        block3: {
            File file = new File(path);
            if (file.exists()) {
                URI uri = file.toURI();
                try {
                    return uri.toURL();
                }
                catch (MalformedURLException malformedURLException) {
                    if (!_log.isDebugEnabled()) break block3;
                    _log.debug((Throwable)malformedURLException);
                }
            }
        }
        return null;
    }

    public Dictionary<String, String> getHeaders(String locale) {
        return MapUtil.singletonDictionary((Object)"Liferay-Site-Initializer-Name", (Object)this._siteInitializerName);
    }

    public String getSymbolicName() {
        return this._symbolicName;
    }

    private void _collect(List<URL> urls, Path dirPath, String glob) throws IOException {
        try (DirectoryStream<Path> directoryStream = Files.newDirectoryStream(dirPath, glob);){
            for (Path path : directoryStream) {
                URI uri = path.toUri();
                urls.add(uri.toURL());
            }
        }
    }
}

