/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.site.initializer.extender.internal;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.liferay.headless.site.dto.v1_0.Site;
import com.liferay.headless.site.resource.v1_0.SiteResource;
import com.liferay.layout.util.LayoutServiceContextHelper;
import com.liferay.petra.lang.SafeCloseable;
import com.liferay.petra.reflect.ReflectionUtil;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.security.auth.CompanyThreadLocal;
import com.liferay.portal.kernel.security.auth.PrincipalThreadLocal;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.PermissionThreadLocal;
import com.liferay.portal.kernel.service.CompanyLocalService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ServiceContextThreadLocal;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.transaction.Propagation;
import com.liferay.portal.kernel.transaction.TransactionConfig;
import com.liferay.portal.kernel.transaction.TransactionInvokerUtil;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.PropsUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.security.permission.PermissionCacheUtil;
import com.liferay.portal.vulcan.multipart.BinaryFile;
import com.liferay.portal.vulcan.multipart.MultipartBody;
import com.liferay.site.initializer.extender.SiteInitializerUtil;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Collections;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Callable;
import javax.servlet.http.HttpServletRequest;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.util.tracker.BundleTracker;
import org.osgi.util.tracker.BundleTrackerCustomizer;

@Component(service={})
public class SiteInitializerClientExtension
implements BundleTrackerCustomizer<Bundle> {
    private static final ObjectMapper _objectMapper = new ObjectMapper();
    private static final TransactionConfig _transactionConfig = TransactionConfig.Factory.create((Propagation)Propagation.REQUIRED, (Class[])new Class[]{Exception.class}, (Class[])new Class[0]);
    private BundleTracker<?> _bundleTracker;
    @Reference
    private CompanyLocalService _companyLocalService;
    @Reference
    private LayoutServiceContextHelper _layoutServiceContextHelper;
    @Reference
    private SiteResource.Factory _siteResourceFactory;
    @Reference
    private UserLocalService _userLocalService;

    public Bundle addingBundle(Bundle bundle, BundleEvent bundleEvent) {
        Dictionary headers = bundle.getHeaders("");
        if (Validator.isNull((String)((String)headers.get("Liferay-Client-Extension-Site-Initializer"))) || this._isAlreadyProcessed(bundle)) {
            return null;
        }
        PermissionChecker permissionChecker = PermissionThreadLocal.getPermissionChecker();
        String name = PrincipalThreadLocal.getName();
        try {
            this._initialize(bundle, headers);
        }
        catch (Throwable throwable) {
            throw new RuntimeException(throwable);
        }
        finally {
            PermissionThreadLocal.setPermissionChecker((PermissionChecker)permissionChecker);
            PrincipalThreadLocal.setName((String)name);
        }
        return bundle;
    }

    public void modifiedBundle(Bundle bundle, BundleEvent bundleEvent, Bundle unusedBundle) {
    }

    public void removedBundle(Bundle bundle, BundleEvent bundleEvent, Bundle unusedBundle) {
    }

    @Activate
    protected void activate(BundleContext bundleContext, Map<String, Object> properties) {
        this._bundleTracker = new BundleTracker(bundleContext, 32, (BundleTrackerCustomizer)this);
        this._bundleTracker.open();
    }

    @Deactivate
    protected void deactivate() {
        this._bundleTracker.close();
    }

    private Site _addOrUpdateSite(String externalReferenceCode, MultipartBody multipartBody, User user) throws Exception {
        ServiceContext serviceContext = ServiceContextThreadLocal.getServiceContext();
        HttpServletRequest httpServletRequest = serviceContext.getRequest();
        ThemeDisplay themeDisplay = (ThemeDisplay)httpServletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        httpServletRequest.setAttribute("LAYOUT", (Object)themeDisplay.getLayout());
        httpServletRequest.setAttribute("LIFERAY_SHARED_THEME_DISPLAY", (Object)themeDisplay);
        SiteResource.Builder builder = this._siteResourceFactory.create();
        SiteResource siteResource = builder.user(user).httpServletRequest(httpServletRequest).build();
        return siteResource.putSiteByExternalReferenceCode(externalReferenceCode, multipartBody);
    }

    private void _initialize(Bundle bundle, Dictionary<String, String> headers) throws Throwable {
        HashMap<String, BinaryFile> binaryFiles = new HashMap<String, BinaryFile>();
        Site site = null;
        Enumeration enumeration = bundle.findEntries(headers.get("Liferay-Client-Extension-Site-Initializer"), "*", true);
        while (enumeration.hasMoreElements()) {
            URL url = (URL)enumeration.nextElement();
            if (StringUtil.endsWith((String)url.getPath(), (String)"site-initializer.json")) {
                String json = SiteInitializerUtil.read((Bundle)bundle, (String)"site-initializer.json", (URL)url);
                site = Site.toDTO((String)json);
                if (site != null) continue;
                throw new Exception("Unable to transform site from JSON: " + json);
            }
            if (!StringUtil.endsWith((String)url.getPath(), (String)"site-initializer.zip")) continue;
            URLConnection urlConnection = url.openConnection();
            binaryFiles.put("file", new BinaryFile(".zip", "site-initializer", urlConnection.getInputStream(), (long)urlConnection.getContentLength()));
        }
        Company company = this._companyLocalService.getCompanyByWebId(PropsUtil.get((String)"company.default.web.id"));
        long companyId = company.getCompanyId();
        try (SafeCloseable safeCloseable = CompanyThreadLocal.setCompanyIdWithSafeCloseable((Long)companyId);){
            TransactionInvokerUtil.invoke((TransactionConfig)_transactionConfig, (Callable)new SiteCallable(company, MultipartBody.of(binaryFiles, __ -> _objectMapper, Collections.singletonMap("site", site.toString())), site, this._userLocalService.getUserByScreenName(companyId, PropsUtil.get((String)"default.admin.screen.name"))));
        }
    }

    private boolean _isAlreadyProcessed(Bundle bundle) {
        String lastModifiedString = String.valueOf(bundle.getLastModified());
        File file = bundle.getDataFile(".liferay-client-extension-site-initializer");
        try {
            if (file != null && file.exists() && Objects.equals(FileUtil.read((File)file), lastModifiedString)) {
                return true;
            }
            if (!file.exists()) {
                file.createNewFile();
            }
            FileUtil.write((File)file, (String)lastModifiedString, (boolean)true);
        }
        catch (IOException ioException) {
            ReflectionUtil.throwException((Throwable)ioException);
        }
        return false;
    }

    private class SiteCallable
    implements Callable<Site> {
        private final Company _company;
        private final MultipartBody _multipartBody;
        private final Site _site;
        private final User _user;

        @Override
        public Site call() throws Exception {
            Site site;
            block8: {
                AutoCloseable autoCloseable = SiteInitializerClientExtension.this._layoutServiceContextHelper.getServiceContextAutoCloseable(this._company);
                try {
                    site = SiteInitializerClientExtension.this._addOrUpdateSite(this._site.getExternalReferenceCode(), this._multipartBody, this._user);
                    if (autoCloseable == null) break block8;
                }
                catch (Throwable throwable) {
                    try {
                        if (autoCloseable != null) {
                            try {
                                autoCloseable.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Exception exception) {
                        PermissionCacheUtil.clearCache((long[])new long[]{this._user.getUserId()});
                        throw exception;
                    }
                }
                autoCloseable.close();
            }
            return site;
        }

        private SiteCallable(Company company, MultipartBody multipartBody, Site site, User user) {
            this._company = company;
            this._multipartBody = multipartBody;
            this._site = site;
            this._user = user;
        }
    }
}

