/**
 * SPDX-FileCopyrightText: (c) 2025 Liferay, Inc. https://liferay.com
 * SPDX-License-Identifier: LGPL-2.1-or-later OR LicenseRef-Liferay-DXP-EULA-2.0.0-2023-06
 */

import {RepeatableGroup, Structure} from '../types/Structure';
import {Uuid} from '../types/Uuid';

export function getChildrenUuids(
	item: Structure | RepeatableGroup,
	uuids: Set<Uuid> = new Set()
) {
	for (const child of item.children.values()) {
		uuids.add(child.uuid);

		if (child.type === 'repeatable-group') {
			getChildrenUuids(child, uuids);
		}
	}

	return uuids;
}
