/**
 * SPDX-FileCopyrightText: (c) 2025 Liferay, Inc. https://liferay.com
 * SPDX-License-Identifier: LGPL-2.1-or-later OR LicenseRef-Liferay-DXP-EULA-2.0.0-2023-06
 */

package com.liferay.site.cms.site.initializer.internal.frontend.data.set.view.table;

import com.liferay.frontend.data.set.view.FDSView;
import com.liferay.site.cms.site.initializer.internal.constants.CMSSiteInitializerFDSNames;
import com.liferay.site.cms.site.initializer.internal.util.FDSViewUtil;

import org.osgi.service.component.annotations.Component;

/**
 * @author Jürgen Kappler
 * @author Marco Galluzzi
 * @author Roberto Díaz
 * @author Sam Ziemer
 */
@Component(
	property = {
		"frontend.data.set.name=" + CMSSiteInitializerFDSNames.ALL_SECTION,
		"frontend.data.set.name=" + CMSSiteInitializerFDSNames.CONTENTS_SECTION,
		"frontend.data.set.name=" + CMSSiteInitializerFDSNames.FILES_SECTION,
		"frontend.data.set.name=" + CMSSiteInitializerFDSNames.VIEW_CONTENTS_FOLDER,
		"frontend.data.set.name=" + CMSSiteInitializerFDSNames.VIEW_FILES_FOLDER
	},
	service = FDSView.class
)
public class ContentAndFileContentsSectionCMSTableFDSView
	extends BaseContentsSectionCMSTableFDSView {

	@Override
	public boolean isDefault(String fdsName) {
		return FDSViewUtil.isDefault(fdsName, getName());
	}

}