/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.site.cms.site.initializer.internal.instance.lifecycle;

import com.liferay.portal.instance.lifecycle.InitialRequestPortalInstanceLifecycleListener;
import com.liferay.portal.instance.lifecycle.PortalInstanceLifecycleListener;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.feature.flag.FeatureFlagManagerUtil;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.Role;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.security.auth.PrincipalThreadLocal;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.PermissionCheckerFactory;
import com.liferay.portal.kernel.security.permission.PermissionThreadLocal;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.service.LayoutLocalService;
import com.liferay.portal.kernel.service.RoleLocalService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ServiceContextThreadLocal;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.util.FriendlyURLNormalizer;
import com.liferay.site.initializer.SiteInitializer;
import java.util.List;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={PortalInstanceLifecycleListener.class})
public class AddDefaultLayoutInitialRequestPortalInstanceLifecycleListener
extends InitialRequestPortalInstanceLifecycleListener {
    @Reference
    private PermissionCheckerFactory _defaultPermissionCheckerFactory;
    @Reference
    private FriendlyURLNormalizer _friendlyURLNormalizer;
    @Reference
    private GroupLocalService _groupLocalService;
    @Reference
    private LayoutLocalService _layoutLocalService;
    @Reference
    private RoleLocalService _roleLocalService;
    @Reference(target="(site.initializer.key=com.liferay.site.initializer.cms)")
    private SiteInitializer _siteInitializer;
    @Reference
    private UserLocalService _userLocalService;

    @Activate
    protected void activate(BundleContext bundleContext) {
        super.activate(bundleContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doPortalInstanceRegistered(long companyId) throws Exception {
        if (!FeatureFlagManagerUtil.isEnabled((String)"LPD-17809")) {
            return;
        }
        Group group = this._groupLocalService.getGroup(companyId, "CMS");
        String friendlyURL = this._friendlyURLNormalizer.normalizeWithEncoding("/dashboard");
        Layout defaultLayout = this._layoutLocalService.fetchLayoutByFriendlyURL(group.getGroupId(), false, friendlyURL);
        if (defaultLayout != null) {
            return;
        }
        defaultLayout = this._layoutLocalService.fetchFirstLayout(group.getGroupId(), false, 0L, false);
        if (defaultLayout != null) {
            return;
        }
        String name = PrincipalThreadLocal.getName();
        PermissionChecker permissionChecker = PermissionThreadLocal.getPermissionChecker();
        try {
            User user = this._getUser(companyId);
            PrincipalThreadLocal.setName((long)user.getUserId());
            PermissionThreadLocal.setPermissionChecker((PermissionChecker)this._defaultPermissionCheckerFactory.create(user));
            ServiceContextThreadLocal.pushServiceContext((ServiceContext)new ServiceContext());
            this._siteInitializer.initialize(group.getGroupId());
        }
        finally {
            PrincipalThreadLocal.setName((String)name);
            PermissionThreadLocal.setPermissionChecker((PermissionChecker)permissionChecker);
            ServiceContextThreadLocal.popServiceContext();
        }
    }

    private User _getUser(long companyId) throws PortalException {
        Role role = this._roleLocalService.fetchRole(companyId, "Administrator");
        if (role == null) {
            return this._userLocalService.getGuestUser(companyId);
        }
        List adminUsers = this._userLocalService.getRoleUsers(role.getRoleId(), 0, 1);
        if (adminUsers.isEmpty()) {
            return this._userLocalService.getGuestUser(companyId);
        }
        return (User)adminUsers.get(0);
    }
}

