/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.shopping.service.persistence.impl;

import com.liferay.portal.kernel.dao.orm.Dialect;
import com.liferay.portal.kernel.dao.orm.EntityCache;
import com.liferay.portal.kernel.dao.orm.FinderCache;
import com.liferay.portal.kernel.dao.orm.FinderPath;
import com.liferay.portal.kernel.dao.orm.Query;
import com.liferay.portal.kernel.dao.orm.QueryPos;
import com.liferay.portal.kernel.dao.orm.QueryUtil;
import com.liferay.portal.kernel.dao.orm.SQLQuery;
import com.liferay.portal.kernel.dao.orm.Session;
import com.liferay.portal.kernel.dao.orm.Type;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.security.auth.CompanyThreadLocal;
import com.liferay.portal.kernel.security.permission.InlineSQLHelperUtil;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ServiceContextThreadLocal;
import com.liferay.portal.kernel.service.persistence.impl.BasePersistenceImpl;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.ProxyUtil;
import com.liferay.portal.kernel.util.SetUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.spring.extender.service.ServiceReference;
import com.liferay.shopping.exception.NoSuchOrderException;
import com.liferay.shopping.model.ShoppingOrder;
import com.liferay.shopping.model.impl.ShoppingOrderImpl;
import com.liferay.shopping.model.impl.ShoppingOrderModelImpl;
import com.liferay.shopping.service.persistence.ShoppingOrderPersistence;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class ShoppingOrderPersistenceImpl
extends BasePersistenceImpl<ShoppingOrder>
implements ShoppingOrderPersistence {
    public static final String FINDER_CLASS_NAME_ENTITY = ShoppingOrderImpl.class.getName();
    public static final String FINDER_CLASS_NAME_LIST_WITH_PAGINATION = FINDER_CLASS_NAME_ENTITY + ".List1";
    public static final String FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION = FINDER_CLASS_NAME_ENTITY + ".List2";
    private FinderPath _finderPathWithPaginationFindAll;
    private FinderPath _finderPathWithoutPaginationFindAll;
    private FinderPath _finderPathCountAll;
    private FinderPath _finderPathWithPaginationFindByGroupId;
    private FinderPath _finderPathWithoutPaginationFindByGroupId;
    private FinderPath _finderPathCountByGroupId;
    private static final String _FINDER_COLUMN_GROUPID_GROUPID_2 = "shoppingOrder.groupId = ?";
    private FinderPath _finderPathFetchByNumber;
    private FinderPath _finderPathCountByNumber;
    private static final String _FINDER_COLUMN_NUMBER_NUMBER_2 = "shoppingOrder.number = ?";
    private static final String _FINDER_COLUMN_NUMBER_NUMBER_3 = "(shoppingOrder.number IS NULL OR shoppingOrder.number = '')";
    private FinderPath _finderPathFetchByPPTxnId;
    private FinderPath _finderPathCountByPPTxnId;
    private static final String _FINDER_COLUMN_PPTXNID_PPTXNID_2 = "shoppingOrder.ppTxnId = ?";
    private static final String _FINDER_COLUMN_PPTXNID_PPTXNID_3 = "(shoppingOrder.ppTxnId IS NULL OR shoppingOrder.ppTxnId = '')";
    private FinderPath _finderPathWithPaginationFindByG_U_PPPS;
    private FinderPath _finderPathWithoutPaginationFindByG_U_PPPS;
    private FinderPath _finderPathCountByG_U_PPPS;
    private static final String _FINDER_COLUMN_G_U_PPPS_GROUPID_2 = "shoppingOrder.groupId = ? AND ";
    private static final String _FINDER_COLUMN_G_U_PPPS_USERID_2 = "shoppingOrder.userId = ? AND ";
    private static final String _FINDER_COLUMN_G_U_PPPS_PPPAYMENTSTATUS_2 = "shoppingOrder.ppPaymentStatus = ?";
    private static final String _FINDER_COLUMN_G_U_PPPS_PPPAYMENTSTATUS_3 = "(shoppingOrder.ppPaymentStatus IS NULL OR shoppingOrder.ppPaymentStatus = '')";
    @ServiceReference(type=EntityCache.class)
    protected EntityCache entityCache;
    @ServiceReference(type=FinderCache.class)
    protected FinderCache finderCache;
    private static final String _SQL_SELECT_SHOPPINGORDER = "SELECT shoppingOrder FROM ShoppingOrder shoppingOrder";
    private static final String _SQL_SELECT_SHOPPINGORDER_WHERE_PKS_IN = "SELECT shoppingOrder FROM ShoppingOrder shoppingOrder WHERE orderId IN (";
    private static final String _SQL_SELECT_SHOPPINGORDER_WHERE = "SELECT shoppingOrder FROM ShoppingOrder shoppingOrder WHERE ";
    private static final String _SQL_COUNT_SHOPPINGORDER = "SELECT COUNT(shoppingOrder) FROM ShoppingOrder shoppingOrder";
    private static final String _SQL_COUNT_SHOPPINGORDER_WHERE = "SELECT COUNT(shoppingOrder) FROM ShoppingOrder shoppingOrder WHERE ";
    private static final String _FILTER_ENTITY_TABLE_FILTER_PK_COLUMN = "shoppingOrder.orderId";
    private static final String _FILTER_SQL_SELECT_SHOPPINGORDER_WHERE = "SELECT DISTINCT {shoppingOrder.*} FROM ShoppingOrder shoppingOrder WHERE ";
    private static final String _FILTER_SQL_SELECT_SHOPPINGORDER_NO_INLINE_DISTINCT_WHERE_1 = "SELECT {ShoppingOrder.*} FROM (SELECT DISTINCT shoppingOrder.orderId FROM ShoppingOrder shoppingOrder WHERE ";
    private static final String _FILTER_SQL_SELECT_SHOPPINGORDER_NO_INLINE_DISTINCT_WHERE_2 = ") TEMP_TABLE INNER JOIN ShoppingOrder ON TEMP_TABLE.orderId = ShoppingOrder.orderId";
    private static final String _FILTER_SQL_COUNT_SHOPPINGORDER_WHERE = "SELECT COUNT(DISTINCT shoppingOrder.orderId) AS COUNT_VALUE FROM ShoppingOrder shoppingOrder WHERE ";
    private static final String _FILTER_ENTITY_ALIAS = "shoppingOrder";
    private static final String _FILTER_ENTITY_TABLE = "ShoppingOrder";
    private static final String _ORDER_BY_ENTITY_ALIAS = "shoppingOrder.";
    private static final String _ORDER_BY_ENTITY_TABLE = "ShoppingOrder.";
    private static final String _NO_SUCH_ENTITY_WITH_PRIMARY_KEY = "No ShoppingOrder exists with the primary key ";
    private static final String _NO_SUCH_ENTITY_WITH_KEY = "No ShoppingOrder exists with the key {";
    private static final Log _log = LogFactoryUtil.getLog(ShoppingOrderPersistenceImpl.class);
    private static final Set<String> _badColumnNames = SetUtil.fromArray((Object[])new String[]{"number"});

    public List<ShoppingOrder> findByGroupId(long groupId) {
        return this.findByGroupId(groupId, -1, -1, null);
    }

    public List<ShoppingOrder> findByGroupId(long groupId, int start, int end) {
        return this.findByGroupId(groupId, start, end, null);
    }

    public List<ShoppingOrder> findByGroupId(long groupId, int start, int end, OrderByComparator<ShoppingOrder> orderByComparator) {
        return this.findByGroupId(groupId, start, end, orderByComparator, true);
    }

    public List<ShoppingOrder> findByGroupId(long groupId, int start, int end, OrderByComparator<ShoppingOrder> orderByComparator, boolean useFinderCache) {
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            if (useFinderCache) {
                finderPath = this._finderPathWithoutPaginationFindByGroupId;
                finderArgs = new Object[]{groupId};
            }
        } else if (useFinderCache) {
            finderPath = this._finderPathWithPaginationFindByGroupId;
            finderArgs = new Object[]{groupId, start, end, orderByComparator};
        }
        List list = null;
        if (useFinderCache && (list = (List)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this)) != null && !list.isEmpty()) {
            for (ShoppingOrder shoppingOrder : list) {
                if (groupId == shoppingOrder.getGroupId()) continue;
                list = null;
                break;
            }
        }
        if (list == null) {
            StringBundler query = null;
            query = orderByComparator != null ? new StringBundler(3 + orderByComparator.getOrderByFields().length * 2) : new StringBundler(3);
            query.append(_SQL_SELECT_SHOPPINGORDER_WHERE);
            query.append(_FINDER_COLUMN_GROUPID_GROUPID_2);
            if (orderByComparator != null) {
                this.appendOrderByComparator(query, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
            } else {
                query.append(" ORDER BY shoppingOrder.createDate DESC");
            }
            String sql = query.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance((Query)q);
                qPos.add(groupId);
                list = QueryUtil.list((Query)q, (Dialect)this.getDialect(), (int)start, (int)end);
                this.cacheResult(list);
                if (useFinderCache) {
                    this.finderCache.putResult(finderPath, finderArgs, (Object)list);
                }
            }
            catch (Exception exception) {
                if (useFinderCache) {
                    this.finderCache.removeResult(finderPath, finderArgs);
                }
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    public ShoppingOrder findByGroupId_First(long groupId, OrderByComparator<ShoppingOrder> orderByComparator) throws NoSuchOrderException {
        ShoppingOrder shoppingOrder = this.fetchByGroupId_First(groupId, orderByComparator);
        if (shoppingOrder != null) {
            return shoppingOrder;
        }
        StringBundler msg = new StringBundler(4);
        msg.append(_NO_SUCH_ENTITY_WITH_KEY);
        msg.append("groupId=");
        msg.append(groupId);
        msg.append("}");
        throw new NoSuchOrderException(msg.toString());
    }

    public ShoppingOrder fetchByGroupId_First(long groupId, OrderByComparator<ShoppingOrder> orderByComparator) {
        List<ShoppingOrder> list = this.findByGroupId(groupId, 0, 1, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public ShoppingOrder findByGroupId_Last(long groupId, OrderByComparator<ShoppingOrder> orderByComparator) throws NoSuchOrderException {
        ShoppingOrder shoppingOrder = this.fetchByGroupId_Last(groupId, orderByComparator);
        if (shoppingOrder != null) {
            return shoppingOrder;
        }
        StringBundler msg = new StringBundler(4);
        msg.append(_NO_SUCH_ENTITY_WITH_KEY);
        msg.append("groupId=");
        msg.append(groupId);
        msg.append("}");
        throw new NoSuchOrderException(msg.toString());
    }

    public ShoppingOrder fetchByGroupId_Last(long groupId, OrderByComparator<ShoppingOrder> orderByComparator) {
        int count = this.countByGroupId(groupId);
        if (count == 0) {
            return null;
        }
        List<ShoppingOrder> list = this.findByGroupId(groupId, count - 1, count, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public ShoppingOrder[] findByGroupId_PrevAndNext(long orderId, long groupId, OrderByComparator<ShoppingOrder> orderByComparator) throws NoSuchOrderException {
        ShoppingOrder shoppingOrder = this.findByPrimaryKey(orderId);
        Session session = null;
        try {
            session = this.openSession();
            ShoppingOrder[] array = new ShoppingOrderImpl[]{this.getByGroupId_PrevAndNext(session, shoppingOrder, groupId, orderByComparator, true), shoppingOrder, this.getByGroupId_PrevAndNext(session, shoppingOrder, groupId, orderByComparator, false)};
            ShoppingOrder[] shoppingOrderArray = array;
            return shoppingOrderArray;
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected ShoppingOrder getByGroupId_PrevAndNext(Session session, ShoppingOrder shoppingOrder, long groupId, OrderByComparator<ShoppingOrder> orderByComparator, boolean previous) {
        List list;
        StringBundler query = null;
        query = orderByComparator != null ? new StringBundler(4 + orderByComparator.getOrderByConditionFields().length * 3 + orderByComparator.getOrderByFields().length * 3) : new StringBundler(3);
        query.append(_SQL_SELECT_SHOPPINGORDER_WHERE);
        query.append(_FINDER_COLUMN_GROUPID_GROUPID_2);
        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();
            if (orderByConditionFields.length > 0) {
                query.append(" AND ");
            }
            for (int i = 0; i < orderByConditionFields.length; ++i) {
                query.append(_ORDER_BY_ENTITY_ALIAS);
                query.append(orderByConditionFields[i]);
                if (i + 1 < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(" >= ? AND ");
                        continue;
                    }
                    query.append(" <= ? AND ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    query.append(" >= ? ");
                    continue;
                }
                query.append(" <= ? ");
            }
            query.append(" ORDER BY ");
            String[] orderByFields = orderByComparator.getOrderByFields();
            for (int i = 0; i < orderByFields.length; ++i) {
                query.append(_ORDER_BY_ENTITY_ALIAS);
                query.append(orderByFields[i]);
                if (i + 1 < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(" ASC, ");
                        continue;
                    }
                    query.append(" DESC, ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    query.append(" ASC");
                    continue;
                }
                query.append(" DESC");
            }
        } else {
            query.append(" ORDER BY shoppingOrder.createDate DESC");
        }
        String sql = query.toString();
        Query q = session.createQuery(sql);
        q.setFirstResult(0);
        q.setMaxResults(2);
        QueryPos qPos = QueryPos.getInstance((Query)q);
        qPos.add(groupId);
        if (orderByComparator != null) {
            for (Object orderByConditionValue : orderByComparator.getOrderByConditionValues((Object)shoppingOrder)) {
                qPos.add(orderByConditionValue);
            }
        }
        if ((list = q.list()).size() == 2) {
            return (ShoppingOrder)list.get(1);
        }
        return null;
    }

    public List<ShoppingOrder> filterFindByGroupId(long groupId) {
        return this.filterFindByGroupId(groupId, -1, -1, null);
    }

    public List<ShoppingOrder> filterFindByGroupId(long groupId, int start, int end) {
        return this.filterFindByGroupId(groupId, start, end, null);
    }

    public List<ShoppingOrder> filterFindByGroupId(long groupId, int start, int end, OrderByComparator<ShoppingOrder> orderByComparator) {
        if (!InlineSQLHelperUtil.isEnabled((long)groupId)) {
            return this.findByGroupId(groupId, start, end, orderByComparator);
        }
        StringBundler query = null;
        query = orderByComparator != null ? new StringBundler(3 + orderByComparator.getOrderByFields().length * 2) : new StringBundler(4);
        if (this.getDB().isSupportsInlineDistinct()) {
            query.append(_FILTER_SQL_SELECT_SHOPPINGORDER_WHERE);
        } else {
            query.append(_FILTER_SQL_SELECT_SHOPPINGORDER_NO_INLINE_DISTINCT_WHERE_1);
        }
        query.append(_FINDER_COLUMN_GROUPID_GROUPID_2);
        if (!this.getDB().isSupportsInlineDistinct()) {
            query.append(_FILTER_SQL_SELECT_SHOPPINGORDER_NO_INLINE_DISTINCT_WHERE_2);
        }
        if (orderByComparator != null) {
            if (this.getDB().isSupportsInlineDistinct()) {
                this.appendOrderByComparator(query, _ORDER_BY_ENTITY_ALIAS, orderByComparator, true);
            } else {
                this.appendOrderByComparator(query, _ORDER_BY_ENTITY_TABLE, orderByComparator, true);
            }
        } else if (this.getDB().isSupportsInlineDistinct()) {
            query.append(" ORDER BY shoppingOrder.createDate DESC");
        } else {
            query.append(" ORDER BY ShoppingOrder.createDate DESC");
        }
        String sql = InlineSQLHelperUtil.replacePermissionCheck((String)query.toString(), (String)ShoppingOrder.class.getName(), (String)_FILTER_ENTITY_TABLE_FILTER_PK_COLUMN, (long)groupId);
        Session session = null;
        try {
            session = this.openSession();
            SQLQuery q = session.createSynchronizedSQLQuery(sql);
            if (this.getDB().isSupportsInlineDistinct()) {
                q.addEntity(_FILTER_ENTITY_ALIAS, ShoppingOrderImpl.class);
            } else {
                q.addEntity(_FILTER_ENTITY_TABLE, ShoppingOrderImpl.class);
            }
            QueryPos qPos = QueryPos.getInstance((Query)q);
            qPos.add(groupId);
            List list = QueryUtil.list((Query)q, (Dialect)this.getDialect(), (int)start, (int)end);
            return list;
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    public ShoppingOrder[] filterFindByGroupId_PrevAndNext(long orderId, long groupId, OrderByComparator<ShoppingOrder> orderByComparator) throws NoSuchOrderException {
        if (!InlineSQLHelperUtil.isEnabled((long)groupId)) {
            return this.findByGroupId_PrevAndNext(orderId, groupId, orderByComparator);
        }
        ShoppingOrder shoppingOrder = this.findByPrimaryKey(orderId);
        Session session = null;
        try {
            session = this.openSession();
            ShoppingOrder[] array = new ShoppingOrderImpl[]{this.filterGetByGroupId_PrevAndNext(session, shoppingOrder, groupId, orderByComparator, true), shoppingOrder, this.filterGetByGroupId_PrevAndNext(session, shoppingOrder, groupId, orderByComparator, false)};
            ShoppingOrder[] shoppingOrderArray = array;
            return shoppingOrderArray;
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected ShoppingOrder filterGetByGroupId_PrevAndNext(Session session, ShoppingOrder shoppingOrder, long groupId, OrderByComparator<ShoppingOrder> orderByComparator, boolean previous) {
        List list;
        StringBundler query = null;
        query = orderByComparator != null ? new StringBundler(5 + orderByComparator.getOrderByConditionFields().length * 3 + orderByComparator.getOrderByFields().length * 3) : new StringBundler(4);
        if (this.getDB().isSupportsInlineDistinct()) {
            query.append(_FILTER_SQL_SELECT_SHOPPINGORDER_WHERE);
        } else {
            query.append(_FILTER_SQL_SELECT_SHOPPINGORDER_NO_INLINE_DISTINCT_WHERE_1);
        }
        query.append(_FINDER_COLUMN_GROUPID_GROUPID_2);
        if (!this.getDB().isSupportsInlineDistinct()) {
            query.append(_FILTER_SQL_SELECT_SHOPPINGORDER_NO_INLINE_DISTINCT_WHERE_2);
        }
        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();
            if (orderByConditionFields.length > 0) {
                query.append(" AND ");
            }
            for (int i = 0; i < orderByConditionFields.length; ++i) {
                if (this.getDB().isSupportsInlineDistinct()) {
                    query.append(this.getColumnName(_ORDER_BY_ENTITY_ALIAS, orderByConditionFields[i], true));
                } else {
                    query.append(this.getColumnName(_ORDER_BY_ENTITY_TABLE, orderByConditionFields[i], true));
                }
                if (i + 1 < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(" >= ? AND ");
                        continue;
                    }
                    query.append(" <= ? AND ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    query.append(" >= ? ");
                    continue;
                }
                query.append(" <= ? ");
            }
            query.append(" ORDER BY ");
            String[] orderByFields = orderByComparator.getOrderByFields();
            for (int i = 0; i < orderByFields.length; ++i) {
                if (this.getDB().isSupportsInlineDistinct()) {
                    query.append(this.getColumnName(_ORDER_BY_ENTITY_ALIAS, orderByFields[i], true));
                } else {
                    query.append(this.getColumnName(_ORDER_BY_ENTITY_TABLE, orderByFields[i], true));
                }
                if (i + 1 < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(" ASC, ");
                        continue;
                    }
                    query.append(" DESC, ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    query.append(" ASC");
                    continue;
                }
                query.append(" DESC");
            }
        } else if (this.getDB().isSupportsInlineDistinct()) {
            query.append(" ORDER BY shoppingOrder.createDate DESC");
        } else {
            query.append(" ORDER BY ShoppingOrder.createDate DESC");
        }
        String sql = InlineSQLHelperUtil.replacePermissionCheck((String)query.toString(), (String)ShoppingOrder.class.getName(), (String)_FILTER_ENTITY_TABLE_FILTER_PK_COLUMN, (long)groupId);
        SQLQuery q = session.createSynchronizedSQLQuery(sql);
        q.setFirstResult(0);
        q.setMaxResults(2);
        if (this.getDB().isSupportsInlineDistinct()) {
            q.addEntity(_FILTER_ENTITY_ALIAS, ShoppingOrderImpl.class);
        } else {
            q.addEntity(_FILTER_ENTITY_TABLE, ShoppingOrderImpl.class);
        }
        QueryPos qPos = QueryPos.getInstance((Query)q);
        qPos.add(groupId);
        if (orderByComparator != null) {
            for (Object orderByConditionValue : orderByComparator.getOrderByConditionValues((Object)shoppingOrder)) {
                qPos.add(orderByConditionValue);
            }
        }
        if ((list = q.list()).size() == 2) {
            return (ShoppingOrder)list.get(1);
        }
        return null;
    }

    public void removeByGroupId(long groupId) {
        for (ShoppingOrder shoppingOrder : this.findByGroupId(groupId, -1, -1, null)) {
            this.remove((BaseModel)shoppingOrder);
        }
    }

    public int countByGroupId(long groupId) {
        FinderPath finderPath = this._finderPathCountByGroupId;
        Object[] finderArgs = new Object[]{groupId};
        Long count = (Long)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this);
        if (count == null) {
            StringBundler query = new StringBundler(2);
            query.append(_SQL_COUNT_SHOPPINGORDER_WHERE);
            query.append(_FINDER_COLUMN_GROUPID_GROUPID_2);
            String sql = query.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance((Query)q);
                qPos.add(groupId);
                count = (Long)q.uniqueResult();
                this.finderCache.putResult(finderPath, finderArgs, (Object)count);
            }
            catch (Exception exception) {
                this.finderCache.removeResult(finderPath, finderArgs);
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public int filterCountByGroupId(long groupId) {
        if (!InlineSQLHelperUtil.isEnabled((long)groupId)) {
            return this.countByGroupId(groupId);
        }
        StringBundler query = new StringBundler(2);
        query.append(_FILTER_SQL_COUNT_SHOPPINGORDER_WHERE);
        query.append(_FINDER_COLUMN_GROUPID_GROUPID_2);
        String sql = InlineSQLHelperUtil.replacePermissionCheck((String)query.toString(), (String)ShoppingOrder.class.getName(), (String)_FILTER_ENTITY_TABLE_FILTER_PK_COLUMN, (long)groupId);
        Session session = null;
        try {
            session = this.openSession();
            SQLQuery q = session.createSynchronizedSQLQuery(sql);
            q.addScalar("COUNT_VALUE", Type.LONG);
            QueryPos qPos = QueryPos.getInstance((Query)q);
            qPos.add(groupId);
            Long count = (Long)q.uniqueResult();
            int n = count.intValue();
            return n;
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    public ShoppingOrder findByNumber(String number) throws NoSuchOrderException {
        ShoppingOrder shoppingOrder = this.fetchByNumber(number);
        if (shoppingOrder == null) {
            StringBundler msg = new StringBundler(4);
            msg.append(_NO_SUCH_ENTITY_WITH_KEY);
            msg.append("number=");
            msg.append(number);
            msg.append("}");
            if (_log.isDebugEnabled()) {
                _log.debug((Object)msg.toString());
            }
            throw new NoSuchOrderException(msg.toString());
        }
        return shoppingOrder;
    }

    public ShoppingOrder fetchByNumber(String number) {
        return this.fetchByNumber(number, true);
    }

    public ShoppingOrder fetchByNumber(String number, boolean useFinderCache) {
        ShoppingOrder shoppingOrder;
        number = Objects.toString(number, "");
        Object[] finderArgs = null;
        if (useFinderCache) {
            finderArgs = new Object[]{number};
        }
        Object result = null;
        if (useFinderCache) {
            result = this.finderCache.getResult(this._finderPathFetchByNumber, finderArgs, (BasePersistenceImpl)this);
        }
        if (result instanceof ShoppingOrder && !Objects.equals(number, (shoppingOrder = (ShoppingOrder)result).getNumber())) {
            result = null;
        }
        if (result == null) {
            StringBundler query = new StringBundler(3);
            query.append(_SQL_SELECT_SHOPPINGORDER_WHERE);
            boolean bindNumber = false;
            if (number.isEmpty()) {
                query.append(_FINDER_COLUMN_NUMBER_NUMBER_3);
            } else {
                bindNumber = true;
                query.append(_FINDER_COLUMN_NUMBER_NUMBER_2);
            }
            String sql = query.toString();
            Session session = null;
            try {
                List list;
                session = this.openSession();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance((Query)q);
                if (bindNumber) {
                    qPos.add(number);
                }
                if ((list = q.list()).isEmpty()) {
                    if (useFinderCache) {
                        this.finderCache.putResult(this._finderPathFetchByNumber, finderArgs, (Object)list);
                    }
                } else {
                    ShoppingOrder shoppingOrder2 = (ShoppingOrder)list.get(0);
                    result = shoppingOrder2;
                    this.cacheResult(shoppingOrder2);
                }
            }
            catch (Exception exception) {
                if (useFinderCache) {
                    this.finderCache.removeResult(this._finderPathFetchByNumber, finderArgs);
                }
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        if (result instanceof List) {
            return null;
        }
        return (ShoppingOrder)result;
    }

    public ShoppingOrder removeByNumber(String number) throws NoSuchOrderException {
        ShoppingOrder shoppingOrder = this.findByNumber(number);
        return (ShoppingOrder)this.remove((BaseModel)shoppingOrder);
    }

    public int countByNumber(String number) {
        number = Objects.toString(number, "");
        FinderPath finderPath = this._finderPathCountByNumber;
        Object[] finderArgs = new Object[]{number};
        Long count = (Long)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this);
        if (count == null) {
            StringBundler query = new StringBundler(2);
            query.append(_SQL_COUNT_SHOPPINGORDER_WHERE);
            boolean bindNumber = false;
            if (number.isEmpty()) {
                query.append(_FINDER_COLUMN_NUMBER_NUMBER_3);
            } else {
                bindNumber = true;
                query.append(_FINDER_COLUMN_NUMBER_NUMBER_2);
            }
            String sql = query.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance((Query)q);
                if (bindNumber) {
                    qPos.add(number);
                }
                count = (Long)q.uniqueResult();
                this.finderCache.putResult(finderPath, finderArgs, (Object)count);
            }
            catch (Exception exception) {
                this.finderCache.removeResult(finderPath, finderArgs);
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public ShoppingOrder findByPPTxnId(String ppTxnId) throws NoSuchOrderException {
        ShoppingOrder shoppingOrder = this.fetchByPPTxnId(ppTxnId);
        if (shoppingOrder == null) {
            StringBundler msg = new StringBundler(4);
            msg.append(_NO_SUCH_ENTITY_WITH_KEY);
            msg.append("ppTxnId=");
            msg.append(ppTxnId);
            msg.append("}");
            if (_log.isDebugEnabled()) {
                _log.debug((Object)msg.toString());
            }
            throw new NoSuchOrderException(msg.toString());
        }
        return shoppingOrder;
    }

    public ShoppingOrder fetchByPPTxnId(String ppTxnId) {
        return this.fetchByPPTxnId(ppTxnId, true);
    }

    public ShoppingOrder fetchByPPTxnId(String ppTxnId, boolean useFinderCache) {
        ShoppingOrder shoppingOrder;
        ppTxnId = Objects.toString(ppTxnId, "");
        Object[] finderArgs = null;
        if (useFinderCache) {
            finderArgs = new Object[]{ppTxnId};
        }
        Object result = null;
        if (useFinderCache) {
            result = this.finderCache.getResult(this._finderPathFetchByPPTxnId, finderArgs, (BasePersistenceImpl)this);
        }
        if (result instanceof ShoppingOrder && !Objects.equals(ppTxnId, (shoppingOrder = (ShoppingOrder)result).getPpTxnId())) {
            result = null;
        }
        if (result == null) {
            StringBundler query = new StringBundler(3);
            query.append(_SQL_SELECT_SHOPPINGORDER_WHERE);
            boolean bindPpTxnId = false;
            if (ppTxnId.isEmpty()) {
                query.append(_FINDER_COLUMN_PPTXNID_PPTXNID_3);
            } else {
                bindPpTxnId = true;
                query.append(_FINDER_COLUMN_PPTXNID_PPTXNID_2);
            }
            String sql = query.toString();
            Session session = null;
            try {
                List list;
                session = this.openSession();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance((Query)q);
                if (bindPpTxnId) {
                    qPos.add(ppTxnId);
                }
                if ((list = q.list()).isEmpty()) {
                    if (useFinderCache) {
                        this.finderCache.putResult(this._finderPathFetchByPPTxnId, finderArgs, (Object)list);
                    }
                } else {
                    if (list.size() > 1) {
                        Collections.sort(list, Collections.reverseOrder());
                        if (_log.isWarnEnabled()) {
                            if (!useFinderCache) {
                                finderArgs = new Object[]{ppTxnId};
                            }
                            _log.warn((Object)("ShoppingOrderPersistenceImpl.fetchByPPTxnId(String, boolean) with parameters (" + StringUtil.merge((Object[])finderArgs) + ") yields a result set with more than 1 result. This violates the logical unique restriction. There is no order guarantee on which result is returned by this finder."));
                        }
                    }
                    ShoppingOrder shoppingOrder2 = (ShoppingOrder)list.get(0);
                    result = shoppingOrder2;
                    this.cacheResult(shoppingOrder2);
                }
            }
            catch (Exception exception) {
                if (useFinderCache) {
                    this.finderCache.removeResult(this._finderPathFetchByPPTxnId, finderArgs);
                }
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        if (result instanceof List) {
            return null;
        }
        return (ShoppingOrder)result;
    }

    public ShoppingOrder removeByPPTxnId(String ppTxnId) throws NoSuchOrderException {
        ShoppingOrder shoppingOrder = this.findByPPTxnId(ppTxnId);
        return (ShoppingOrder)this.remove((BaseModel)shoppingOrder);
    }

    public int countByPPTxnId(String ppTxnId) {
        ppTxnId = Objects.toString(ppTxnId, "");
        FinderPath finderPath = this._finderPathCountByPPTxnId;
        Object[] finderArgs = new Object[]{ppTxnId};
        Long count = (Long)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this);
        if (count == null) {
            StringBundler query = new StringBundler(2);
            query.append(_SQL_COUNT_SHOPPINGORDER_WHERE);
            boolean bindPpTxnId = false;
            if (ppTxnId.isEmpty()) {
                query.append(_FINDER_COLUMN_PPTXNID_PPTXNID_3);
            } else {
                bindPpTxnId = true;
                query.append(_FINDER_COLUMN_PPTXNID_PPTXNID_2);
            }
            String sql = query.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance((Query)q);
                if (bindPpTxnId) {
                    qPos.add(ppTxnId);
                }
                count = (Long)q.uniqueResult();
                this.finderCache.putResult(finderPath, finderArgs, (Object)count);
            }
            catch (Exception exception) {
                this.finderCache.removeResult(finderPath, finderArgs);
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public List<ShoppingOrder> findByG_U_PPPS(long groupId, long userId, String ppPaymentStatus) {
        return this.findByG_U_PPPS(groupId, userId, ppPaymentStatus, -1, -1, null);
    }

    public List<ShoppingOrder> findByG_U_PPPS(long groupId, long userId, String ppPaymentStatus, int start, int end) {
        return this.findByG_U_PPPS(groupId, userId, ppPaymentStatus, start, end, null);
    }

    public List<ShoppingOrder> findByG_U_PPPS(long groupId, long userId, String ppPaymentStatus, int start, int end, OrderByComparator<ShoppingOrder> orderByComparator) {
        return this.findByG_U_PPPS(groupId, userId, ppPaymentStatus, start, end, orderByComparator, true);
    }

    public List<ShoppingOrder> findByG_U_PPPS(long groupId, long userId, String ppPaymentStatus, int start, int end, OrderByComparator<ShoppingOrder> orderByComparator, boolean useFinderCache) {
        ppPaymentStatus = Objects.toString(ppPaymentStatus, "");
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            if (useFinderCache) {
                finderPath = this._finderPathWithoutPaginationFindByG_U_PPPS;
                finderArgs = new Object[]{groupId, userId, ppPaymentStatus};
            }
        } else if (useFinderCache) {
            finderPath = this._finderPathWithPaginationFindByG_U_PPPS;
            finderArgs = new Object[]{groupId, userId, ppPaymentStatus, start, end, orderByComparator};
        }
        List list = null;
        if (useFinderCache && (list = (List)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this)) != null && !list.isEmpty()) {
            for (ShoppingOrder shoppingOrder : list) {
                if (groupId == shoppingOrder.getGroupId() && userId == shoppingOrder.getUserId() && ppPaymentStatus.equals(shoppingOrder.getPpPaymentStatus())) continue;
                list = null;
                break;
            }
        }
        if (list == null) {
            StringBundler query = null;
            query = orderByComparator != null ? new StringBundler(5 + orderByComparator.getOrderByFields().length * 2) : new StringBundler(5);
            query.append(_SQL_SELECT_SHOPPINGORDER_WHERE);
            query.append(_FINDER_COLUMN_G_U_PPPS_GROUPID_2);
            query.append(_FINDER_COLUMN_G_U_PPPS_USERID_2);
            boolean bindPpPaymentStatus = false;
            if (ppPaymentStatus.isEmpty()) {
                query.append(_FINDER_COLUMN_G_U_PPPS_PPPAYMENTSTATUS_3);
            } else {
                bindPpPaymentStatus = true;
                query.append(_FINDER_COLUMN_G_U_PPPS_PPPAYMENTSTATUS_2);
            }
            if (orderByComparator != null) {
                this.appendOrderByComparator(query, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
            } else {
                query.append(" ORDER BY shoppingOrder.createDate DESC");
            }
            String sql = query.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance((Query)q);
                qPos.add(groupId);
                qPos.add(userId);
                if (bindPpPaymentStatus) {
                    qPos.add(ppPaymentStatus);
                }
                list = QueryUtil.list((Query)q, (Dialect)this.getDialect(), (int)start, (int)end);
                this.cacheResult(list);
                if (useFinderCache) {
                    this.finderCache.putResult(finderPath, finderArgs, (Object)list);
                }
            }
            catch (Exception exception) {
                if (useFinderCache) {
                    this.finderCache.removeResult(finderPath, finderArgs);
                }
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    public ShoppingOrder findByG_U_PPPS_First(long groupId, long userId, String ppPaymentStatus, OrderByComparator<ShoppingOrder> orderByComparator) throws NoSuchOrderException {
        ShoppingOrder shoppingOrder = this.fetchByG_U_PPPS_First(groupId, userId, ppPaymentStatus, orderByComparator);
        if (shoppingOrder != null) {
            return shoppingOrder;
        }
        StringBundler msg = new StringBundler(8);
        msg.append(_NO_SUCH_ENTITY_WITH_KEY);
        msg.append("groupId=");
        msg.append(groupId);
        msg.append(", userId=");
        msg.append(userId);
        msg.append(", ppPaymentStatus=");
        msg.append(ppPaymentStatus);
        msg.append("}");
        throw new NoSuchOrderException(msg.toString());
    }

    public ShoppingOrder fetchByG_U_PPPS_First(long groupId, long userId, String ppPaymentStatus, OrderByComparator<ShoppingOrder> orderByComparator) {
        List<ShoppingOrder> list = this.findByG_U_PPPS(groupId, userId, ppPaymentStatus, 0, 1, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public ShoppingOrder findByG_U_PPPS_Last(long groupId, long userId, String ppPaymentStatus, OrderByComparator<ShoppingOrder> orderByComparator) throws NoSuchOrderException {
        ShoppingOrder shoppingOrder = this.fetchByG_U_PPPS_Last(groupId, userId, ppPaymentStatus, orderByComparator);
        if (shoppingOrder != null) {
            return shoppingOrder;
        }
        StringBundler msg = new StringBundler(8);
        msg.append(_NO_SUCH_ENTITY_WITH_KEY);
        msg.append("groupId=");
        msg.append(groupId);
        msg.append(", userId=");
        msg.append(userId);
        msg.append(", ppPaymentStatus=");
        msg.append(ppPaymentStatus);
        msg.append("}");
        throw new NoSuchOrderException(msg.toString());
    }

    public ShoppingOrder fetchByG_U_PPPS_Last(long groupId, long userId, String ppPaymentStatus, OrderByComparator<ShoppingOrder> orderByComparator) {
        int count = this.countByG_U_PPPS(groupId, userId, ppPaymentStatus);
        if (count == 0) {
            return null;
        }
        List<ShoppingOrder> list = this.findByG_U_PPPS(groupId, userId, ppPaymentStatus, count - 1, count, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public ShoppingOrder[] findByG_U_PPPS_PrevAndNext(long orderId, long groupId, long userId, String ppPaymentStatus, OrderByComparator<ShoppingOrder> orderByComparator) throws NoSuchOrderException {
        ppPaymentStatus = Objects.toString(ppPaymentStatus, "");
        ShoppingOrder shoppingOrder = this.findByPrimaryKey(orderId);
        Session session = null;
        try {
            session = this.openSession();
            ShoppingOrder[] array = new ShoppingOrderImpl[]{this.getByG_U_PPPS_PrevAndNext(session, shoppingOrder, groupId, userId, ppPaymentStatus, orderByComparator, true), shoppingOrder, this.getByG_U_PPPS_PrevAndNext(session, shoppingOrder, groupId, userId, ppPaymentStatus, orderByComparator, false)};
            ShoppingOrder[] shoppingOrderArray = array;
            return shoppingOrderArray;
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected ShoppingOrder getByG_U_PPPS_PrevAndNext(Session session, ShoppingOrder shoppingOrder, long groupId, long userId, String ppPaymentStatus, OrderByComparator<ShoppingOrder> orderByComparator, boolean previous) {
        List list;
        StringBundler query = null;
        query = orderByComparator != null ? new StringBundler(6 + orderByComparator.getOrderByConditionFields().length * 3 + orderByComparator.getOrderByFields().length * 3) : new StringBundler(5);
        query.append(_SQL_SELECT_SHOPPINGORDER_WHERE);
        query.append(_FINDER_COLUMN_G_U_PPPS_GROUPID_2);
        query.append(_FINDER_COLUMN_G_U_PPPS_USERID_2);
        boolean bindPpPaymentStatus = false;
        if (ppPaymentStatus.isEmpty()) {
            query.append(_FINDER_COLUMN_G_U_PPPS_PPPAYMENTSTATUS_3);
        } else {
            bindPpPaymentStatus = true;
            query.append(_FINDER_COLUMN_G_U_PPPS_PPPAYMENTSTATUS_2);
        }
        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();
            if (orderByConditionFields.length > 0) {
                query.append(" AND ");
            }
            for (int i = 0; i < orderByConditionFields.length; ++i) {
                query.append(_ORDER_BY_ENTITY_ALIAS);
                query.append(orderByConditionFields[i]);
                if (i + 1 < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(" >= ? AND ");
                        continue;
                    }
                    query.append(" <= ? AND ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    query.append(" >= ? ");
                    continue;
                }
                query.append(" <= ? ");
            }
            query.append(" ORDER BY ");
            String[] orderByFields = orderByComparator.getOrderByFields();
            for (int i = 0; i < orderByFields.length; ++i) {
                query.append(_ORDER_BY_ENTITY_ALIAS);
                query.append(orderByFields[i]);
                if (i + 1 < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(" ASC, ");
                        continue;
                    }
                    query.append(" DESC, ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    query.append(" ASC");
                    continue;
                }
                query.append(" DESC");
            }
        } else {
            query.append(" ORDER BY shoppingOrder.createDate DESC");
        }
        String sql = query.toString();
        Query q = session.createQuery(sql);
        q.setFirstResult(0);
        q.setMaxResults(2);
        QueryPos qPos = QueryPos.getInstance((Query)q);
        qPos.add(groupId);
        qPos.add(userId);
        if (bindPpPaymentStatus) {
            qPos.add(ppPaymentStatus);
        }
        if (orderByComparator != null) {
            for (Object orderByConditionValue : orderByComparator.getOrderByConditionValues((Object)shoppingOrder)) {
                qPos.add(orderByConditionValue);
            }
        }
        if ((list = q.list()).size() == 2) {
            return (ShoppingOrder)list.get(1);
        }
        return null;
    }

    public List<ShoppingOrder> filterFindByG_U_PPPS(long groupId, long userId, String ppPaymentStatus) {
        return this.filterFindByG_U_PPPS(groupId, userId, ppPaymentStatus, -1, -1, null);
    }

    public List<ShoppingOrder> filterFindByG_U_PPPS(long groupId, long userId, String ppPaymentStatus, int start, int end) {
        return this.filterFindByG_U_PPPS(groupId, userId, ppPaymentStatus, start, end, null);
    }

    public List<ShoppingOrder> filterFindByG_U_PPPS(long groupId, long userId, String ppPaymentStatus, int start, int end, OrderByComparator<ShoppingOrder> orderByComparator) {
        if (!InlineSQLHelperUtil.isEnabled((long)groupId)) {
            return this.findByG_U_PPPS(groupId, userId, ppPaymentStatus, start, end, orderByComparator);
        }
        ppPaymentStatus = Objects.toString(ppPaymentStatus, "");
        StringBundler query = null;
        query = orderByComparator != null ? new StringBundler(5 + orderByComparator.getOrderByFields().length * 2) : new StringBundler(6);
        if (this.getDB().isSupportsInlineDistinct()) {
            query.append(_FILTER_SQL_SELECT_SHOPPINGORDER_WHERE);
        } else {
            query.append(_FILTER_SQL_SELECT_SHOPPINGORDER_NO_INLINE_DISTINCT_WHERE_1);
        }
        query.append(_FINDER_COLUMN_G_U_PPPS_GROUPID_2);
        query.append(_FINDER_COLUMN_G_U_PPPS_USERID_2);
        boolean bindPpPaymentStatus = false;
        if (ppPaymentStatus.isEmpty()) {
            query.append(_FINDER_COLUMN_G_U_PPPS_PPPAYMENTSTATUS_3);
        } else {
            bindPpPaymentStatus = true;
            query.append(_FINDER_COLUMN_G_U_PPPS_PPPAYMENTSTATUS_2);
        }
        if (!this.getDB().isSupportsInlineDistinct()) {
            query.append(_FILTER_SQL_SELECT_SHOPPINGORDER_NO_INLINE_DISTINCT_WHERE_2);
        }
        if (orderByComparator != null) {
            if (this.getDB().isSupportsInlineDistinct()) {
                this.appendOrderByComparator(query, _ORDER_BY_ENTITY_ALIAS, orderByComparator, true);
            } else {
                this.appendOrderByComparator(query, _ORDER_BY_ENTITY_TABLE, orderByComparator, true);
            }
        } else if (this.getDB().isSupportsInlineDistinct()) {
            query.append(" ORDER BY shoppingOrder.createDate DESC");
        } else {
            query.append(" ORDER BY ShoppingOrder.createDate DESC");
        }
        String sql = InlineSQLHelperUtil.replacePermissionCheck((String)query.toString(), (String)ShoppingOrder.class.getName(), (String)_FILTER_ENTITY_TABLE_FILTER_PK_COLUMN, (long)groupId);
        Session session = null;
        try {
            session = this.openSession();
            SQLQuery q = session.createSynchronizedSQLQuery(sql);
            if (this.getDB().isSupportsInlineDistinct()) {
                q.addEntity(_FILTER_ENTITY_ALIAS, ShoppingOrderImpl.class);
            } else {
                q.addEntity(_FILTER_ENTITY_TABLE, ShoppingOrderImpl.class);
            }
            QueryPos qPos = QueryPos.getInstance((Query)q);
            qPos.add(groupId);
            qPos.add(userId);
            if (bindPpPaymentStatus) {
                qPos.add(ppPaymentStatus);
            }
            List list = QueryUtil.list((Query)q, (Dialect)this.getDialect(), (int)start, (int)end);
            return list;
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    public ShoppingOrder[] filterFindByG_U_PPPS_PrevAndNext(long orderId, long groupId, long userId, String ppPaymentStatus, OrderByComparator<ShoppingOrder> orderByComparator) throws NoSuchOrderException {
        if (!InlineSQLHelperUtil.isEnabled((long)groupId)) {
            return this.findByG_U_PPPS_PrevAndNext(orderId, groupId, userId, ppPaymentStatus, orderByComparator);
        }
        ppPaymentStatus = Objects.toString(ppPaymentStatus, "");
        ShoppingOrder shoppingOrder = this.findByPrimaryKey(orderId);
        Session session = null;
        try {
            session = this.openSession();
            ShoppingOrder[] array = new ShoppingOrderImpl[]{this.filterGetByG_U_PPPS_PrevAndNext(session, shoppingOrder, groupId, userId, ppPaymentStatus, orderByComparator, true), shoppingOrder, this.filterGetByG_U_PPPS_PrevAndNext(session, shoppingOrder, groupId, userId, ppPaymentStatus, orderByComparator, false)};
            ShoppingOrder[] shoppingOrderArray = array;
            return shoppingOrderArray;
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected ShoppingOrder filterGetByG_U_PPPS_PrevAndNext(Session session, ShoppingOrder shoppingOrder, long groupId, long userId, String ppPaymentStatus, OrderByComparator<ShoppingOrder> orderByComparator, boolean previous) {
        List list;
        StringBundler query = null;
        query = orderByComparator != null ? new StringBundler(7 + orderByComparator.getOrderByConditionFields().length * 3 + orderByComparator.getOrderByFields().length * 3) : new StringBundler(6);
        if (this.getDB().isSupportsInlineDistinct()) {
            query.append(_FILTER_SQL_SELECT_SHOPPINGORDER_WHERE);
        } else {
            query.append(_FILTER_SQL_SELECT_SHOPPINGORDER_NO_INLINE_DISTINCT_WHERE_1);
        }
        query.append(_FINDER_COLUMN_G_U_PPPS_GROUPID_2);
        query.append(_FINDER_COLUMN_G_U_PPPS_USERID_2);
        boolean bindPpPaymentStatus = false;
        if (ppPaymentStatus.isEmpty()) {
            query.append(_FINDER_COLUMN_G_U_PPPS_PPPAYMENTSTATUS_3);
        } else {
            bindPpPaymentStatus = true;
            query.append(_FINDER_COLUMN_G_U_PPPS_PPPAYMENTSTATUS_2);
        }
        if (!this.getDB().isSupportsInlineDistinct()) {
            query.append(_FILTER_SQL_SELECT_SHOPPINGORDER_NO_INLINE_DISTINCT_WHERE_2);
        }
        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();
            if (orderByConditionFields.length > 0) {
                query.append(" AND ");
            }
            for (int i = 0; i < orderByConditionFields.length; ++i) {
                if (this.getDB().isSupportsInlineDistinct()) {
                    query.append(this.getColumnName(_ORDER_BY_ENTITY_ALIAS, orderByConditionFields[i], true));
                } else {
                    query.append(this.getColumnName(_ORDER_BY_ENTITY_TABLE, orderByConditionFields[i], true));
                }
                if (i + 1 < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(" >= ? AND ");
                        continue;
                    }
                    query.append(" <= ? AND ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    query.append(" >= ? ");
                    continue;
                }
                query.append(" <= ? ");
            }
            query.append(" ORDER BY ");
            String[] orderByFields = orderByComparator.getOrderByFields();
            for (int i = 0; i < orderByFields.length; ++i) {
                if (this.getDB().isSupportsInlineDistinct()) {
                    query.append(this.getColumnName(_ORDER_BY_ENTITY_ALIAS, orderByFields[i], true));
                } else {
                    query.append(this.getColumnName(_ORDER_BY_ENTITY_TABLE, orderByFields[i], true));
                }
                if (i + 1 < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(" ASC, ");
                        continue;
                    }
                    query.append(" DESC, ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    query.append(" ASC");
                    continue;
                }
                query.append(" DESC");
            }
        } else if (this.getDB().isSupportsInlineDistinct()) {
            query.append(" ORDER BY shoppingOrder.createDate DESC");
        } else {
            query.append(" ORDER BY ShoppingOrder.createDate DESC");
        }
        String sql = InlineSQLHelperUtil.replacePermissionCheck((String)query.toString(), (String)ShoppingOrder.class.getName(), (String)_FILTER_ENTITY_TABLE_FILTER_PK_COLUMN, (long)groupId);
        SQLQuery q = session.createSynchronizedSQLQuery(sql);
        q.setFirstResult(0);
        q.setMaxResults(2);
        if (this.getDB().isSupportsInlineDistinct()) {
            q.addEntity(_FILTER_ENTITY_ALIAS, ShoppingOrderImpl.class);
        } else {
            q.addEntity(_FILTER_ENTITY_TABLE, ShoppingOrderImpl.class);
        }
        QueryPos qPos = QueryPos.getInstance((Query)q);
        qPos.add(groupId);
        qPos.add(userId);
        if (bindPpPaymentStatus) {
            qPos.add(ppPaymentStatus);
        }
        if (orderByComparator != null) {
            for (Object orderByConditionValue : orderByComparator.getOrderByConditionValues((Object)shoppingOrder)) {
                qPos.add(orderByConditionValue);
            }
        }
        if ((list = q.list()).size() == 2) {
            return (ShoppingOrder)list.get(1);
        }
        return null;
    }

    public void removeByG_U_PPPS(long groupId, long userId, String ppPaymentStatus) {
        for (ShoppingOrder shoppingOrder : this.findByG_U_PPPS(groupId, userId, ppPaymentStatus, -1, -1, null)) {
            this.remove((BaseModel)shoppingOrder);
        }
    }

    public int countByG_U_PPPS(long groupId, long userId, String ppPaymentStatus) {
        ppPaymentStatus = Objects.toString(ppPaymentStatus, "");
        FinderPath finderPath = this._finderPathCountByG_U_PPPS;
        Object[] finderArgs = new Object[]{groupId, userId, ppPaymentStatus};
        Long count = (Long)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this);
        if (count == null) {
            StringBundler query = new StringBundler(4);
            query.append(_SQL_COUNT_SHOPPINGORDER_WHERE);
            query.append(_FINDER_COLUMN_G_U_PPPS_GROUPID_2);
            query.append(_FINDER_COLUMN_G_U_PPPS_USERID_2);
            boolean bindPpPaymentStatus = false;
            if (ppPaymentStatus.isEmpty()) {
                query.append(_FINDER_COLUMN_G_U_PPPS_PPPAYMENTSTATUS_3);
            } else {
                bindPpPaymentStatus = true;
                query.append(_FINDER_COLUMN_G_U_PPPS_PPPAYMENTSTATUS_2);
            }
            String sql = query.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance((Query)q);
                qPos.add(groupId);
                qPos.add(userId);
                if (bindPpPaymentStatus) {
                    qPos.add(ppPaymentStatus);
                }
                count = (Long)q.uniqueResult();
                this.finderCache.putResult(finderPath, finderArgs, (Object)count);
            }
            catch (Exception exception) {
                this.finderCache.removeResult(finderPath, finderArgs);
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public int filterCountByG_U_PPPS(long groupId, long userId, String ppPaymentStatus) {
        if (!InlineSQLHelperUtil.isEnabled((long)groupId)) {
            return this.countByG_U_PPPS(groupId, userId, ppPaymentStatus);
        }
        ppPaymentStatus = Objects.toString(ppPaymentStatus, "");
        StringBundler query = new StringBundler(4);
        query.append(_FILTER_SQL_COUNT_SHOPPINGORDER_WHERE);
        query.append(_FINDER_COLUMN_G_U_PPPS_GROUPID_2);
        query.append(_FINDER_COLUMN_G_U_PPPS_USERID_2);
        boolean bindPpPaymentStatus = false;
        if (ppPaymentStatus.isEmpty()) {
            query.append(_FINDER_COLUMN_G_U_PPPS_PPPAYMENTSTATUS_3);
        } else {
            bindPpPaymentStatus = true;
            query.append(_FINDER_COLUMN_G_U_PPPS_PPPAYMENTSTATUS_2);
        }
        String sql = InlineSQLHelperUtil.replacePermissionCheck((String)query.toString(), (String)ShoppingOrder.class.getName(), (String)_FILTER_ENTITY_TABLE_FILTER_PK_COLUMN, (long)groupId);
        Session session = null;
        try {
            session = this.openSession();
            SQLQuery q = session.createSynchronizedSQLQuery(sql);
            q.addScalar("COUNT_VALUE", Type.LONG);
            QueryPos qPos = QueryPos.getInstance((Query)q);
            qPos.add(groupId);
            qPos.add(userId);
            if (bindPpPaymentStatus) {
                qPos.add(ppPaymentStatus);
            }
            Long count = (Long)q.uniqueResult();
            int n = count.intValue();
            return n;
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    public ShoppingOrderPersistenceImpl() {
        block2: {
            this.setModelClass(ShoppingOrder.class);
            HashMap<String, String> dbColumnNames = new HashMap<String, String>();
            dbColumnNames.put("number", "number_");
            try {
                Field field = BasePersistenceImpl.class.getDeclaredField("_dbColumnNames");
                field.setAccessible(true);
                field.set((Object)this, dbColumnNames);
            }
            catch (Exception exception) {
                if (!_log.isDebugEnabled()) break block2;
                _log.debug((Object)exception, (Throwable)exception);
            }
        }
    }

    public void cacheResult(ShoppingOrder shoppingOrder) {
        this.entityCache.putResult(ShoppingOrderModelImpl.ENTITY_CACHE_ENABLED, ShoppingOrderImpl.class, (Serializable)Long.valueOf(shoppingOrder.getPrimaryKey()), (Serializable)shoppingOrder);
        this.finderCache.putResult(this._finderPathFetchByNumber, new Object[]{shoppingOrder.getNumber()}, (Object)shoppingOrder);
        this.finderCache.putResult(this._finderPathFetchByPPTxnId, new Object[]{shoppingOrder.getPpTxnId()}, (Object)shoppingOrder);
        shoppingOrder.resetOriginalValues();
    }

    public void cacheResult(List<ShoppingOrder> shoppingOrders) {
        for (ShoppingOrder shoppingOrder : shoppingOrders) {
            if (this.entityCache.getResult(ShoppingOrderModelImpl.ENTITY_CACHE_ENABLED, ShoppingOrderImpl.class, (Serializable)Long.valueOf(shoppingOrder.getPrimaryKey())) == null) {
                this.cacheResult(shoppingOrder);
                continue;
            }
            shoppingOrder.resetOriginalValues();
        }
    }

    public void clearCache() {
        this.entityCache.clearCache(ShoppingOrderImpl.class);
        this.finderCache.clearCache(FINDER_CLASS_NAME_ENTITY);
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
    }

    public void clearCache(ShoppingOrder shoppingOrder) {
        this.entityCache.removeResult(ShoppingOrderModelImpl.ENTITY_CACHE_ENABLED, ShoppingOrderImpl.class, (Serializable)Long.valueOf(shoppingOrder.getPrimaryKey()));
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
        this.clearUniqueFindersCache((ShoppingOrderModelImpl)shoppingOrder, true);
    }

    public void clearCache(List<ShoppingOrder> shoppingOrders) {
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
        for (ShoppingOrder shoppingOrder : shoppingOrders) {
            this.entityCache.removeResult(ShoppingOrderModelImpl.ENTITY_CACHE_ENABLED, ShoppingOrderImpl.class, (Serializable)Long.valueOf(shoppingOrder.getPrimaryKey()));
            this.clearUniqueFindersCache((ShoppingOrderModelImpl)shoppingOrder, true);
        }
    }

    public void clearCache(Set<Serializable> primaryKeys) {
        this.finderCache.clearCache(FINDER_CLASS_NAME_ENTITY);
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
        for (Serializable primaryKey : primaryKeys) {
            this.entityCache.removeResult(ShoppingOrderModelImpl.ENTITY_CACHE_ENABLED, ShoppingOrderImpl.class, primaryKey);
        }
    }

    protected void cacheUniqueFindersCache(ShoppingOrderModelImpl shoppingOrderModelImpl) {
        Object[] args = new Object[]{shoppingOrderModelImpl.getNumber()};
        this.finderCache.putResult(this._finderPathCountByNumber, args, (Object)1L, false);
        this.finderCache.putResult(this._finderPathFetchByNumber, args, (Object)shoppingOrderModelImpl, false);
        args = new Object[]{shoppingOrderModelImpl.getPpTxnId()};
        this.finderCache.putResult(this._finderPathCountByPPTxnId, args, (Object)1L, false);
        this.finderCache.putResult(this._finderPathFetchByPPTxnId, args, (Object)shoppingOrderModelImpl, false);
    }

    protected void clearUniqueFindersCache(ShoppingOrderModelImpl shoppingOrderModelImpl, boolean clearCurrent) {
        Object[] args;
        if (clearCurrent) {
            args = new Object[]{shoppingOrderModelImpl.getNumber()};
            this.finderCache.removeResult(this._finderPathCountByNumber, args);
            this.finderCache.removeResult(this._finderPathFetchByNumber, args);
        }
        if ((shoppingOrderModelImpl.getColumnBitmask() & this._finderPathFetchByNumber.getColumnBitmask()) != 0L) {
            args = new Object[]{shoppingOrderModelImpl.getOriginalNumber()};
            this.finderCache.removeResult(this._finderPathCountByNumber, args);
            this.finderCache.removeResult(this._finderPathFetchByNumber, args);
        }
        if (clearCurrent) {
            args = new Object[]{shoppingOrderModelImpl.getPpTxnId()};
            this.finderCache.removeResult(this._finderPathCountByPPTxnId, args);
            this.finderCache.removeResult(this._finderPathFetchByPPTxnId, args);
        }
        if ((shoppingOrderModelImpl.getColumnBitmask() & this._finderPathFetchByPPTxnId.getColumnBitmask()) != 0L) {
            args = new Object[]{shoppingOrderModelImpl.getOriginalPpTxnId()};
            this.finderCache.removeResult(this._finderPathCountByPPTxnId, args);
            this.finderCache.removeResult(this._finderPathFetchByPPTxnId, args);
        }
    }

    public ShoppingOrder create(long orderId) {
        ShoppingOrderImpl shoppingOrder = new ShoppingOrderImpl();
        shoppingOrder.setNew(true);
        shoppingOrder.setPrimaryKey(orderId);
        shoppingOrder.setCompanyId(CompanyThreadLocal.getCompanyId());
        return shoppingOrder;
    }

    public ShoppingOrder remove(long orderId) throws NoSuchOrderException {
        return this.remove(Long.valueOf(orderId));
    }

    public ShoppingOrder remove(Serializable primaryKey) throws NoSuchOrderException {
        Session session = null;
        try {
            session = this.openSession();
            ShoppingOrder shoppingOrder = (ShoppingOrder)session.get(ShoppingOrderImpl.class, primaryKey);
            if (shoppingOrder == null) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey));
                }
                throw new NoSuchOrderException(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey);
            }
            ShoppingOrder shoppingOrder2 = (ShoppingOrder)this.remove((BaseModel)shoppingOrder);
            return shoppingOrder2;
        }
        catch (NoSuchOrderException noSuchEntityException) {
            throw noSuchEntityException;
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected ShoppingOrder removeImpl(ShoppingOrder shoppingOrder) {
        Session session = null;
        try {
            session = this.openSession();
            if (!session.contains((Object)shoppingOrder)) {
                shoppingOrder = (ShoppingOrder)session.get(ShoppingOrderImpl.class, shoppingOrder.getPrimaryKeyObj());
            }
            if (shoppingOrder != null) {
                session.delete((Object)shoppingOrder);
            }
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
        if (shoppingOrder != null) {
            this.clearCache(shoppingOrder);
        }
        return shoppingOrder;
    }

    public ShoppingOrder updateImpl(ShoppingOrder shoppingOrder) {
        boolean isNew = shoppingOrder.isNew();
        if (!(shoppingOrder instanceof ShoppingOrderModelImpl)) {
            InvocationHandler invocationHandler = null;
            if (ProxyUtil.isProxyClass(shoppingOrder.getClass())) {
                invocationHandler = ProxyUtil.getInvocationHandler((Object)shoppingOrder);
                throw new IllegalArgumentException("Implement ModelWrapper in shoppingOrder proxy " + invocationHandler.getClass());
            }
            throw new IllegalArgumentException("Implement ModelWrapper in custom ShoppingOrder implementation " + shoppingOrder.getClass());
        }
        ShoppingOrderModelImpl shoppingOrderModelImpl = (ShoppingOrderModelImpl)shoppingOrder;
        ServiceContext serviceContext = ServiceContextThreadLocal.getServiceContext();
        Date now = new Date();
        if (isNew && shoppingOrder.getCreateDate() == null) {
            if (serviceContext == null) {
                shoppingOrder.setCreateDate(now);
            } else {
                shoppingOrder.setCreateDate(serviceContext.getCreateDate(now));
            }
        }
        if (!shoppingOrderModelImpl.hasSetModifiedDate()) {
            if (serviceContext == null) {
                shoppingOrder.setModifiedDate(now);
            } else {
                shoppingOrder.setModifiedDate(serviceContext.getModifiedDate(now));
            }
        }
        Session session = null;
        try {
            session = this.openSession();
            if (shoppingOrder.isNew()) {
                session.save((Object)shoppingOrder);
                shoppingOrder.setNew(false);
            } else {
                shoppingOrder = (ShoppingOrder)session.merge((Object)shoppingOrder);
            }
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        if (!ShoppingOrderModelImpl.COLUMN_BITMASK_ENABLED) {
            this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
        } else if (isNew) {
            Object[] args = new Object[]{shoppingOrderModelImpl.getGroupId()};
            this.finderCache.removeResult(this._finderPathCountByGroupId, args);
            this.finderCache.removeResult(this._finderPathWithoutPaginationFindByGroupId, args);
            args = new Object[]{shoppingOrderModelImpl.getGroupId(), shoppingOrderModelImpl.getUserId(), shoppingOrderModelImpl.getPpPaymentStatus()};
            this.finderCache.removeResult(this._finderPathCountByG_U_PPPS, args);
            this.finderCache.removeResult(this._finderPathWithoutPaginationFindByG_U_PPPS, args);
            this.finderCache.removeResult(this._finderPathCountAll, FINDER_ARGS_EMPTY);
            this.finderCache.removeResult(this._finderPathWithoutPaginationFindAll, FINDER_ARGS_EMPTY);
        } else {
            Object[] args;
            if ((shoppingOrderModelImpl.getColumnBitmask() & this._finderPathWithoutPaginationFindByGroupId.getColumnBitmask()) != 0L) {
                args = new Object[]{shoppingOrderModelImpl.getOriginalGroupId()};
                this.finderCache.removeResult(this._finderPathCountByGroupId, args);
                this.finderCache.removeResult(this._finderPathWithoutPaginationFindByGroupId, args);
                args = new Object[]{shoppingOrderModelImpl.getGroupId()};
                this.finderCache.removeResult(this._finderPathCountByGroupId, args);
                this.finderCache.removeResult(this._finderPathWithoutPaginationFindByGroupId, args);
            }
            if ((shoppingOrderModelImpl.getColumnBitmask() & this._finderPathWithoutPaginationFindByG_U_PPPS.getColumnBitmask()) != 0L) {
                args = new Object[]{shoppingOrderModelImpl.getOriginalGroupId(), shoppingOrderModelImpl.getOriginalUserId(), shoppingOrderModelImpl.getOriginalPpPaymentStatus()};
                this.finderCache.removeResult(this._finderPathCountByG_U_PPPS, args);
                this.finderCache.removeResult(this._finderPathWithoutPaginationFindByG_U_PPPS, args);
                args = new Object[]{shoppingOrderModelImpl.getGroupId(), shoppingOrderModelImpl.getUserId(), shoppingOrderModelImpl.getPpPaymentStatus()};
                this.finderCache.removeResult(this._finderPathCountByG_U_PPPS, args);
                this.finderCache.removeResult(this._finderPathWithoutPaginationFindByG_U_PPPS, args);
            }
        }
        this.entityCache.putResult(ShoppingOrderModelImpl.ENTITY_CACHE_ENABLED, ShoppingOrderImpl.class, (Serializable)Long.valueOf(shoppingOrder.getPrimaryKey()), (Serializable)shoppingOrder, false);
        this.clearUniqueFindersCache(shoppingOrderModelImpl, false);
        this.cacheUniqueFindersCache(shoppingOrderModelImpl);
        shoppingOrder.resetOriginalValues();
        return shoppingOrder;
    }

    public ShoppingOrder findByPrimaryKey(Serializable primaryKey) throws NoSuchOrderException {
        ShoppingOrder shoppingOrder = this.fetchByPrimaryKey(primaryKey);
        if (shoppingOrder == null) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey));
            }
            throw new NoSuchOrderException(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey);
        }
        return shoppingOrder;
    }

    public ShoppingOrder findByPrimaryKey(long orderId) throws NoSuchOrderException {
        return this.findByPrimaryKey(Long.valueOf(orderId));
    }

    public ShoppingOrder fetchByPrimaryKey(Serializable primaryKey) {
        Serializable serializable = this.entityCache.getResult(ShoppingOrderModelImpl.ENTITY_CACHE_ENABLED, ShoppingOrderImpl.class, primaryKey);
        if (serializable == nullModel) {
            return null;
        }
        ShoppingOrder shoppingOrder = (ShoppingOrder)serializable;
        if (shoppingOrder == null) {
            Session session = null;
            try {
                session = this.openSession();
                shoppingOrder = (ShoppingOrder)session.get(ShoppingOrderImpl.class, primaryKey);
                if (shoppingOrder != null) {
                    this.cacheResult(shoppingOrder);
                } else {
                    this.entityCache.putResult(ShoppingOrderModelImpl.ENTITY_CACHE_ENABLED, ShoppingOrderImpl.class, primaryKey, (Serializable)nullModel);
                }
            }
            catch (Exception exception) {
                this.entityCache.removeResult(ShoppingOrderModelImpl.ENTITY_CACHE_ENABLED, ShoppingOrderImpl.class, primaryKey);
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return shoppingOrder;
    }

    public ShoppingOrder fetchByPrimaryKey(long orderId) {
        return this.fetchByPrimaryKey(Long.valueOf(orderId));
    }

    public Map<Serializable, ShoppingOrder> fetchByPrimaryKeys(Set<Serializable> primaryKeys) {
        Session session;
        if (primaryKeys.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<Serializable, ShoppingOrder> map = new HashMap<Serializable, ShoppingOrder>();
        if (primaryKeys.size() == 1) {
            Iterator<Serializable> iterator = primaryKeys.iterator();
            Serializable primaryKey = iterator.next();
            ShoppingOrder shoppingOrder = this.fetchByPrimaryKey(primaryKey);
            if (shoppingOrder != null) {
                map.put(primaryKey, shoppingOrder);
            }
            return map;
        }
        HashSet<Serializable> uncachedPrimaryKeys = null;
        for (Serializable serializable : primaryKeys) {
            Serializable serializable2 = this.entityCache.getResult(ShoppingOrderModelImpl.ENTITY_CACHE_ENABLED, ShoppingOrderImpl.class, serializable);
            if (serializable2 == nullModel) continue;
            if (serializable2 == null) {
                if (uncachedPrimaryKeys == null) {
                    uncachedPrimaryKeys = new HashSet<Serializable>();
                }
                uncachedPrimaryKeys.add(serializable);
                continue;
            }
            map.put(serializable, (ShoppingOrder)serializable2);
        }
        if (uncachedPrimaryKeys == null) {
            return map;
        }
        StringBundler query = new StringBundler(uncachedPrimaryKeys.size() * 2 + 1);
        query.append(_SQL_SELECT_SHOPPINGORDER_WHERE_PKS_IN);
        for (Serializable serializable : uncachedPrimaryKeys) {
            query.append(((Long)serializable).longValue());
            query.append(",");
        }
        query.setIndex(query.index() - 1);
        query.append(")");
        String string = query.toString();
        Session session2 = null;
        try {
            session = this.openSession();
            Query q = session.createQuery(string);
            for (ShoppingOrder shoppingOrder : q.list()) {
                map.put(shoppingOrder.getPrimaryKeyObj(), shoppingOrder);
                this.cacheResult(shoppingOrder);
                uncachedPrimaryKeys.remove(shoppingOrder.getPrimaryKeyObj());
            }
            for (Serializable serializable : uncachedPrimaryKeys) {
                this.entityCache.putResult(ShoppingOrderModelImpl.ENTITY_CACHE_ENABLED, ShoppingOrderImpl.class, serializable, (Serializable)nullModel);
            }
        }
        catch (Exception exception) {
            try {
                throw this.processException(exception);
            }
            catch (Throwable throwable) {
                this.closeSession(session2);
                throw throwable;
            }
        }
        this.closeSession(session);
        return map;
    }

    public List<ShoppingOrder> findAll() {
        return this.findAll(-1, -1, null);
    }

    public List<ShoppingOrder> findAll(int start, int end) {
        return this.findAll(start, end, null);
    }

    public List<ShoppingOrder> findAll(int start, int end, OrderByComparator<ShoppingOrder> orderByComparator) {
        return this.findAll(start, end, orderByComparator, true);
    }

    public List<ShoppingOrder> findAll(int start, int end, OrderByComparator<ShoppingOrder> orderByComparator, boolean useFinderCache) {
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            if (useFinderCache) {
                finderPath = this._finderPathWithoutPaginationFindAll;
                finderArgs = FINDER_ARGS_EMPTY;
            }
        } else if (useFinderCache) {
            finderPath = this._finderPathWithPaginationFindAll;
            finderArgs = new Object[]{start, end, orderByComparator};
        }
        List list = null;
        if (useFinderCache) {
            list = (List)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this);
        }
        if (list == null) {
            StringBundler query = null;
            String sql = null;
            if (orderByComparator != null) {
                query = new StringBundler(2 + orderByComparator.getOrderByFields().length * 2);
                query.append(_SQL_SELECT_SHOPPINGORDER);
                this.appendOrderByComparator(query, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
                sql = query.toString();
            } else {
                sql = _SQL_SELECT_SHOPPINGORDER;
                sql = sql.concat(" ORDER BY shoppingOrder.createDate DESC");
            }
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(sql);
                list = QueryUtil.list((Query)q, (Dialect)this.getDialect(), (int)start, (int)end);
                this.cacheResult(list);
                if (useFinderCache) {
                    this.finderCache.putResult(finderPath, finderArgs, (Object)list);
                }
            }
            catch (Exception exception) {
                if (useFinderCache) {
                    this.finderCache.removeResult(finderPath, finderArgs);
                }
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    public void removeAll() {
        for (ShoppingOrder shoppingOrder : this.findAll()) {
            this.remove((BaseModel)shoppingOrder);
        }
    }

    public int countAll() {
        Long count = (Long)this.finderCache.getResult(this._finderPathCountAll, FINDER_ARGS_EMPTY, (BasePersistenceImpl)this);
        if (count == null) {
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(_SQL_COUNT_SHOPPINGORDER);
                count = (Long)q.uniqueResult();
                this.finderCache.putResult(this._finderPathCountAll, FINDER_ARGS_EMPTY, (Object)count);
            }
            catch (Exception exception) {
                this.finderCache.removeResult(this._finderPathCountAll, FINDER_ARGS_EMPTY);
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public Set<String> getBadColumnNames() {
        return _badColumnNames;
    }

    protected Map<String, Integer> getTableColumnsMap() {
        return ShoppingOrderModelImpl.TABLE_COLUMNS_MAP;
    }

    public void afterPropertiesSet() {
        this._finderPathWithPaginationFindAll = new FinderPath(ShoppingOrderModelImpl.ENTITY_CACHE_ENABLED, ShoppingOrderModelImpl.FINDER_CACHE_ENABLED, ShoppingOrderImpl.class, FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findAll", new String[0]);
        this._finderPathWithoutPaginationFindAll = new FinderPath(ShoppingOrderModelImpl.ENTITY_CACHE_ENABLED, ShoppingOrderModelImpl.FINDER_CACHE_ENABLED, ShoppingOrderImpl.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findAll", new String[0]);
        this._finderPathCountAll = new FinderPath(ShoppingOrderModelImpl.ENTITY_CACHE_ENABLED, ShoppingOrderModelImpl.FINDER_CACHE_ENABLED, Long.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countAll", new String[0]);
        this._finderPathWithPaginationFindByGroupId = new FinderPath(ShoppingOrderModelImpl.ENTITY_CACHE_ENABLED, ShoppingOrderModelImpl.FINDER_CACHE_ENABLED, ShoppingOrderImpl.class, FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findByGroupId", new String[]{Long.class.getName(), Integer.class.getName(), Integer.class.getName(), OrderByComparator.class.getName()});
        this._finderPathWithoutPaginationFindByGroupId = new FinderPath(ShoppingOrderModelImpl.ENTITY_CACHE_ENABLED, ShoppingOrderModelImpl.FINDER_CACHE_ENABLED, ShoppingOrderImpl.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findByGroupId", new String[]{Long.class.getName()}, 33L);
        this._finderPathCountByGroupId = new FinderPath(ShoppingOrderModelImpl.ENTITY_CACHE_ENABLED, ShoppingOrderModelImpl.FINDER_CACHE_ENABLED, Long.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByGroupId", new String[]{Long.class.getName()});
        this._finderPathFetchByNumber = new FinderPath(ShoppingOrderModelImpl.ENTITY_CACHE_ENABLED, ShoppingOrderModelImpl.FINDER_CACHE_ENABLED, ShoppingOrderImpl.class, FINDER_CLASS_NAME_ENTITY, "fetchByNumber", new String[]{String.class.getName()}, 2L);
        this._finderPathCountByNumber = new FinderPath(ShoppingOrderModelImpl.ENTITY_CACHE_ENABLED, ShoppingOrderModelImpl.FINDER_CACHE_ENABLED, Long.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByNumber", new String[]{String.class.getName()});
        this._finderPathFetchByPPTxnId = new FinderPath(ShoppingOrderModelImpl.ENTITY_CACHE_ENABLED, ShoppingOrderModelImpl.FINDER_CACHE_ENABLED, ShoppingOrderImpl.class, FINDER_CLASS_NAME_ENTITY, "fetchByPPTxnId", new String[]{String.class.getName()}, 8L);
        this._finderPathCountByPPTxnId = new FinderPath(ShoppingOrderModelImpl.ENTITY_CACHE_ENABLED, ShoppingOrderModelImpl.FINDER_CACHE_ENABLED, Long.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByPPTxnId", new String[]{String.class.getName()});
        this._finderPathWithPaginationFindByG_U_PPPS = new FinderPath(ShoppingOrderModelImpl.ENTITY_CACHE_ENABLED, ShoppingOrderModelImpl.FINDER_CACHE_ENABLED, ShoppingOrderImpl.class, FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findByG_U_PPPS", new String[]{Long.class.getName(), Long.class.getName(), String.class.getName(), Integer.class.getName(), Integer.class.getName(), OrderByComparator.class.getName()});
        this._finderPathWithoutPaginationFindByG_U_PPPS = new FinderPath(ShoppingOrderModelImpl.ENTITY_CACHE_ENABLED, ShoppingOrderModelImpl.FINDER_CACHE_ENABLED, ShoppingOrderImpl.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findByG_U_PPPS", new String[]{Long.class.getName(), Long.class.getName(), String.class.getName()}, 53L);
        this._finderPathCountByG_U_PPPS = new FinderPath(ShoppingOrderModelImpl.ENTITY_CACHE_ENABLED, ShoppingOrderModelImpl.FINDER_CACHE_ENABLED, Long.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByG_U_PPPS", new String[]{Long.class.getName(), Long.class.getName(), String.class.getName()});
    }

    public void destroy() {
        this.entityCache.removeCache(ShoppingOrderImpl.class.getName());
        this.finderCache.removeCache(FINDER_CLASS_NAME_ENTITY);
        this.finderCache.removeCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        this.finderCache.removeCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
    }
}

