/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.shopping.service.persistence.impl;

import com.liferay.portal.dao.orm.custom.sql.CustomSQLUtil;
import com.liferay.portal.kernel.dao.orm.Dialect;
import com.liferay.portal.kernel.dao.orm.Query;
import com.liferay.portal.kernel.dao.orm.QueryPos;
import com.liferay.portal.kernel.dao.orm.QueryUtil;
import com.liferay.portal.kernel.dao.orm.SQLQuery;
import com.liferay.portal.kernel.dao.orm.Session;
import com.liferay.portal.kernel.dao.orm.Type;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.security.permission.InlineSQLHelperUtil;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.shopping.model.ShoppingItem;
import com.liferay.shopping.model.impl.ShoppingItemImpl;
import com.liferay.shopping.service.persistence.ShoppingItemFinder;
import com.liferay.shopping.service.persistence.impl.ShoppingItemFinderBaseImpl;
import java.util.Iterator;
import java.util.List;

public class ShoppingItemFinderImpl
extends ShoppingItemFinderBaseImpl
implements ShoppingItemFinder {
    public static final String COUNT_BY_G_C = ShoppingItemFinder.class.getName() + ".countByG_C";

    public int countByFeatured(long groupId, long[] categoryIds) {
        Session session = null;
        try {
            Long count;
            session = this.openSession();
            StringBundler sb = new StringBundler();
            sb.append("SELECT COUNT(*) AS COUNT_VALUE FROM ShoppingItem ");
            sb.append("WHERE ShoppingItem.groupId = ? AND (");
            if (ArrayUtil.isNotEmpty((long[])categoryIds)) {
                sb.append("(");
                for (int i = 0; i < categoryIds.length; ++i) {
                    sb.append("ShoppingItem.categoryId = ? ");
                    if (i + 1 >= categoryIds.length) continue;
                    sb.append("OR ");
                }
                sb.append(") AND ");
            }
            sb.append("ShoppingItem.featured = ? AND ShoppingItem.smallImage ");
            sb.append("= ?");
            SQLQuery q = session.createSynchronizedSQLQuery(sb.toString());
            q.addScalar("COUNT_VALUE", Type.LONG);
            QueryPos qPos = QueryPos.getInstance((Query)q);
            qPos.add(groupId);
            if (ArrayUtil.isNotEmpty((long[])categoryIds)) {
                for (long categoryId : categoryIds) {
                    qPos.add(categoryId);
                }
            }
            qPos.add(true);
            qPos.add(true);
            Iterator itr = q.iterate();
            if (itr.hasNext() && (count = (Long)itr.next()) != null) {
                int n = count.intValue();
                return n;
            }
            int n = 0;
            return n;
        }
        catch (Exception e) {
            throw new SystemException((Throwable)e);
        }
        finally {
            this.closeSession(session);
        }
    }

    public int countByKeywords(long groupId, long[] categoryIds, String keywords) {
        return this.countByKeywords(groupId, categoryIds, keywords, null);
    }

    public int countByKeywords(long groupId, long[] categoryIds, String keywords, OrderByComparator<ShoppingItem> obc) {
        Session session = null;
        try {
            Long count;
            session = this.openSession();
            StringBundler sb = new StringBundler();
            sb.append("SELECT COUNT(*) AS COUNT_VALUE FROM ShoppingItem ");
            sb.append("WHERE ShoppingItem.groupId = ? AND (");
            if (ArrayUtil.isNotEmpty((long[])categoryIds)) {
                sb.append("(");
                for (int i = 0; i < categoryIds.length; ++i) {
                    sb.append("ShoppingItem.categoryId = ? ");
                    if (i + 1 >= categoryIds.length) continue;
                    sb.append("OR ");
                }
                sb.append(") AND ");
            }
            sb.append("(ShoppingItem.name LIKE ? OR ShoppingItem.description ");
            sb.append("LIKE ? OR ShoppingItem.properties LIKE ?))");
            String sql = CustomSQLUtil.replaceOrderBy((String)sb.toString(), obc);
            keywords = '%' + keywords + '%';
            SQLQuery q = session.createSynchronizedSQLQuery(sql);
            q.addScalar("COUNT_VALUE", Type.LONG);
            QueryPos qPos = QueryPos.getInstance((Query)q);
            qPos.add(groupId);
            if (ArrayUtil.isNotEmpty((long[])categoryIds)) {
                for (long categoryId : categoryIds) {
                    qPos.add(categoryId);
                }
            }
            qPos.add(keywords);
            qPos.add(keywords);
            qPos.add(keywords);
            Iterator itr = q.iterate();
            if (itr.hasNext() && (count = (Long)itr.next()) != null) {
                int n = count.intValue();
                return n;
            }
            int n = 0;
            return n;
        }
        catch (Exception e) {
            throw new SystemException((Throwable)e);
        }
        finally {
            this.closeSession(session);
        }
    }

    public int countBySale(long groupId, long[] categoryIds) {
        Session session = null;
        try {
            Long count;
            session = this.openSession();
            StringBundler sb = new StringBundler();
            sb.append("SELECT COUNT(*) AS COUNT_VALUE FROM ShoppingItem ");
            sb.append("WHERE ShoppingItem.groupId = ? AND (");
            if (ArrayUtil.isNotEmpty((long[])categoryIds)) {
                sb.append("(");
                for (int i = 0; i < categoryIds.length; ++i) {
                    sb.append("ShoppingItem.categoryId = ? ");
                    if (i + 1 >= categoryIds.length) continue;
                    sb.append("OR ");
                }
                sb.append(") AND ");
            }
            sb.append("ShoppingItem.sale = ? AND ShoppingItem.smallImage = ?");
            SQLQuery q = session.createSynchronizedSQLQuery(sb.toString());
            q.addScalar("COUNT_VALUE", Type.LONG);
            QueryPos qPos = QueryPos.getInstance((Query)q);
            qPos.add(groupId);
            if (ArrayUtil.isNotEmpty((long[])categoryIds)) {
                for (long categoryId : categoryIds) {
                    qPos.add(categoryId);
                }
            }
            qPos.add(true);
            qPos.add(true);
            Iterator itr = q.iterate();
            if (itr.hasNext() && (count = (Long)itr.next()) != null) {
                int n = count.intValue();
                return n;
            }
            int n = 0;
            return n;
        }
        catch (Exception e) {
            throw new SystemException((Throwable)e);
        }
        finally {
            this.closeSession(session);
        }
    }

    public int countByG_C(long groupId, List<Long> categoryIds) {
        return this.doCountByG_C(groupId, categoryIds, false);
    }

    public int filterCountByG_C(long groupId, List<Long> categoryIds) {
        return this.doCountByG_C(groupId, categoryIds, true);
    }

    public List<ShoppingItem> findByFeatured(long groupId, long[] categoryIds, int numOfItems) {
        int countByFeatured = this.countByFeatured(groupId, categoryIds);
        Session session = null;
        try {
            session = this.openSession();
            StringBundler sb = new StringBundler();
            sb.append("SELECT {ShoppingItem.*} FROM ShoppingItem WHERE ");
            sb.append("ShoppingItem.groupId = ? AND (");
            if (ArrayUtil.isNotEmpty((long[])categoryIds)) {
                sb.append("(");
                for (int i = 0; i < categoryIds.length; ++i) {
                    sb.append("ShoppingItem.categoryId = ? ");
                    if (i + 1 >= categoryIds.length) continue;
                    sb.append("OR ");
                }
                sb.append(") AND ");
            }
            sb.append("ShoppingItem.featured = ? AND ShoppingItem.smallImage ");
            sb.append("= ?");
            SQLQuery q = session.createSynchronizedSQLQuery(sb.toString());
            q.addEntity("ShoppingItem", ShoppingItemImpl.class);
            QueryPos qPos = QueryPos.getInstance((Query)q);
            qPos.add(groupId);
            if (ArrayUtil.isNotEmpty((long[])categoryIds)) {
                for (long categoryId : categoryIds) {
                    qPos.add(categoryId);
                }
            }
            qPos.add(true);
            qPos.add(true);
            List list = QueryUtil.randomList((Query)q, (Dialect)this.getDialect(), (int)countByFeatured, (int)numOfItems);
            return list;
        }
        catch (Exception e) {
            throw new SystemException((Throwable)e);
        }
        finally {
            this.closeSession(session);
        }
    }

    public List<ShoppingItem> findByKeywords(long groupId, long[] categoryIds, String keywords, int start, int end) {
        return this.findByKeywords(groupId, categoryIds, keywords, start, end, null);
    }

    public List<ShoppingItem> findByKeywords(long groupId, long[] categoryIds, String keywords, int start, int end, OrderByComparator<ShoppingItem> obc) {
        Session session = null;
        try {
            session = this.openSession();
            StringBundler sb = new StringBundler();
            sb.append("SELECT {ShoppingItem.*} FROM ShoppingItem WHERE ");
            sb.append("ShoppingItem.groupId = ? AND (");
            if (ArrayUtil.isNotEmpty((long[])categoryIds)) {
                sb.append("(");
                for (int i = 0; i < categoryIds.length; ++i) {
                    sb.append("ShoppingItem.categoryId = ? ");
                    if (i + 1 >= categoryIds.length) continue;
                    sb.append("OR ");
                }
                sb.append(") AND ");
            }
            sb.append("(ShoppingItem.name LIKE ? OR ShoppingItem.description ");
            sb.append("LIKE ? OR ShoppingItem.properties LIKE ?))");
            String sql = CustomSQLUtil.replaceOrderBy((String)sb.toString(), obc);
            keywords = '%' + keywords + '%';
            SQLQuery q = session.createSynchronizedSQLQuery(sql);
            q.addEntity("ShoppingItem", ShoppingItemImpl.class);
            QueryPos qPos = QueryPos.getInstance((Query)q);
            qPos.add(groupId);
            if (ArrayUtil.isNotEmpty((long[])categoryIds)) {
                for (long categoryId : categoryIds) {
                    qPos.add(categoryId);
                }
            }
            qPos.add(keywords);
            qPos.add(keywords);
            qPos.add(keywords);
            List list = QueryUtil.list((Query)q, (Dialect)this.getDialect(), (int)start, (int)end);
            return list;
        }
        catch (Exception e) {
            throw new SystemException((Throwable)e);
        }
        finally {
            this.closeSession(session);
        }
    }

    public List<ShoppingItem> findBySale(long groupId, long[] categoryIds, int numOfItems) {
        int countBySale = this.countBySale(groupId, categoryIds);
        Session session = null;
        try {
            session = this.openSession();
            StringBundler sb = new StringBundler();
            sb.append("SELECT {ShoppingItem.*} FROM ShoppingItem WHERE ");
            sb.append("ShoppingItem.groupId = ? AND (");
            if (ArrayUtil.isNotEmpty((long[])categoryIds)) {
                sb.append("(");
                for (int i = 0; i < categoryIds.length; ++i) {
                    sb.append("ShoppingItem.categoryId = ? ");
                    if (i + 1 >= categoryIds.length) continue;
                    sb.append("OR ");
                }
                sb.append(") AND ");
            }
            sb.append("ShoppingItem.sale = ? AND ShoppingItem.smallImage = ?");
            SQLQuery q = session.createSynchronizedSQLQuery(sb.toString());
            q.addEntity("ShoppingItem", ShoppingItemImpl.class);
            QueryPos qPos = QueryPos.getInstance((Query)q);
            qPos.add(groupId);
            if (ArrayUtil.isNotEmpty((long[])categoryIds)) {
                for (long categoryId : categoryIds) {
                    qPos.add(categoryId);
                }
            }
            qPos.add(true);
            qPos.add(true);
            List list = QueryUtil.randomList((Query)q, (Dialect)this.getDialect(), (int)countBySale, (int)numOfItems);
            return list;
        }
        catch (Exception e) {
            throw new SystemException((Throwable)e);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected int doCountByG_C(long groupId, List<Long> categoryIds, boolean inlineSQLHelper) {
        Session session = null;
        try {
            Long count;
            session = this.openSession();
            String sql = CustomSQLUtil.get(((Object)((Object)this)).getClass(), (String)COUNT_BY_G_C);
            if (inlineSQLHelper) {
                sql = InlineSQLHelperUtil.replacePermissionCheck((String)sql, (String)ShoppingItem.class.getName(), (String)"ShoppingItem.itemId", (long)groupId);
            }
            sql = StringUtil.replace((String)sql, (String)"[$CATEGORY_ID$]", (String)this.getCategoryIds(categoryIds));
            SQLQuery q = session.createSynchronizedSQLQuery(sql);
            q.addScalar("COUNT_VALUE", Type.LONG);
            QueryPos qPos = QueryPos.getInstance((Query)q);
            qPos.add(groupId);
            for (Long categoryId : categoryIds) {
                qPos.add(categoryId);
            }
            Iterator itr = q.iterate();
            if (itr.hasNext() && (count = (Long)itr.next()) != null) {
                int n = count.intValue();
                return n;
            }
            int n = 0;
            return n;
        }
        catch (Exception e) {
            throw new SystemException((Throwable)e);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected String getCategoryIds(List<Long> categoryIds) {
        if (categoryIds.isEmpty()) {
            return "";
        }
        StringBundler sb = new StringBundler(categoryIds.size() * 2 - 1);
        for (int i = 0; i < categoryIds.size(); ++i) {
            sb.append("categoryId = ? ");
            if (i + 1 == categoryIds.size()) continue;
            sb.append("OR ");
        }
        return sb.toString();
    }
}

