/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.shopping.service.impl;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.shopping.model.ShoppingCoupon;
import com.liferay.shopping.service.base.ShoppingCouponServiceBaseImpl;
import com.liferay.shopping.service.permission.ShoppingPermission;
import java.util.List;

public class ShoppingCouponServiceImpl
extends ShoppingCouponServiceBaseImpl {
    public ShoppingCoupon addCoupon(String code, boolean autoCode, String name, String description, int startDateMonth, int startDateDay, int startDateYear, int startDateHour, int startDateMinute, int endDateMonth, int endDateDay, int endDateYear, int endDateHour, int endDateMinute, boolean neverExpire, boolean active, String limitCategories, String limitSkus, double minOrder, double discount, String discountType, ServiceContext serviceContext) throws PortalException {
        ShoppingPermission.check(this.getPermissionChecker(), serviceContext.getScopeGroupId(), "MANAGE_COUPONS");
        return this.shoppingCouponLocalService.addCoupon(this.getUserId(), code, autoCode, name, description, startDateMonth, startDateDay, startDateYear, startDateHour, startDateMinute, endDateMonth, endDateDay, endDateYear, endDateHour, endDateMinute, neverExpire, active, limitCategories, limitSkus, minOrder, discount, discountType, serviceContext);
    }

    public void deleteCoupon(long groupId, long couponId) throws PortalException {
        ShoppingPermission.check(this.getPermissionChecker(), groupId, "MANAGE_COUPONS");
        this.shoppingCouponLocalService.deleteCoupon(couponId);
    }

    public ShoppingCoupon getCoupon(long groupId, long couponId) throws PortalException {
        ShoppingPermission.check(this.getPermissionChecker(), groupId, "MANAGE_COUPONS");
        return this.shoppingCouponLocalService.getCoupon(couponId);
    }

    public List<ShoppingCoupon> search(long groupId, long companyId, String code, boolean active, String discountType, boolean andOperator, int start, int end) throws PortalException {
        ShoppingPermission.check(this.getPermissionChecker(), groupId, "MANAGE_COUPONS");
        return this.shoppingCouponLocalService.search(groupId, companyId, code, active, discountType, andOperator, start, end);
    }

    public ShoppingCoupon updateCoupon(long couponId, String name, String description, int startDateMonth, int startDateDay, int startDateYear, int startDateHour, int startDateMinute, int endDateMonth, int endDateDay, int endDateYear, int endDateHour, int endDateMinute, boolean neverExpire, boolean active, String limitCategories, String limitSkus, double minOrder, double discount, String discountType, ServiceContext serviceContext) throws PortalException {
        ShoppingPermission.check(this.getPermissionChecker(), serviceContext.getScopeGroupId(), "MANAGE_COUPONS");
        return this.shoppingCouponLocalService.updateCoupon(this.getUserId(), couponId, name, description, startDateMonth, startDateDay, startDateYear, startDateHour, startDateMinute, endDateMonth, endDateDay, endDateYear, endDateHour, endDateMinute, neverExpire, active, limitCategories, limitSkus, minOrder, discount, discountType, serviceContext);
    }
}

