/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.shopping.service.http;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.security.auth.HttpPrincipal;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.http.TunnelUtil;
import com.liferay.portal.kernel.util.MethodHandler;
import com.liferay.portal.kernel.util.MethodKey;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.shopping.model.ShoppingCategory;
import com.liferay.shopping.service.ShoppingCategoryServiceUtil;
import java.util.List;

public class ShoppingCategoryServiceHttp {
    private static Log _log = LogFactoryUtil.getLog(ShoppingCategoryServiceHttp.class);
    private static final Class<?>[] _addCategoryParameterTypes0 = new Class[]{Long.TYPE, String.class, String.class, ServiceContext.class};
    private static final Class<?>[] _deleteCategoryParameterTypes1 = new Class[]{Long.TYPE};
    private static final Class<?>[] _getCategoriesParameterTypes2 = new Class[]{Long.TYPE};
    private static final Class<?>[] _getCategoriesParameterTypes3 = new Class[]{Long.TYPE, Long.TYPE, Integer.TYPE, Integer.TYPE};
    private static final Class<?>[] _getCategoriesAndItemsParameterTypes4 = new Class[]{Long.TYPE, Long.TYPE, Integer.TYPE, Integer.TYPE, OrderByComparator.class};
    private static final Class<?>[] _getCategoriesAndItemsCountParameterTypes5 = new Class[]{Long.TYPE, Long.TYPE};
    private static final Class<?>[] _getCategoriesCountParameterTypes6 = new Class[]{Long.TYPE, Long.TYPE};
    private static final Class<?>[] _getCategoryParameterTypes7 = new Class[]{Long.TYPE};
    private static final Class<?>[] _getSubcategoryIdsParameterTypes8 = new Class[]{List.class, Long.TYPE, Long.TYPE};
    private static final Class<?>[] _updateCategoryParameterTypes9 = new Class[]{Long.TYPE, Long.TYPE, String.class, String.class, Boolean.TYPE, ServiceContext.class};

    public static ShoppingCategory addCategory(HttpPrincipal httpPrincipal, long parentCategoryId, String name, String description, ServiceContext serviceContext) throws PortalException {
        try {
            MethodKey methodKey = new MethodKey(ShoppingCategoryServiceUtil.class, "addCategory", (Class[])_addCategoryParameterTypes0);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{parentCategoryId, name, description, serviceContext});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke((HttpPrincipal)httpPrincipal, (MethodHandler)methodHandler);
            }
            catch (Exception exception) {
                if (exception instanceof PortalException) {
                    throw (PortalException)((Object)exception);
                }
                throw new SystemException((Throwable)exception);
            }
            return (ShoppingCategory)returnObj;
        }
        catch (SystemException systemException) {
            _log.error((Object)systemException, (Throwable)systemException);
            throw systemException;
        }
    }

    public static void deleteCategory(HttpPrincipal httpPrincipal, long categoryId) throws PortalException {
        try {
            MethodKey methodKey = new MethodKey(ShoppingCategoryServiceUtil.class, "deleteCategory", (Class[])_deleteCategoryParameterTypes1);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{categoryId});
            try {
                TunnelUtil.invoke((HttpPrincipal)httpPrincipal, (MethodHandler)methodHandler);
            }
            catch (Exception exception) {
                if (exception instanceof PortalException) {
                    throw (PortalException)((Object)exception);
                }
                throw new SystemException((Throwable)exception);
            }
        }
        catch (SystemException systemException) {
            _log.error((Object)systemException, (Throwable)systemException);
            throw systemException;
        }
    }

    public static List<ShoppingCategory> getCategories(HttpPrincipal httpPrincipal, long groupId) {
        try {
            MethodKey methodKey = new MethodKey(ShoppingCategoryServiceUtil.class, "getCategories", (Class[])_getCategoriesParameterTypes2);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{groupId});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke((HttpPrincipal)httpPrincipal, (MethodHandler)methodHandler);
            }
            catch (Exception exception) {
                throw new SystemException((Throwable)exception);
            }
            return (List)returnObj;
        }
        catch (SystemException systemException) {
            _log.error((Object)systemException, (Throwable)systemException);
            throw systemException;
        }
    }

    public static List<ShoppingCategory> getCategories(HttpPrincipal httpPrincipal, long groupId, long parentCategoryId, int start, int end) {
        try {
            MethodKey methodKey = new MethodKey(ShoppingCategoryServiceUtil.class, "getCategories", (Class[])_getCategoriesParameterTypes3);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{groupId, parentCategoryId, start, end});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke((HttpPrincipal)httpPrincipal, (MethodHandler)methodHandler);
            }
            catch (Exception exception) {
                throw new SystemException((Throwable)exception);
            }
            return (List)returnObj;
        }
        catch (SystemException systemException) {
            _log.error((Object)systemException, (Throwable)systemException);
            throw systemException;
        }
    }

    public static List<Object> getCategoriesAndItems(HttpPrincipal httpPrincipal, long groupId, long categoryId, int start, int end, OrderByComparator<?> obc) {
        try {
            MethodKey methodKey = new MethodKey(ShoppingCategoryServiceUtil.class, "getCategoriesAndItems", (Class[])_getCategoriesAndItemsParameterTypes4);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{groupId, categoryId, start, end, obc});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke((HttpPrincipal)httpPrincipal, (MethodHandler)methodHandler);
            }
            catch (Exception exception) {
                throw new SystemException((Throwable)exception);
            }
            return (List)returnObj;
        }
        catch (SystemException systemException) {
            _log.error((Object)systemException, (Throwable)systemException);
            throw systemException;
        }
    }

    public static int getCategoriesAndItemsCount(HttpPrincipal httpPrincipal, long groupId, long categoryId) {
        try {
            MethodKey methodKey = new MethodKey(ShoppingCategoryServiceUtil.class, "getCategoriesAndItemsCount", (Class[])_getCategoriesAndItemsCountParameterTypes5);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{groupId, categoryId});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke((HttpPrincipal)httpPrincipal, (MethodHandler)methodHandler);
            }
            catch (Exception exception) {
                throw new SystemException((Throwable)exception);
            }
            return (Integer)returnObj;
        }
        catch (SystemException systemException) {
            _log.error((Object)systemException, (Throwable)systemException);
            throw systemException;
        }
    }

    public static int getCategoriesCount(HttpPrincipal httpPrincipal, long groupId, long parentCategoryId) {
        try {
            MethodKey methodKey = new MethodKey(ShoppingCategoryServiceUtil.class, "getCategoriesCount", (Class[])_getCategoriesCountParameterTypes6);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{groupId, parentCategoryId});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke((HttpPrincipal)httpPrincipal, (MethodHandler)methodHandler);
            }
            catch (Exception exception) {
                throw new SystemException((Throwable)exception);
            }
            return (Integer)returnObj;
        }
        catch (SystemException systemException) {
            _log.error((Object)systemException, (Throwable)systemException);
            throw systemException;
        }
    }

    public static ShoppingCategory getCategory(HttpPrincipal httpPrincipal, long categoryId) throws PortalException {
        try {
            MethodKey methodKey = new MethodKey(ShoppingCategoryServiceUtil.class, "getCategory", (Class[])_getCategoryParameterTypes7);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{categoryId});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke((HttpPrincipal)httpPrincipal, (MethodHandler)methodHandler);
            }
            catch (Exception exception) {
                if (exception instanceof PortalException) {
                    throw (PortalException)((Object)exception);
                }
                throw new SystemException((Throwable)exception);
            }
            return (ShoppingCategory)returnObj;
        }
        catch (SystemException systemException) {
            _log.error((Object)systemException, (Throwable)systemException);
            throw systemException;
        }
    }

    public static void getSubcategoryIds(HttpPrincipal httpPrincipal, List<Long> categoryIds, long groupId, long categoryId) {
        try {
            MethodKey methodKey = new MethodKey(ShoppingCategoryServiceUtil.class, "getSubcategoryIds", (Class[])_getSubcategoryIdsParameterTypes8);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{categoryIds, groupId, categoryId});
            try {
                TunnelUtil.invoke((HttpPrincipal)httpPrincipal, (MethodHandler)methodHandler);
            }
            catch (Exception exception) {
                throw new SystemException((Throwable)exception);
            }
        }
        catch (SystemException systemException) {
            _log.error((Object)systemException, (Throwable)systemException);
            throw systemException;
        }
    }

    public static ShoppingCategory updateCategory(HttpPrincipal httpPrincipal, long categoryId, long parentCategoryId, String name, String description, boolean mergeWithParentCategory, ServiceContext serviceContext) throws PortalException {
        try {
            MethodKey methodKey = new MethodKey(ShoppingCategoryServiceUtil.class, "updateCategory", (Class[])_updateCategoryParameterTypes9);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{categoryId, parentCategoryId, name, description, mergeWithParentCategory, serviceContext});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke((HttpPrincipal)httpPrincipal, (MethodHandler)methodHandler);
            }
            catch (Exception exception) {
                if (exception instanceof PortalException) {
                    throw (PortalException)((Object)exception);
                }
                throw new SystemException((Throwable)exception);
            }
            return (ShoppingCategory)returnObj;
        }
        catch (SystemException systemException) {
            _log.error((Object)systemException, (Throwable)systemException);
            throw systemException;
        }
    }
}

