/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.sharing.notifications.internal.service;

import com.liferay.petra.io.unsync.UnsyncStringWriter;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.portlet.PortletProvider;
import com.liferay.portal.kernel.portlet.PortletProviderUtil;
import com.liferay.portal.kernel.portlet.url.builder.PortletURLBuilder;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ServiceWrapper;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.template.Template;
import com.liferay.portal.kernel.template.TemplateManagerUtil;
import com.liferay.portal.kernel.template.TemplateResource;
import com.liferay.portal.kernel.template.URLTemplateResource;
import com.liferay.portal.kernel.util.DateFormatFactoryUtil;
import com.liferay.portal.kernel.util.HtmlUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.PrefsPropsUtil;
import com.liferay.portal.kernel.util.ResourceBundleUtil;
import com.liferay.sharing.interpreter.SharingEntryInterpreter;
import com.liferay.sharing.interpreter.SharingEntryInterpreterProvider;
import com.liferay.sharing.model.SharingEntry;
import com.liferay.sharing.notifications.internal.util.SharingNotificationSubcriptionSender;
import com.liferay.sharing.security.permission.SharingEntryAction;
import com.liferay.sharing.service.SharingEntryLocalServiceWrapper;
import jakarta.portlet.PortletRequest;
import jakarta.portlet.PortletURL;
import java.io.Writer;
import java.text.DateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={ServiceWrapper.class})
public class NotificationsSharingEntryLocalServiceWrapper
extends SharingEntryLocalServiceWrapper {
    private static final Log _log = LogFactoryUtil.getLog(NotificationsSharingEntryLocalServiceWrapper.class);
    @Reference
    private SharingEntryInterpreterProvider _sharingEntryInterpreterProvider;
    @Reference
    private UserLocalService _userLocalService;

    public SharingEntry addSharingEntry(String externalReferenceCode, long fromUserId, long userGroupId, long toUserId, long classNameId, long classPK, long groupId, boolean shareable, Collection<SharingEntryAction> sharingEntryActions, Date expirationDate, ServiceContext serviceContext) throws PortalException {
        SharingEntry sharingEntry = super.addSharingEntry(externalReferenceCode, fromUserId, userGroupId, toUserId, classNameId, classPK, groupId, shareable, sharingEntryActions, expirationDate, serviceContext);
        this._sendNotificationEvent(sharingEntry, 0, serviceContext);
        return sharingEntry;
    }

    public SharingEntry updateSharingEntry(long sharingEntryId, Collection<SharingEntryAction> sharingEntryActions, boolean shareable, Date expirationDate, ServiceContext serviceContext) throws PortalException {
        SharingEntry sharingEntry = super.updateSharingEntry(sharingEntryId, sharingEntryActions, shareable, expirationDate, serviceContext);
        this._sendNotificationEvent(sharingEntry, 1, serviceContext);
        return sharingEntry;
    }

    public SharingEntry updateSharingEntry(long userId, long sharingEntryId, Collection<SharingEntryAction> sharingEntryActions, boolean shareable, Date expirationDate, ServiceContext serviceContext) throws PortalException {
        SharingEntry sharingEntry = super.updateSharingEntry(userId, sharingEntryId, sharingEntryActions, shareable, expirationDate, serviceContext);
        this._sendNotificationEvent(sharingEntry, 1, serviceContext);
        return sharingEntry;
    }

    private String _getActionName(SharingEntry sharingEntry, ResourceBundle resourceBundle) {
        if (sharingEntry.hasSharingPermission(SharingEntryAction.UPDATE)) {
            return ResourceBundleUtil.getString((ResourceBundle)resourceBundle, (String)"updating");
        }
        if (sharingEntry.hasSharingPermission(SharingEntryAction.ADD_DISCUSSION)) {
            return ResourceBundleUtil.getString((ResourceBundle)resourceBundle, (String)"commenting");
        }
        if (sharingEntry.hasSharingPermission(SharingEntryAction.VIEW)) {
            return ResourceBundleUtil.getString((ResourceBundle)resourceBundle, (String)"viewing");
        }
        return ResourceBundleUtil.getString((ResourceBundle)resourceBundle, (String)"nothing");
    }

    private String _getNotificationEmailBody(SharingEntry sharingEntry, PortletRequest portletRequest) throws Exception {
        Class<?> clazz = ((Object)((Object)this)).getClass();
        String templateId = "/com/liferay/sharing/notifications/dependencies/sharing_entry_added_email_body.ftl";
        URLTemplateResource templateResource = new URLTemplateResource(templateId, clazz.getResource(templateId));
        Template template = TemplateManagerUtil.getTemplate((String)"ftl", (TemplateResource)templateResource, (boolean)false);
        User toUser = this._userLocalService.fetchUser(sharingEntry.getToUserId());
        Locale locale = LocaleUtil.getDefault();
        if (toUser != null) {
            locale = toUser.getLocale();
        }
        ResourceBundle resourceBundle = ResourceBundleUtil.getBundle((Locale)locale, ((Object)((Object)this)).getClass());
        String emailActionTitle = "";
        SharingEntryInterpreter sharingEntryInterpreter = this._getSharingEntryInterpreter(sharingEntry);
        emailActionTitle = sharingEntryInterpreter != null ? ResourceBundleUtil.getString((ResourceBundle)resourceBundle, (String)"view-x", (Object[])new Object[]{sharingEntryInterpreter.getAssetTypeTitle(sharingEntry, resourceBundle.getLocale())}) : ResourceBundleUtil.getString((ResourceBundle)resourceBundle, (String)"view");
        template.put((Object)"actionTitle", (Object)emailActionTitle);
        template.put((Object)"content", (Object)this._getNotificationMessage(sharingEntry, resourceBundle.getLocale(), portletRequest));
        if (portletRequest != null) {
            template.put((Object)"sharingEntryURL", (Object)this._getNotificationURL(sharingEntry, portletRequest));
        }
        UnsyncStringWriter unsyncStringWriter = new UnsyncStringWriter();
        template.processTemplate((Writer)unsyncStringWriter);
        return unsyncStringWriter.toString();
    }

    private String _getNotificationMessage(SharingEntry sharingEntry, Locale locale, PortletRequest portletRequest) throws Exception {
        String languageKey = "x-has-shared-x-with-you-for-x";
        if (sharingEntry.getExpirationDate() != null) {
            languageKey = "x-has-shared-x-with-you-for-x-until-x";
        }
        ResourceBundle resourceBundle = ResourceBundleUtil.getBundle((Locale)locale, ((Object)((Object)this)).getClass());
        User user = this._userLocalService.fetchUser(sharingEntry.getUserId());
        String fromUserName = "";
        fromUserName = user != null ? HtmlUtil.escape((String)user.getFullName()) : ResourceBundleUtil.getString((ResourceBundle)resourceBundle, (String)"someone");
        String expirationDateString = "";
        if (sharingEntry.getExpirationDate() != null) {
            DateFormat expirationDateFormat = DateFormatFactoryUtil.getDate((Locale)locale);
            expirationDateString = expirationDateFormat.format((Object)sharingEntry.getExpirationDate());
        }
        return ResourceBundleUtil.getString((ResourceBundle)resourceBundle, (String)languageKey, (Object[])new Object[]{fromUserName, this._getSharingEntryObjectTitle(sharingEntry, resourceBundle, portletRequest), this._getActionName(sharingEntry, resourceBundle), expirationDateString});
    }

    private String _getNotificationURL(SharingEntry sharingEntry, PortletRequest portletRequest) throws Exception {
        if (portletRequest != null) {
            return PortletURLBuilder.create((PortletURL)PortletProviderUtil.getPortletURL((PortletRequest)portletRequest, (String)SharingEntry.class.getName(), (PortletProvider.Action)PortletProvider.Action.PREVIEW)).setParameter("classNameId", (Object)sharingEntry.getClassNameId()).setParameter("classPK", (Object)sharingEntry.getClassPK()).setParameter("sharingEntryId", (Object)sharingEntry.getSharingEntryId()).buildString();
        }
        return null;
    }

    private SharingEntryInterpreter _getSharingEntryInterpreter(SharingEntry sharingEntry) {
        return this._sharingEntryInterpreterProvider.getSharingEntryInterpreter(sharingEntry);
    }

    private String _getSharingEntryObjectTitle(SharingEntry sharingEntry, ResourceBundle resourceBundle, PortletRequest portletRequest) throws Exception {
        SharingEntryInterpreter sharingEntryInterpreter = this._getSharingEntryInterpreter(sharingEntry);
        String title = "";
        title = sharingEntryInterpreter != null ? sharingEntryInterpreter.getTitle(sharingEntry, resourceBundle.getLocale()) : ResourceBundleUtil.getString((ResourceBundle)resourceBundle, (String)"something");
        if (portletRequest != null) {
            return StringBundler.concat((String[])new String[]{"<a href=\"", this._getNotificationURL(sharingEntry, portletRequest), "\" style=\"color: #0b5fff; text-decoration: none;\">", HtmlUtil.escape((String)title), "</a>"});
        }
        return title;
    }

    private void _sendNotificationEvent(SharingEntry sharingEntry, int notificationType, ServiceContext serviceContext) {
        try {
            if (sharingEntry.getToUserId() > 0L) {
                this._sendNotificationEvent(sharingEntry, notificationType, serviceContext, this._userLocalService.getUser(sharingEntry.getToUserId()));
                return;
            }
            List userGroupUsers = this._userLocalService.getUserGroupUsers(sharingEntry.getToUserGroupId());
            for (User user : userGroupUsers) {
                this._sendNotificationEvent(sharingEntry, notificationType, serviceContext, user);
            }
        }
        catch (Exception exception) {
            _log.error((Object)("Unable to send notification for sharing entry: " + sharingEntry.getSharingEntryId()), (Throwable)exception);
        }
    }

    private void _sendNotificationEvent(SharingEntry sharingEntry, int notificationType, ServiceContext serviceContext, User user) throws Exception {
        SharingNotificationSubcriptionSender sharingNotificationSubcriptionSender = new SharingNotificationSubcriptionSender();
        sharingNotificationSubcriptionSender.setSubject(this._getNotificationMessage(sharingEntry, user.getLocale(), null));
        String entryURL = this._getNotificationURL(sharingEntry, (PortletRequest)serviceContext.getLiferayPortletRequest());
        sharingNotificationSubcriptionSender.setBody(this._getNotificationEmailBody(sharingEntry, (PortletRequest)serviceContext.getLiferayPortletRequest()));
        sharingNotificationSubcriptionSender.setClassName(sharingEntry.getModelClassName());
        sharingNotificationSubcriptionSender.setClassPK(sharingEntry.getSharingEntryId());
        sharingNotificationSubcriptionSender.setCurrentUserId(serviceContext.getUserId());
        sharingNotificationSubcriptionSender.setEntryURL(entryURL);
        String fromName = PrefsPropsUtil.getString((long)user.getCompanyId(), (String)"admin.email.from.name");
        String fromAddress = PrefsPropsUtil.getString((long)user.getCompanyId(), (String)"admin.email.from.address");
        sharingNotificationSubcriptionSender.setFrom(fromAddress, fromName);
        sharingNotificationSubcriptionSender.setHtmlFormat(true);
        sharingNotificationSubcriptionSender.setMailId("sharing_entry", new Object[]{sharingEntry.getSharingEntryId()});
        sharingNotificationSubcriptionSender.setNotificationType(notificationType);
        sharingNotificationSubcriptionSender.setPortletId("com_liferay_sharing_web_portlet_SharingPortlet");
        sharingNotificationSubcriptionSender.setScopeGroupId(sharingEntry.getGroupId());
        sharingNotificationSubcriptionSender.setServiceContext(serviceContext);
        sharingNotificationSubcriptionSender.addRuntimeSubscribers(user.getEmailAddress(), user.getFullName());
        sharingNotificationSubcriptionSender.flushNotificationsAsync();
    }
}

