/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.sharing.document.library.internal.security.permission;

import com.liferay.document.library.kernel.model.DLFileEntry;
import com.liferay.document.library.kernel.model.DLFileEntryConstants;
import com.liferay.document.library.kernel.service.DLFileEntryLocalService;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.service.ClassNameLocalService;
import com.liferay.sharing.model.SharingEntry;
import com.liferay.sharing.service.SharingEntryLocalService;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={SharingPermissionHelper.class})
public class SharingPermissionHelper {
    @Reference
    private ClassNameLocalService _classNameLocalService;
    @Reference
    private DLFileEntryLocalService _dlFileEntryLocalService;
    @Reference
    private SharingEntryLocalService _sharingEntryLocalService;

    public boolean isShareable(PermissionChecker permissionChecker, long fileEntryId) {
        DLFileEntry dlFileEntry = this._dlFileEntryLocalService.fetchDLFileEntry(fileEntryId);
        if (dlFileEntry == null) {
            return false;
        }
        if (permissionChecker.isOmniadmin() || permissionChecker.isCompanyAdmin() || permissionChecker.isGroupAdmin(dlFileEntry.getGroupId()) || permissionChecker.hasOwnerPermission(dlFileEntry.getCompanyId(), DLFileEntryConstants.getClassName(), fileEntryId, dlFileEntry.getUserId(), "VIEW")) {
            return true;
        }
        SharingEntry sharingEntry = this._sharingEntryLocalService.fetchSharingEntry(permissionChecker.getUserId(), this._classNameLocalService.getClassNameId(DLFileEntryConstants.getClassName()), fileEntryId);
        return sharingEntry != null && sharingEntry.isShareable();
    }
}

