/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.sharing.document.library.internal.security.permission.resource;

import com.liferay.document.library.kernel.model.DLFileEntry;
import com.liferay.document.library.kernel.model.DLFileEntryModel;
import com.liferay.document.library.kernel.service.DLFileEntryLocalService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.ClassedModel;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermissionFactory;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermissionLogic;
import com.liferay.portal.kernel.security.permission.resource.PortletResourcePermission;
import com.liferay.portal.kernel.service.ClassNameLocalService;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.util.HashMapDictionary;
import com.liferay.sharing.configuration.SharingConfiguration;
import com.liferay.sharing.configuration.SharingConfigurationFactory;
import com.liferay.sharing.security.permission.SharingEntryAction;
import com.liferay.sharing.service.SharingEntryLocalService;
import java.util.Dictionary;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={})
public class SharingEntryDLFileEntryModelResourcePermissionRegistrar {
    public static final String COMPONENT_NAME = "com.liferay.sharing.document.library.internal.security.permission.resource.SharingEntryDLFileEntryModelResourcePermission";
    @Reference
    private ClassNameLocalService _classNameLocalService;
    @Reference
    private DLFileEntryLocalService _dlFileEntryLocalService;
    @Reference(target="(&(model.class.name=com.liferay.document.library.kernel.model.DLFileEntry)(!(component.name=com.liferay.sharing.document.library.internal.security.permission.resource.SharingEntryDLFileEntryModelResourcePermission)))")
    private ModelResourcePermission<DLFileEntry> _dlFileEntryModelResourcePermission;
    @Reference
    private GroupLocalService _groupLocalService;
    @Reference(target="(resource.name=com.liferay.document.library)")
    private PortletResourcePermission _portletResourcePermission;
    private ServiceRegistration<ModelResourcePermission> _serviceRegistration;
    @Reference
    private SharingConfigurationFactory _sharingConfigurationFactory;
    @Reference
    private SharingEntryLocalService _sharingEntryLocalService;

    @Activate
    public void activate(BundleContext bundleContext) {
        HashMapDictionary properties = new HashMapDictionary();
        properties.put("component.name", COMPONENT_NAME);
        properties.put("model.class.name", DLFileEntry.class.getName());
        properties.put("service.ranking", 100);
        this._serviceRegistration = bundleContext.registerService(ModelResourcePermission.class, (Object)ModelResourcePermissionFactory.create(DLFileEntry.class, DLFileEntryModel::getFileEntryId, arg_0 -> ((DLFileEntryLocalService)this._dlFileEntryLocalService).getDLFileEntry(arg_0), (PortletResourcePermission)this._portletResourcePermission, (modelResourcePermission, consumer) -> consumer.accept(new SharingDLFileEntryModelPermissionLogic(this._dlFileEntryModelResourcePermission))), (Dictionary)properties);
    }

    @Deactivate
    public void deactivate() {
        this._serviceRegistration.unregister();
    }

    private class SharingDLFileEntryModelPermissionLogic
    implements ModelResourcePermissionLogic<DLFileEntry> {
        private final ModelResourcePermission<DLFileEntry> _dlFileEntryModelResourcePermission;

        public Boolean contains(PermissionChecker permissionChecker, String name, DLFileEntry dlFileEntry, String actionId) throws PortalException {
            if (this._dlFileEntryModelResourcePermission.contains(permissionChecker, (ClassedModel)dlFileEntry, actionId)) {
                return true;
            }
            SharingConfiguration sharingConfiguration = SharingEntryDLFileEntryModelResourcePermissionRegistrar.this._sharingConfigurationFactory.getGroupSharingConfiguration(SharingEntryDLFileEntryModelResourcePermissionRegistrar.this._groupLocalService.getGroup(dlFileEntry.getGroupId()));
            if (!sharingConfiguration.isEnabled()) {
                return false;
            }
            if (SharingEntryAction.isSupportedActionId((String)actionId)) {
                SharingEntryAction sharingEntryAction = SharingEntryAction.parseFromActionId((String)actionId);
                long classNameId = SharingEntryDLFileEntryModelResourcePermissionRegistrar.this._classNameLocalService.getClassNameId(name);
                if (SharingEntryDLFileEntryModelResourcePermissionRegistrar.this._sharingEntryLocalService.hasSharingPermission(permissionChecker.getUserId(), classNameId, dlFileEntry.getFileEntryId(), sharingEntryAction)) {
                    return true;
                }
            }
            return false;
        }

        private SharingDLFileEntryModelPermissionLogic(ModelResourcePermission<DLFileEntry> dlFileEntryModelResourcePermission) {
            this._dlFileEntryModelResourcePermission = dlFileEntryModelResourcePermission;
        }
    }
}

