/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.sharepoint.soap.repository.connector.operation;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.sharepoint.soap.repository.connector.SharepointException;
import com.liferay.sharepoint.soap.repository.connector.SharepointObject;
import com.liferay.sharepoint.soap.repository.connector.SharepointVersion;
import com.liferay.sharepoint.soap.repository.connector.operation.BaseOperation;
import com.liferay.sharepoint.soap.repository.connector.operation.URLUtil;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.auth.AuthScheme;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.AuthCache;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.impl.auth.BasicScheme;
import org.apache.http.impl.client.BasicAuthCache;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.protocol.HttpContext;

public final class GetInputStreamOperation
extends BaseOperation {
    public InputStream execute(SharepointObject sharepointObject) throws SharepointException {
        return this._execute(sharepointObject.getURL());
    }

    public InputStream execute(SharepointVersion sharepointVersion) throws SharepointException {
        return this._execute(sharepointVersion.getURL());
    }

    private InputStream _execute(URL url) throws SharepointException {
        url = URLUtil.escapeURL(url);
        HttpGet httpGet = new HttpGet(url.toString());
        try {
            CloseableHttpClient httpClient = HttpClients.createDefault();
            HttpResponse httpResponse = httpClient.execute((HttpUriRequest)httpGet, (HttpContext)this._getHttpClientContext(url));
            StatusLine statusLine = httpResponse.getStatusLine();
            if (statusLine.getStatusCode() == 200) {
                HttpEntity httpEntity = httpResponse.getEntity();
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this._getBytes(httpEntity.getContent()));
                return byteArrayInputStream;
            }
            try {
                throw new SharepointException(StringBundler.concat((Object[])new Object[]{"Downloading ", url, " failed with status ", statusLine.getStatusCode()}));
            }
            catch (IOException ioException) {
                throw new SharepointException("Unable to communicate with the Sharepoint server", ioException);
            }
        }
        finally {
            httpGet.releaseConnection();
        }
    }

    private byte[] _getBytes(InputStream inputStream) throws SharepointException {
        try {
            return FileUtil.getBytes((InputStream)inputStream);
        }
        catch (IOException ioException) {
            throw new SharepointException("Unable to read input stream", ioException);
        }
    }

    private HttpClientContext _getHttpClientContext(final URL url) {
        HttpClientContext httpClientContext = HttpClientContext.create();
        final HttpHost httpHost = new HttpHost(url.getHost(), url.getPort(), url.getProtocol());
        httpClientContext.setAuthCache((AuthCache)new BasicAuthCache(){
            {
                this.put(httpHost, (AuthScheme)new BasicScheme());
            }
        });
        httpClientContext.setCredentialsProvider((CredentialsProvider)new BasicCredentialsProvider(){
            {
                this.setCredentials(new AuthScope(httpHost, url.getHost(), "Basic"), (Credentials)new UsernamePasswordCredentials(GetInputStreamOperation.this.sharepointConnectionInfo.getUserName(), GetInputStreamOperation.this.sharepointConnectionInfo.getPassword()));
            }
        });
        return httpClientContext;
    }
}

