/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.sharepoint.soap.repository.connector.operation;

import com.liferay.sharepoint.soap.repository.connector.SharepointException;
import com.liferay.sharepoint.soap.repository.connector.SharepointObject;
import com.liferay.sharepoint.soap.repository.connector.operation.BaseOperation;
import com.liferay.sharepoint.soap.repository.connector.operation.BatchOperation;
import com.liferay.sharepoint.soap.repository.connector.operation.GetSharepointObjectByPathOperation;
import com.liferay.sharepoint.soap.repository.connector.schema.batch.Batch;
import com.liferay.sharepoint.soap.repository.connector.schema.batch.BatchField;
import com.liferay.sharepoint.soap.repository.connector.schema.batch.BatchMethod;

public final class DeleteSharepointObjectOperation
extends BaseOperation {
    private BatchOperation _batchOperation;
    private GetSharepointObjectByPathOperation _getSharepointObjectByPathOperation;

    @Override
    public void afterPropertiesSet() {
        this._batchOperation = this.getOperation(BatchOperation.class);
        this._getSharepointObjectByPathOperation = this.getOperation(GetSharepointObjectByPathOperation.class);
    }

    public void execute(String path) throws SharepointException {
        SharepointObject sharepointObject = this._getSharepointObjectByPathOperation.execute(path);
        if (sharepointObject == null) {
            throw new SharepointException("Unable to find Sharepoint object with path " + path);
        }
        this._batchOperation.execute(new Batch(Batch.OnError.CONTINUE, null, new BatchMethod(0, BatchMethod.Command.DELETE, new BatchField("ID", sharepointObject.getSharepointObjectId()), new BatchField("FileRef", this.toFullPath(sharepointObject.getPath())))));
    }
}

