/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.sharepoint.rest.repository.internal.util;

import com.liferay.document.library.repository.external.ExtRepositoryFileEntry;
import com.liferay.document.library.repository.external.ExtRepositoryObject;
import com.liferay.document.library.repository.external.ExtRepositoryObjectType;
import com.liferay.portal.kernel.util.HtmlUtil;
import com.liferay.portal.kernel.util.HttpUtil;
import com.liferay.portal.kernel.util.StringUtil;
import java.util.Arrays;

public class SharepointURLHelper {
    private static final String _FIELDS_EXPANDED_FILE = StringUtil.merge(Arrays.asList("Author", "CheckedOutByUser", "ListItemAllFields"));
    private static final String _FIELDS_EXPANDED_FOLDER = "ListItemAllFields";
    private static final String _FIELDS_SELECTED_FILE = StringUtil.merge(Arrays.asList("Author/Title", "CheckedOutByUser/Title", "Length", "ListItemAllFields/EffectiveBasePermissions", "Name", "ServerRelativeUrl", "TimeCreated", "TimeLastModified", "Title", "UIVersion", "UIVersionLabel"));
    private static final String _FIELDS_SELECTED_FOLDER = StringUtil.merge(Arrays.asList("Name", "ListItemAllFields/EffectiveBasePermissions", "ServerRelativeUrl", "TimeCreated", "TimeLastModified"));
    private final String _resultsSourceId;
    private final String _siteAbsoluteURL;

    public SharepointURLHelper(String siteAbsoluteURL, String resultsSourceId) {
        this._siteAbsoluteURL = siteAbsoluteURL;
        this._resultsSourceId = resultsSourceId;
    }

    public String getAddFileURL(String extRepositoryFolderKey, String name) {
        return String.format("%s/_api/web/GetFolderByServerRelativePath(decodedUrl='%s')/Files/Add(overwrite=false,url='%s')", this._siteAbsoluteURL, HttpUtil.encodePath((String)extRepositoryFolderKey), HttpUtil.encodePath((String)name));
    }

    public String getAddFolderURL(String extRepositoryFolderKey) {
        return String.format("%s/_api/web/GetFolderByServerRelativePath(decodedUrl='%s')/Folders", this._siteAbsoluteURL, HttpUtil.encodePath((String)extRepositoryFolderKey));
    }

    public String getCancelCheckedOutFileURL(String extRepositoryFileEntryKey) {
        return String.format("%s/_api/web/GetFileByServerRelativePath(decodedUrl='%s')/UndoCheckOut", this._siteAbsoluteURL, HttpUtil.encodePath((String)extRepositoryFileEntryKey));
    }

    public String getCheckInFileURL(String extRepositoryFileEntryKey, boolean createMajorVersion, String changeLog) {
        int checkInType = 0;
        if (createMajorVersion) {
            checkInType = 1;
        }
        return String.format("%s/_api/web/GetFileByServerRelativePath(decodedUrl='%s')/CheckIn(comment='%s',checkintype=%d)", this._siteAbsoluteURL, HttpUtil.encodePath((String)extRepositoryFileEntryKey), changeLog, checkInType);
    }

    public String getCheckOutFileURL(String extRepositoryFileEntryKey) {
        return String.format("%s/_api/web/GetFileByServerRelativePath(decodedUrl='%s')/CheckOut", this._siteAbsoluteURL, HttpUtil.encodePath((String)extRepositoryFileEntryKey));
    }

    public String getCopyFileURL(String extRepositoryFileEntryKey, String newExtRepositoryFolderKey, String newTitle) {
        return String.format("%s/_api/web/GetFileByServerRelativePath(decodedUrl='%s')/CopyTo(strnewurl='%s',boverwrite=false)", this._siteAbsoluteURL, HttpUtil.encodePath((String)extRepositoryFileEntryKey), HttpUtil.encodePath((String)newExtRepositoryFolderKey) + "/" + HttpUtil.encodePath((String)newTitle));
    }

    public <T extends ExtRepositoryObject> String getDeleteObjectURL(ExtRepositoryObjectType<T> extRepositoryObjectType, String extRepositoryObjectKey) {
        if (extRepositoryObjectType == ExtRepositoryObjectType.FILE) {
            return String.format("%s/_api/web/GetFileByServerRelativePath(decodedUrl='%s')", this._siteAbsoluteURL, HttpUtil.encodePath((String)extRepositoryObjectKey));
        }
        return String.format("%s/_api/web/GetFolderByServerRelativePath(decodedUrl='%s')", this._siteAbsoluteURL, HttpUtil.encodePath((String)extRepositoryObjectKey));
    }

    public String getFileEntryContentURL(ExtRepositoryFileEntry extRepositoryFileEntry) {
        return String.format("%s/_api/web/GetFileByServerRelativePath(decodedUrl='%s')/OpenBinaryStream", this._siteAbsoluteURL, HttpUtil.encodePath((String)extRepositoryFileEntry.getExtRepositoryModelKey()));
    }

    public String getFilesURL(String extRepositoryFolderKey) {
        return String.format("%s/_api/web/GetFolderByServerRelativePath(decodedUrl='%s')/Files?$select=%s&$expand=%s", this._siteAbsoluteURL, HttpUtil.encodePath((String)extRepositoryFolderKey), _FIELDS_SELECTED_FILE, _FIELDS_EXPANDED_FILE);
    }

    public String getFileVersionContentURL(ExtRepositoryFileEntry extRepositoryFileEntry, String versionId) {
        return String.format("%s/_api/web/GetFileByServerRelativePath(decodedUrl='%s')/Versions(%s)", this._siteAbsoluteURL, HttpUtil.encodePath((String)extRepositoryFileEntry.getExtRepositoryModelKey()), versionId);
    }

    public String getFileVersionsURL(ExtRepositoryFileEntry extRepositoryFileEntry) {
        return String.format("%s/_api/web/GetFileByServerRelativePath(decodedUrl='%s')/Versions", this._siteAbsoluteURL, HttpUtil.encodePath((String)extRepositoryFileEntry.getExtRepositoryModelKey()));
    }

    public String getFoldersURL(String extRepositoryFolderKey) {
        return String.format("%s/_api/web/GetFolderByServerRelativePath(decodedUrl='%s')/Folders?$select=%s&$expand=%s", this._siteAbsoluteURL, HttpUtil.encodePath((String)extRepositoryFolderKey), _FIELDS_SELECTED_FOLDER, _FIELDS_EXPANDED_FOLDER);
    }

    public String getMoveFileURL(String extRepositoryFileEntryKey, String extRepositoryFolderKey, String title) {
        return String.format("%s/_api/web/GetFileByServerRelativePath(decodedUrl='%s')/MoveTo(newurl='%s',flags=1)", this._siteAbsoluteURL, HttpUtil.encodePath((String)extRepositoryFileEntryKey), HttpUtil.encodePath((String)extRepositoryFolderKey) + "/" + HttpUtil.encodePath((String)title));
    }

    public <T extends ExtRepositoryObject> String getObjectsCountURL(ExtRepositoryObjectType<T> extRepositoryObjectType, String extRepositoryFolderKey) {
        if (extRepositoryObjectType == ExtRepositoryObjectType.OBJECT) {
            return String.format("%s/_api/web/GetFolderByServerRelativePath(decodedUrl='%s')/ItemCount", this._siteAbsoluteURL, HttpUtil.encodePath((String)extRepositoryFolderKey));
        }
        if (extRepositoryObjectType == ExtRepositoryObjectType.FOLDER) {
            return String.format("%s/_api/web/GetFolderByServerRelativePath(decodedUrl='%s')/Folders?$select=ItemCount", this._siteAbsoluteURL, HttpUtil.encodePath((String)extRepositoryFolderKey));
        }
        return String.format("%s/_api/web/GetFolderByServerRelativePath(decodedUrl='%s')/Files?$select=Level", this._siteAbsoluteURL, HttpUtil.encodePath((String)extRepositoryFolderKey));
    }

    public <T extends ExtRepositoryObject> String getObjectURL(ExtRepositoryObjectType<T> extRepositoryObjectType, String extRepositoryObjectKey) {
        if (extRepositoryObjectType == ExtRepositoryObjectType.FILE) {
            return String.format("%s/_api/web/GetFileByServerRelativePath(decodedUrl='%s')?$select=%s&$expand=%s", this._siteAbsoluteURL, HttpUtil.encodePath((String)extRepositoryObjectKey), _FIELDS_SELECTED_FILE, _FIELDS_EXPANDED_FILE);
        }
        return String.format("%s/_api/web/GetFolderByServerRelativePath(decodedUrl='%s')?$select=%s&$expand=%s", this._siteAbsoluteURL, HttpUtil.encodePath((String)extRepositoryObjectKey), _FIELDS_SELECTED_FOLDER, _FIELDS_EXPANDED_FOLDER);
    }

    public String getSearchURL(String queryText, int start, int end) {
        return String.format("%s/_api/search/query?QueryText='%s'&SourceID='%s'&StartRow=%d&RowsPerPage=%d", this._siteAbsoluteURL, HtmlUtil.escapeURL((String)queryText), this._resultsSourceId, start, end - start);
    }

    public String getUpdateFileURL(String extRepositoryFileEntryKey) {
        return String.format("%s/_api/web/GetFileByServerRelativePath(decodedUrl='%s')/$value", this._siteAbsoluteURL, HttpUtil.encodePath((String)extRepositoryFileEntryKey));
    }
}

