/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.sharepoint.rest.repository.internal.search.kql;

import com.liferay.document.library.repository.external.search.ExtRepositoryQueryMapper;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.search.BooleanClause;
import com.liferay.portal.kernel.search.BooleanClauseOccur;
import com.liferay.portal.kernel.search.BooleanQuery;
import com.liferay.portal.kernel.search.Query;
import com.liferay.portal.kernel.search.QueryTerm;
import com.liferay.portal.kernel.search.SearchException;
import com.liferay.portal.kernel.search.TermQuery;
import com.liferay.portal.kernel.search.TermRangeQuery;
import com.liferay.portal.kernel.search.WildcardQuery;
import com.liferay.portal.kernel.search.generic.DisMaxQuery;
import com.liferay.portal.kernel.search.generic.FuzzyQuery;
import com.liferay.portal.kernel.search.generic.MatchAllQuery;
import com.liferay.portal.kernel.search.generic.MatchQuery;
import com.liferay.portal.kernel.search.generic.MoreLikeThisQuery;
import com.liferay.portal.kernel.search.generic.MultiMatchQuery;
import com.liferay.portal.kernel.search.generic.NestedQuery;
import com.liferay.portal.kernel.search.generic.StringQuery;
import com.liferay.portal.kernel.search.query.QueryVisitor;
import com.liferay.portal.kernel.util.DateFormatFactoryUtil;
import com.liferay.sharepoint.rest.repository.internal.search.kql.KQLQuery;
import com.liferay.sharepoint.rest.repository.internal.search.kql.NullKQLQuery;
import java.text.DateFormat;
import java.util.Date;

public class KQLQueryVisitor
implements QueryVisitor<KQLQuery> {
    private final ExtRepositoryQueryMapper _extRepositoryQueryMapper;
    private final String _siteAbsoluteURL;

    public KQLQueryVisitor(ExtRepositoryQueryMapper extRepositoryQueryMapper, String siteAbsoluteURL) {
        this._extRepositoryQueryMapper = extRepositoryQueryMapper;
        this._siteAbsoluteURL = siteAbsoluteURL;
    }

    public KQLQuery visitQuery(BooleanQuery booleanQuery) {
        if (!booleanQuery.hasClauses()) {
            return NullKQLQuery.INSTANCE;
        }
        KQLQuery mustKQLQuery = NullKQLQuery.INSTANCE;
        KQLQuery mustNotKQLQuery = NullKQLQuery.INSTANCE;
        KQLQuery shouldKQLQuery = NullKQLQuery.INSTANCE;
        for (BooleanClause booleanClause : booleanQuery.clauses()) {
            BooleanClauseOccur booleanClauseOccur = booleanClause.getBooleanClauseOccur();
            Query query = (Query)booleanClause.getClause();
            KQLQuery kqlQuery = (KQLQuery)query.accept((QueryVisitor)this);
            if (booleanClauseOccur.equals(BooleanClauseOccur.MUST)) {
                mustKQLQuery = mustKQLQuery.and(kqlQuery);
                continue;
            }
            if (booleanClauseOccur.equals(BooleanClauseOccur.MUST_NOT)) {
                mustNotKQLQuery = mustNotKQLQuery.and(kqlQuery);
                continue;
            }
            if (booleanClauseOccur.equals(BooleanClauseOccur.SHOULD)) {
                shouldKQLQuery = shouldKQLQuery.or(kqlQuery);
                continue;
            }
            throw new IllegalArgumentException("Unsupported boolean clause occur: " + booleanClauseOccur.getName());
        }
        return KQLQuery.and(mustKQLQuery, mustNotKQLQuery.not(), shouldKQLQuery);
    }

    public KQLQuery visitQuery(DisMaxQuery disMaxQuery) {
        throw new UnsupportedOperationException();
    }

    public KQLQuery visitQuery(FuzzyQuery fuzzyQuery) {
        throw new UnsupportedOperationException();
    }

    public KQLQuery visitQuery(MatchAllQuery matchAllQuery) {
        throw new UnsupportedOperationException();
    }

    public KQLQuery visitQuery(MatchQuery matchQuery) {
        throw new UnsupportedOperationException();
    }

    public KQLQuery visitQuery(MoreLikeThisQuery moreLikeThisQuery) {
        throw new UnsupportedOperationException();
    }

    public KQLQuery visitQuery(MultiMatchQuery multiMatchQuery) {
        throw new UnsupportedOperationException();
    }

    public KQLQuery visitQuery(NestedQuery nestedQuery) {
        throw new UnsupportedOperationException();
    }

    public KQLQuery visitQuery(StringQuery stringQuery) {
        throw new UnsupportedOperationException();
    }

    public KQLQuery visitQuery(TermQuery termQuery) {
        return this._visitQueryTerm(termQuery.getQueryTerm());
    }

    public KQLQuery visitQuery(TermRangeQuery termRangeQuery) {
        String field = termRangeQuery.getField();
        String translatedField = this._translateField(field);
        if (translatedField == null) {
            return NullKQLQuery.INSTANCE;
        }
        return KQLQuery.range(this._translateValue(field, termRangeQuery.getLowerTerm()), this._translateValue(field, termRangeQuery.getUpperTerm()));
    }

    public KQLQuery visitQuery(WildcardQuery wildcardQuery) {
        return this._visitQueryTerm(wildcardQuery.getQueryTerm());
    }

    private String _removeExtension(String s) {
        int i = s.lastIndexOf(46);
        if (i == -1) {
            return s;
        }
        return s.substring(0, i);
    }

    private String _translateField(String field) {
        if (field.equals("createDate") || field.equals("modified")) {
            return "LastModifiedDate";
        }
        if (field.equals("folderId")) {
            return "Path";
        }
        if (field.equals("name") || field.equals("title")) {
            return "Title";
        }
        if (field.equals("userId") || field.equals("userName")) {
            return "Author";
        }
        return null;
    }

    private String _translateValue(String field, String value) {
        try {
            if (field.equals("createDate") || field.equals("modified")) {
                Date date = this._extRepositoryQueryMapper.formatDateParameterValue(field, value);
                DateFormat dateFormat = DateFormatFactoryUtil.getSimpleDateFormat((String)"yyyy-MM-ddTHH:mm:ss");
                return dateFormat.format(date);
            }
            if (field.equals("name") || field.equals("title")) {
                value = this._removeExtension(value);
            }
            String formattedValue = this._extRepositoryQueryMapper.formatParameterValue(field, value);
            if (field.equals("folderId")) {
                formattedValue = this._siteAbsoluteURL + "/" + formattedValue;
            }
            return String.format("\"%s\"", formattedValue);
        }
        catch (SearchException searchException) {
            throw new SystemException((Throwable)searchException);
        }
    }

    private KQLQuery _visitQueryTerm(QueryTerm queryTerm) {
        String field = queryTerm.getField();
        String translatedField = this._translateField(field);
        if (translatedField == null) {
            return NullKQLQuery.INSTANCE;
        }
        return KQLQuery.eq(translatedField, this._translateValue(field, queryTerm.getValue()));
    }
}

