/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.sharepoint.rest.repository.internal.document.library.repository.authorization.oauth2;

import com.liferay.portal.configuration.metatype.bnd.util.ConfigurableUtil;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.sharepoint.rest.repository.internal.configuration.SharepointRepositoryConfiguration;
import com.liferay.sharepoint.rest.repository.internal.document.library.repository.authorization.oauth2.SharepointRepositoryTokenBroker;
import java.io.IOException;
import java.util.Dictionary;
import java.util.NoSuchElementException;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={SharepointRepositoryTokenBrokerFactory.class})
public class SharepointRepositoryTokenBrokerFactory {
    @Reference
    private ConfigurationAdmin _configurationAdmin;

    public SharepointRepositoryTokenBroker create(SharepointRepositoryConfiguration sharepointRepositoryConfiguration) {
        return new SharepointRepositoryTokenBroker(sharepointRepositoryConfiguration);
    }

    public SharepointRepositoryTokenBroker create(String configurationPid) {
        return this.create(this._getSharepointRepositoryConfiguration(configurationPid));
    }

    private SharepointRepositoryConfiguration _getSharepointRepositoryConfiguration(String configurationPid) {
        try {
            Configuration[] configurations;
            for (Configuration configuration : configurations = this._configurationAdmin.listConfigurations("(service.factoryPid=" + SharepointRepositoryConfiguration.class.getName() + ")")) {
                Dictionary properties = configuration.getProperties();
                String name = (String)properties.get("name");
                if (name == null || !name.equals(configurationPid)) continue;
                return (SharepointRepositoryConfiguration)ConfigurableUtil.createConfigurable(SharepointRepositoryConfiguration.class, (Dictionary)properties);
            }
            throw new NoSuchElementException("No configuration found with name " + configurationPid);
        }
        catch (IOException | InvalidSyntaxException exception) {
            throw new SystemException(exception);
        }
    }
}

