/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.sharepoint.rest.repository.internal.struts;

import com.liferay.document.library.kernel.service.DLAppLocalService;
import com.liferay.document.library.repository.authorization.capability.AuthorizationCapability;
import com.liferay.portal.kernel.repository.Repository;
import com.liferay.portal.kernel.repository.RepositoryProviderUtil;
import com.liferay.portal.kernel.repository.model.Folder;
import com.liferay.portal.kernel.struts.StrutsAction;
import com.liferay.sharepoint.rest.repository.internal.document.library.repository.authorization.oauth2.SharepointRepositoryRequestState;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"path=/document_library/sharepoint/oauth2"}, service={StrutsAction.class})
public class SharepointOAuth2StrutsAction
implements StrutsAction {
    @Reference
    private DLAppLocalService _dlAppLocalService;

    public String execute(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        Repository repository = this._getRepository(httpServletRequest);
        if (repository.isCapabilityProvided(AuthorizationCapability.class)) {
            AuthorizationCapability authorizationCapability = (AuthorizationCapability)repository.getCapability(AuthorizationCapability.class);
            authorizationCapability.authorize(httpServletRequest, httpServletResponse);
        }
        return null;
    }

    private Repository _getRepository(HttpServletRequest httpServletRequest) throws Exception {
        SharepointRepositoryRequestState sharepointRepositoryRequestState = SharepointRepositoryRequestState.get(httpServletRequest);
        Folder folder = this._dlAppLocalService.getFolder(sharepointRepositoryRequestState.getFolderId());
        return RepositoryProviderUtil.getRepository((long)folder.getRepositoryId());
    }
}

