/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.sharepoint.rest.repository.internal.document.library.repository.external;

import com.liferay.document.library.repository.authorization.capability.AuthorizationCapability;
import com.liferay.document.library.repository.authorization.oauth2.TokenStore;
import com.liferay.portal.configuration.metatype.bnd.util.ConfigurableUtil;
import com.liferay.portal.kernel.repository.DocumentRepository;
import com.liferay.portal.kernel.repository.RepositoryConfiguration;
import com.liferay.portal.kernel.repository.RepositoryConfigurationBuilder;
import com.liferay.portal.kernel.repository.RepositoryFactory;
import com.liferay.portal.kernel.repository.capabilities.Capability;
import com.liferay.portal.kernel.repository.capabilities.PortalCapabilityLocator;
import com.liferay.portal.kernel.repository.capabilities.ProcessorCapability;
import com.liferay.portal.kernel.repository.registry.CapabilityRegistry;
import com.liferay.portal.kernel.repository.registry.RepositoryDefiner;
import com.liferay.portal.kernel.repository.registry.RepositoryEventRegistry;
import com.liferay.portal.kernel.repository.registry.RepositoryFactoryRegistry;
import com.liferay.portal.kernel.resource.bundle.ResourceBundleLoader;
import com.liferay.portal.kernel.resource.bundle.ResourceBundleLoaderUtil;
import com.liferay.portal.kernel.util.ResourceBundleUtil;
import com.liferay.sharepoint.rest.repository.internal.configuration.SharepointRepositoryConfiguration;
import com.liferay.sharepoint.rest.repository.internal.configuration.SharepointSearchConfiguration;
import com.liferay.sharepoint.rest.repository.internal.document.library.repository.authorization.capability.SharepointRepositoryAuthorizationCapability;
import com.liferay.sharepoint.rest.repository.internal.document.library.repository.authorization.oauth2.SharepointRepositoryTokenBrokerFactory;
import com.liferay.sharepoint.rest.repository.internal.document.library.repository.external.SharepointExtRepository;
import com.liferay.sharepoint.rest.repository.internal.document.library.repository.external.SharepointRepositoryFactoryProvider;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Reference;

@Component(configurationPid={"com.liferay.sharepoint.rest.repository.internal.configuration.SharepointRepositoryConfiguration"}, configurationPolicy=ConfigurationPolicy.REQUIRE, service={RepositoryDefiner.class})
public class SharepointRepositoryDefiner
implements RepositoryDefiner {
    @Reference
    private PortalCapabilityLocator _portalCapabilityLocator;
    @Reference
    private SharepointRepositoryFactoryProvider _repositoryFactoryProvider;
    private final ResourceBundleLoader _resourceBundleLoader = ResourceBundleLoaderUtil.getResourceBundleLoaderByBundleSymbolicName((String)"com.liferay.sharepoint.rest.repository");
    private SharepointRepositoryConfiguration _sharepointRepositoryConfiguration;
    @Reference
    private SharepointRepositoryTokenBrokerFactory _sharepointRepositoryTokenBrokerFactory;
    private SharepointSearchConfiguration _sharepointSearchConfiguration;
    @Reference
    private TokenStore _tokenStore;

    public String getClassName() {
        return SharepointExtRepository.class.getName() + this._sharepointRepositoryConfiguration.name();
    }

    public RepositoryConfiguration getRepositoryConfiguration() {
        RepositoryConfigurationBuilder repositoryConfigurationBuilder = new RepositoryConfigurationBuilder(this._resourceBundleLoader, new String[0]);
        repositoryConfigurationBuilder.addParameter("library-path");
        repositoryConfigurationBuilder.addParameter("site-absolute-url");
        return repositoryConfigurationBuilder.build();
    }

    public String getRepositoryTypeLabel(Locale locale) {
        ResourceBundle resourceBundle = this._resourceBundleLoader.loadResourceBundle(locale);
        String label = ResourceBundleUtil.getString((ResourceBundle)resourceBundle, (String)"sharepoint");
        return String.format("%s (%s)", label, this._sharepointRepositoryConfiguration.name());
    }

    public boolean isExternalRepository() {
        return true;
    }

    public void registerCapabilities(CapabilityRegistry<DocumentRepository> capabilityRegistry) {
        capabilityRegistry.addSupportedCapability(ProcessorCapability.class, (Capability)this._portalCapabilityLocator.getProcessorCapability((DocumentRepository)capabilityRegistry.getTarget(), ProcessorCapability.ResourceGenerationStrategy.ALWAYS_GENERATE));
        capabilityRegistry.addExportedCapability(AuthorizationCapability.class, (Capability)new SharepointRepositoryAuthorizationCapability(this._tokenStore, this._sharepointRepositoryConfiguration, this._sharepointRepositoryTokenBrokerFactory.create(this._sharepointRepositoryConfiguration)));
    }

    public void registerRepositoryEventListeners(RepositoryEventRegistry repositoryEventRegistry) {
    }

    public void registerRepositoryFactory(RepositoryFactoryRegistry repositoryFactoryRegistry) {
        repositoryFactoryRegistry.setRepositoryFactory((RepositoryFactory)this._repositoryFactoryProvider.createForConfiguration(this._sharepointRepositoryConfiguration, this._sharepointSearchConfiguration));
    }

    @Activate
    protected void activate(Map<String, Object> properties) {
        this._sharepointRepositoryConfiguration = (SharepointRepositoryConfiguration)ConfigurableUtil.createConfigurable(SharepointRepositoryConfiguration.class, properties);
        this._sharepointSearchConfiguration = (SharepointSearchConfiguration)ConfigurableUtil.createConfigurable(SharepointSearchConfiguration.class, properties);
    }
}

