/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.sharepoint.rest.repository.internal.document.library.repository.authorization.oauth2;

import com.liferay.document.library.repository.authorization.oauth2.Token;
import com.liferay.document.library.repository.authorization.oauth2.TokenStore;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.sharepoint.rest.oauth2.service.SharepointOAuth2TokenEntryLocalService;
import com.liferay.sharepoint.rest.repository.internal.document.library.repository.authorization.oauth2.SharepointRepositoryToken;
import com.liferay.sharepoint.rest.repository.internal.document.library.repository.authorization.oauth2.SharepointRepositoryTokenBroker;
import com.liferay.sharepoint.rest.repository.internal.document.library.repository.authorization.oauth2.SharepointRepositoryTokenBrokerFactory;
import java.io.IOException;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={TokenStore.class})
public class SharepointRepositoryTokenStore
implements TokenStore {
    @Reference
    private SharepointOAuth2TokenEntryLocalService _sharepointOAuth2TokenEntryLocalService;
    @Reference
    private SharepointRepositoryTokenBrokerFactory _sharepointRepositoryTokenBrokerFactory;

    public void delete(String configurationPid, long userId) throws PortalException {
        this._sharepointOAuth2TokenEntryLocalService.deleteSharepointOAuth2TokenEntry(userId, configurationPid);
    }

    public Token get(String configurationPid, long userId) throws PortalException {
        try {
            Token token = SharepointRepositoryToken.newInstance(this._sharepointOAuth2TokenEntryLocalService.fetchSharepointOAuth2TokenEntry(userId, configurationPid));
            if (token == null || !token.isExpired()) {
                return token;
            }
            SharepointRepositoryTokenBroker sharepointRepositoryTokenBroker = this._sharepointRepositoryTokenBrokerFactory.create(configurationPid);
            Token freshToken = sharepointRepositoryTokenBroker.refreshAccessToken(token);
            this.save(configurationPid, userId, freshToken);
            return freshToken;
        }
        catch (IOException ioException) {
            throw new SystemException((Throwable)ioException);
        }
    }

    public Token getFresh(String configurationPid, long userId) throws PortalException {
        try {
            Token token = SharepointRepositoryToken.newInstance(this._sharepointOAuth2TokenEntryLocalService.fetchSharepointOAuth2TokenEntry(userId, configurationPid));
            SharepointRepositoryTokenBroker sharepointRepositoryTokenBroker = this._sharepointRepositoryTokenBrokerFactory.create(configurationPid);
            Token freshToken = sharepointRepositoryTokenBroker.refreshAccessToken(token);
            this.save(configurationPid, userId, freshToken);
            return freshToken;
        }
        catch (IOException ioException) {
            throw new SystemException((Throwable)ioException);
        }
    }

    public void save(String configurationPid, long userId, Token token) throws PortalException {
        this._sharepointOAuth2TokenEntryLocalService.addSharepointOAuth2TokenEntry(userId, configurationPid, token.getAccessToken(), token.getRefreshToken(), token.getExpirationDate());
    }
}

