/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.sharepoint.rest.repository.internal.util;

import com.liferay.document.library.repository.external.ExtRepositoryFileEntry;
import com.liferay.document.library.repository.external.ExtRepositoryObject;
import com.liferay.document.library.repository.external.ExtRepositoryObjectType;
import com.liferay.portal.kernel.util.HtmlUtil;
import com.liferay.portal.kernel.util.StringUtil;
import java.util.Arrays;

public class SharepointURLHelper {
    private static final String _FIELDS_EXPANDED_FILE = StringUtil.merge(Arrays.asList("Author", "CheckedOutByUser", "ListItemAllFields"));
    private static final String _FIELDS_EXPANDED_FOLDER = "ListItemAllFields";
    private static final String _FIELDS_SELECTED_FILE = StringUtil.merge(Arrays.asList("Author/Title", "CheckedOutByUser/Title", "Length", "ListItemAllFields/EffectiveBasePermissions", "Name", "ServerRelativeUrl", "TimeCreated", "TimeLastModified", "Title", "UIVersion", "UIVersionLabel"));
    private static final String _FIELDS_SELECTED_FOLDER = StringUtil.merge(Arrays.asList("Name", "ListItemAllFields/EffectiveBasePermissions", "ServerRelativeUrl", "TimeCreated", "TimeLastModified"));
    private final String _resultsSourceId;
    private final String _siteAbsoluteURL;

    public SharepointURLHelper(String siteAbsoluteURL, String resultsSourceId) {
        this._siteAbsoluteURL = siteAbsoluteURL;
        this._resultsSourceId = resultsSourceId;
    }

    public String getAbsoluteURL(String relativeURL) {
        if (this._siteAbsoluteURL.endsWith("/") || relativeURL.startsWith("/")) {
            return this._siteAbsoluteURL + relativeURL;
        }
        return this._siteAbsoluteURL + "/" + relativeURL;
    }

    public String getAddFileURL(String extRepositoryFolderKey, String name) {
        return String.format("%s/_api/web/GetFolderByServerRelativeUrl('%s')/Files/Add(overwrite=true,url='%s')", this._siteAbsoluteURL, extRepositoryFolderKey, name);
    }

    public String getAddFolderURL(String extRepositoryFolderKey) {
        return String.format("%s/_api/web/GetFolderByServerRelativeUrl('%s')/Folders", this._siteAbsoluteURL, extRepositoryFolderKey);
    }

    public String getCancelCheckedOutFileURL(String extRepositoryFileEntryKey) {
        return String.format("%s/_api/web/GetFileByServerRelativeUrl('%s')/UndoCheckOut", this._siteAbsoluteURL, extRepositoryFileEntryKey);
    }

    public String getCheckInFileURL(String extRepositoryFileEntryKey, boolean createMajorVersion, String changeLog) {
        int checkInType = 0;
        if (createMajorVersion) {
            checkInType = 1;
        }
        return String.format("%s/_api/web/GetFileByServerRelativeUrl('%s')/CheckIn(comment='%s',checkintype=%d)", this._siteAbsoluteURL, extRepositoryFileEntryKey, changeLog, checkInType);
    }

    public String getCheckOutFileURL(String extRepositoryFileEntryKey) {
        return String.format("%s/_api/web/GetFileByServerRelativeUrl('%s')/CheckOut", this._siteAbsoluteURL, extRepositoryFileEntryKey);
    }

    public String getCopyFileURL(String extRepositoryFileEntryKey, String newExtRepositoryFolderKey, String newTitle) {
        return String.format("%s/_api/web/GetFileByServerRelativeUrl('%s')/CopyTo(strnewurl='%s',boverwrite=false)", this._siteAbsoluteURL, extRepositoryFileEntryKey, newExtRepositoryFolderKey + "/" + newTitle);
    }

    public <T extends ExtRepositoryObject> String getDeleteObjectURL(ExtRepositoryObjectType<T> extRepositoryObjectType, String extRepositoryObjectKey) {
        if (extRepositoryObjectType == ExtRepositoryObjectType.FILE) {
            return String.format("%s/_api/web/GetFileByServerRelativeUrl('%s')", this._siteAbsoluteURL, extRepositoryObjectKey);
        }
        return String.format("%s/_api/web/GetFolderByServerRelativeUrl('%s')", this._siteAbsoluteURL, extRepositoryObjectKey);
    }

    public String getFileEntryContentURL(ExtRepositoryFileEntry extRepositoryFileEntry) {
        return String.format("%s/_api/web/GetFileByServerRelativeUrl('%s')/OpenBinaryStream", this._siteAbsoluteURL, extRepositoryFileEntry.getExtRepositoryModelKey());
    }

    public String getFilesURL(String extRepositoryFolderKey) {
        return String.format("%s/_api/web/GetFolderByServerRelativeUrl('%s')/Files?$select=%s&$expand=%s", this._siteAbsoluteURL, extRepositoryFolderKey, _FIELDS_SELECTED_FILE, _FIELDS_EXPANDED_FILE);
    }

    public String getFileVersionContentURL(ExtRepositoryFileEntry extRepositoryFileEntry, String versionId) {
        return String.format("%s/_api/web/getfilebyserverrelativeurl('%s')/versions(%s)", this._siteAbsoluteURL, extRepositoryFileEntry.getExtRepositoryModelKey(), versionId);
    }

    public String getFileVersionsURL(ExtRepositoryFileEntry extRepositoryFileEntry) {
        return String.format("%s/_api/web/GetFileByServerRelativeUrl('%s')/Versions", this._siteAbsoluteURL, extRepositoryFileEntry.getExtRepositoryModelKey());
    }

    public String getFoldersURL(String extRepositoryFolderKey) {
        return String.format("%s/_api/web/GetFolderByServerRelativeUrl('%s')/Folders?$select=%s&$expand=%s", this._siteAbsoluteURL, extRepositoryFolderKey, _FIELDS_SELECTED_FOLDER, _FIELDS_EXPANDED_FOLDER);
    }

    public String getMoveFileURL(String extRepositoryFileEntryKey, String extRepositoryFolderKey, String title) {
        return String.format("%s/_api/web/GetFileByServerRelativeUrl('%s')/MoveTo(newurl='%s',flags=1)", this._siteAbsoluteURL, extRepositoryFileEntryKey, extRepositoryFolderKey + "/" + title);
    }

    public <T extends ExtRepositoryObject> String getObjectsCountURL(ExtRepositoryObjectType<T> extRepositoryObjectType, String extRepositoryFolderKey) {
        if (extRepositoryObjectType == ExtRepositoryObjectType.OBJECT) {
            return String.format("%s/_api/web/GetFolderByServerRelativeUrl('%s')/ItemCount", this._siteAbsoluteURL, extRepositoryFolderKey);
        }
        if (extRepositoryObjectType == ExtRepositoryObjectType.FOLDER) {
            return String.format("%s/_api/web/GetFolderByServerRelativeUrl('%s')/Folders?$select=ItemCount", this._siteAbsoluteURL, extRepositoryFolderKey);
        }
        return String.format("%s/_api/web/GetFolderByServerRelativeUrl('%s')/Files?$select=Level", this._siteAbsoluteURL, extRepositoryFolderKey);
    }

    public <T extends ExtRepositoryObject> String getObjectURL(ExtRepositoryObjectType<T> extRepositoryObjectType, String extRepositoryObjectKey) {
        if (extRepositoryObjectType == ExtRepositoryObjectType.FILE) {
            return String.format("%s/_api/web/GetFileByServerRelativeUrl('%s')?$select=%s&$expand=%s", this._siteAbsoluteURL, extRepositoryObjectKey, _FIELDS_SELECTED_FILE, _FIELDS_EXPANDED_FILE);
        }
        return String.format("%s/_api/web/GetFolderByServerRelativeUrl('%s')?$select=%s&$expand=%s", this._siteAbsoluteURL, extRepositoryObjectKey, _FIELDS_SELECTED_FOLDER, _FIELDS_EXPANDED_FOLDER);
    }

    public String getSearchURL(String queryText, int start, int end) {
        return String.format("%s/_api/search/query?QueryText='%s'&SourceID='%s'&StartRow=%d&RowsPerPage=%d", this._siteAbsoluteURL, HtmlUtil.escapeURL((String)queryText), this._resultsSourceId, start, end - start);
    }

    public String getUpdateFileURL(String extRepositoryFileEntryKey) {
        return String.format("%s/_api/web/GetFileByServerRelativeUrl('%s')/$value", this._siteAbsoluteURL, extRepositoryFileEntryKey);
    }
}

