/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.sharepoint.rest.repository.internal.document.library.repository.external.model;

import com.liferay.document.library.repository.external.ExtRepositoryFileEntry;
import com.liferay.document.library.repository.external.ExtRepositoryFileVersion;
import com.liferay.document.library.repository.external.ExtRepositoryObject;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.MimeTypesUtil;
import com.liferay.sharepoint.rest.repository.internal.document.library.repository.external.model.SharepointFileEntryFileVersion;
import com.liferay.sharepoint.rest.repository.internal.document.library.repository.external.model.SharepointModel;
import com.liferay.sharepoint.rest.repository.internal.util.SharepointURLHelper;
import java.util.Date;

public class SharepointFileEntry
implements ExtRepositoryFileEntry,
SharepointModel {
    private final String _checkedOutBy;
    private final Date _createDate;
    private final long _effectiveBasePermissionsBits;
    private ExtRepositoryFileVersion _extRepositoryFileVersion;
    private final String _extRepositoryModelKey;
    private final String _fileVersionExtRepositoryModelKey;
    private final Date _modifiedDate;
    private final String _name;
    private final String _owner;
    private final SharepointURLHelper _sharepointURLHelper;
    private final long _size;
    private final String _title;
    private final String _version;

    public SharepointFileEntry(String extRepositoryModelKey, String name, String title, Date createDate, Date modifiedDate, long size, String fileVersionExtRepositoryModelKey, String version, String owner, String checkedOutBy, long effectiveBasePermissionsBits, SharepointURLHelper sharepointURLHelper) {
        this._extRepositoryModelKey = extRepositoryModelKey;
        this._name = name;
        this._title = title;
        this._createDate = createDate;
        this._modifiedDate = modifiedDate;
        this._size = size;
        this._fileVersionExtRepositoryModelKey = fileVersionExtRepositoryModelKey;
        this._version = version;
        this._owner = owner;
        this._checkedOutBy = checkedOutBy;
        this._effectiveBasePermissionsBits = effectiveBasePermissionsBits;
        this._sharepointURLHelper = sharepointURLHelper;
    }

    @Override
    public ExtRepositoryFileVersion asFileVersion() {
        if (this._extRepositoryFileVersion == null) {
            this._extRepositoryFileVersion = new SharepointFileEntryFileVersion(this, this._fileVersionExtRepositoryModelKey, this._version);
        }
        return this._extRepositoryFileVersion;
    }

    public boolean containsPermission(ExtRepositoryObject.ExtRepositoryPermission extRepositoryPermission) {
        if (extRepositoryPermission == ExtRepositoryObject.ExtRepositoryPermission.ACCESS || extRepositoryPermission == ExtRepositoryObject.ExtRepositoryPermission.ADD_DISCUSSION || extRepositoryPermission == ExtRepositoryObject.ExtRepositoryPermission.ADD_DOCUMENT || extRepositoryPermission == ExtRepositoryObject.ExtRepositoryPermission.ADD_FOLDER || extRepositoryPermission == ExtRepositoryObject.ExtRepositoryPermission.ADD_SHORTCUT || extRepositoryPermission == ExtRepositoryObject.ExtRepositoryPermission.ADD_SUBFOLDER || extRepositoryPermission == ExtRepositoryObject.ExtRepositoryPermission.DELETE_DISCUSSION || extRepositoryPermission == ExtRepositoryObject.ExtRepositoryPermission.PERMISSIONS || extRepositoryPermission == ExtRepositoryObject.ExtRepositoryPermission.UPDATE_DISCUSSION) {
            return false;
        }
        int bitIndex = 0;
        if (extRepositoryPermission == ExtRepositoryObject.ExtRepositoryPermission.DELETE) {
            bitIndex = 4;
        } else if (extRepositoryPermission == ExtRepositoryObject.ExtRepositoryPermission.UPDATE) {
            bitIndex = 3;
        } else if (extRepositoryPermission == ExtRepositoryObject.ExtRepositoryPermission.VIEW) {
            bitIndex = 1;
        }
        if (bitIndex == 0) {
            return false;
        }
        return (this._effectiveBasePermissionsBits & (long)(1 << bitIndex - 1)) != 0L;
    }

    @Override
    public String getCanonicalContentURL() {
        return this._sharepointURLHelper.getFileEntryContentURL(this);
    }

    public String getCheckedOutBy() {
        return this._checkedOutBy;
    }

    public Date getCreateDate() {
        return this._createDate;
    }

    public String getDescription() {
        return "";
    }

    public String getExtension() {
        return FileUtil.getExtension((String)this._name);
    }

    @Override
    public ExtRepositoryFileEntry getExtRepositoryFileEntry() {
        return this;
    }

    public String getExtRepositoryModelKey() {
        return this._extRepositoryModelKey;
    }

    public String getMimeType() {
        return MimeTypesUtil.getContentType((String)this._name);
    }

    public Date getModifiedDate() {
        return this._modifiedDate;
    }

    public String getOwner() {
        return this._owner;
    }

    public long getSize() {
        return this._size;
    }

    public String getTitle() {
        return this._title;
    }
}

