/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.sharepoint.rest.repository.internal.document.library.repository.external;

import com.liferay.document.library.kernel.exception.SourceFileNameException;
import com.liferay.document.library.repository.authorization.oauth2.Token;
import com.liferay.document.library.repository.authorization.oauth2.TokenStore;
import com.liferay.document.library.repository.external.CredentialsProvider;
import com.liferay.document.library.repository.external.ExtRepository;
import com.liferay.document.library.repository.external.ExtRepositoryFileEntry;
import com.liferay.document.library.repository.external.ExtRepositoryFileVersion;
import com.liferay.document.library.repository.external.ExtRepositoryFileVersionDescriptor;
import com.liferay.document.library.repository.external.ExtRepositoryFolder;
import com.liferay.document.library.repository.external.ExtRepositoryModel;
import com.liferay.document.library.repository.external.ExtRepositoryObject;
import com.liferay.document.library.repository.external.ExtRepositoryObjectType;
import com.liferay.document.library.repository.external.ExtRepositorySearchResult;
import com.liferay.document.library.repository.external.search.ExtRepositoryQueryMapper;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSONException;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.search.Query;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.query.QueryVisitor;
import com.liferay.portal.kernel.security.auth.PrincipalException;
import com.liferay.portal.kernel.security.auth.PrincipalThreadLocal;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.sharepoint.rest.repository.internal.configuration.SharepointRepositoryConfiguration;
import com.liferay.sharepoint.rest.repository.internal.configuration.SharepointSearchConfiguration;
import com.liferay.sharepoint.rest.repository.internal.document.library.repository.external.model.SharepointFileEntry;
import com.liferay.sharepoint.rest.repository.internal.document.library.repository.external.model.SharepointModel;
import com.liferay.sharepoint.rest.repository.internal.document.library.repository.external.model.SharepointRootFolder;
import com.liferay.sharepoint.rest.repository.internal.search.kql.KQLQuery;
import com.liferay.sharepoint.rest.repository.internal.search.kql.KQLQueryVisitor;
import com.liferay.sharepoint.rest.repository.internal.util.SharepointServerResponseConverter;
import com.liferay.sharepoint.rest.repository.internal.util.SharepointURLHelper;
import com.mashape.unirest.http.HttpResponse;
import com.mashape.unirest.http.Unirest;
import com.mashape.unirest.http.exceptions.UnirestException;
import com.mashape.unirest.request.GetRequest;
import com.mashape.unirest.request.HttpRequestWithBody;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class SharepointExtRepository
implements ExtRepository {
    private String _libraryPath;
    private ExtRepositoryFolder _rootFolder;
    private final SharepointRepositoryConfiguration _sharepointRepositoryConfiguration;
    private final SharepointSearchConfiguration _sharepointSearchConfiguration;
    private SharepointServerResponseConverter _sharepointServerResponseConverter;
    private SharepointURLHelper _sharepointURLHelper;
    private String _siteAbsoluteURL;
    private final TokenStore _tokenStore;

    public SharepointExtRepository(TokenStore tokenStore, SharepointRepositoryConfiguration sharepointRepositoryConfiguration, SharepointSearchConfiguration sharepointSearchConfiguration) {
        this._tokenStore = tokenStore;
        this._sharepointRepositoryConfiguration = sharepointRepositoryConfiguration;
        this._sharepointSearchConfiguration = sharepointSearchConfiguration;
    }

    public ExtRepositoryFileEntry addExtRepositoryFileEntry(String extRepositoryParentFolderKey, String mimeType, String title, String description, String changeLog, InputStream inputStream) throws PortalException {
        try {
            String url = this._sharepointURLHelper.getAddFileURL(extRepositoryParentFolderKey, title);
            JSONObject jsonObject = this._post(url, inputStream);
            return this._sharepointServerResponseConverter.getExtRepositoryFileEntry(jsonObject);
        }
        catch (UnirestException | IOException e) {
            throw new PortalException(e);
        }
    }

    public ExtRepositoryFolder addExtRepositoryFolder(String extRepositoryParentFolderKey, String name, String description) throws PortalException {
        try {
            String url = this._sharepointURLHelper.getAddFolderURL(extRepositoryParentFolderKey);
            JSONObject bodyJSONObject = JSONFactoryUtil.createJSONObject();
            JSONObject metadataJSONObject = JSONFactoryUtil.createJSONObject();
            metadataJSONObject.put("type", "SP.Folder");
            bodyJSONObject.put("__metadata", metadataJSONObject);
            bodyJSONObject.put("ServerRelativeUrl", name);
            JSONObject jsonObject = this._post(url, bodyJSONObject);
            return this._sharepointServerResponseConverter.getExtRepositoryFolder(jsonObject);
        }
        catch (UnirestException | IOException e) {
            throw new PortalException(e);
        }
    }

    public ExtRepositoryFileVersion cancelCheckOut(String extRepositoryFileEntryKey) throws PortalException {
        try {
            String url = this._sharepointURLHelper.getCancelCheckedOutFileURL(extRepositoryFileEntryKey);
            this._post(url);
            return null;
        }
        catch (UnirestException ue) {
            throw new PortalException((Throwable)ue);
        }
    }

    public void checkInExtRepositoryFileEntry(String extRepositoryFileEntryKey, boolean createMajorVersion, String changeLog) throws PortalException {
        try {
            String url = this._sharepointURLHelper.getCheckInFileURL(extRepositoryFileEntryKey, createMajorVersion, changeLog);
            this._post(url);
        }
        catch (PrincipalException pe) {
            String message = pe.getMessage();
            if (message == null || !message.endsWith("423 Locked")) {
                throw pe;
            }
        }
        catch (UnirestException ue) {
            throw new PortalException((Throwable)ue);
        }
    }

    public ExtRepositoryFileEntry checkOutExtRepositoryFileEntry(String extRepositoryFileEntryKey) throws PortalException {
        try {
            String url = this._sharepointURLHelper.getCheckOutFileURL(extRepositoryFileEntryKey);
            this._post(url);
            return (ExtRepositoryFileEntry)this.getExtRepositoryObject(ExtRepositoryObjectType.FILE, extRepositoryFileEntryKey);
        }
        catch (PrincipalException pe) {
            String message = pe.getMessage();
            if (message != null && message.endsWith("423 Locked")) {
                return (ExtRepositoryFileEntry)this.getExtRepositoryObject(ExtRepositoryObjectType.FILE, extRepositoryFileEntryKey);
            }
            throw pe;
        }
        catch (UnirestException ue) {
            throw new PortalException((Throwable)ue);
        }
    }

    public <T extends ExtRepositoryObject> T copyExtRepositoryObject(ExtRepositoryObjectType<T> extRepositoryObjectType, String extRepositoryFileEntryKey, String newExtRepositoryFolderKey, String newTitle) throws PortalException {
        try {
            if (extRepositoryObjectType != ExtRepositoryObjectType.FILE) {
                throw new UnsupportedOperationException();
            }
            String url = this._sharepointURLHelper.getCopyFileURL(extRepositoryFileEntryKey, newExtRepositoryFolderKey, newTitle);
            this._post(url);
            return this.getExtRepositoryObject(extRepositoryObjectType, newExtRepositoryFolderKey + "/" + newTitle);
        }
        catch (UnirestException ue) {
            throw new PortalException((Throwable)ue);
        }
    }

    public void deleteExtRepositoryObject(ExtRepositoryObjectType<? extends ExtRepositoryObject> extRepositoryObjectType, String extRepositoryObjectKey) throws PortalException {
        try {
            String url = this._sharepointURLHelper.getDeleteObjectURL(extRepositoryObjectType, extRepositoryObjectKey);
            this._delete(url);
        }
        catch (UnirestException ue) {
            throw new PortalException((Throwable)ue);
        }
    }

    public String getAuthType() {
        return "userId";
    }

    public InputStream getContentStream(ExtRepositoryFileEntry extRepositoryFileEntry) throws PortalException {
        try {
            return this._getInputStream((SharepointModel)extRepositoryFileEntry);
        }
        catch (UnirestException ue) {
            throw new PortalException((Throwable)ue);
        }
    }

    public InputStream getContentStream(ExtRepositoryFileVersion extRepositoryFileVersion) throws PortalException {
        try {
            return this._getInputStream((SharepointModel)extRepositoryFileVersion);
        }
        catch (UnirestException ue) {
            throw new PortalException((Throwable)ue);
        }
    }

    public ExtRepositoryFileVersion getExtRepositoryFileVersion(ExtRepositoryFileEntry extRepositoryFileEntry, String version) throws PortalException {
        List<ExtRepositoryFileVersion> extRepositoryFileVersions = this.getExtRepositoryFileVersions(extRepositoryFileEntry);
        for (ExtRepositoryFileVersion extRepositoryFileVersion : extRepositoryFileVersions) {
            if (!version.equals(extRepositoryFileVersion.getVersion())) continue;
            return extRepositoryFileVersion;
        }
        return null;
    }

    public ExtRepositoryFileVersionDescriptor getExtRepositoryFileVersionDescriptor(String extRepositoryFileVersionKey) {
        String[] parts = extRepositoryFileVersionKey.split(":");
        return new ExtRepositoryFileVersionDescriptor(parts[0], parts[1]);
    }

    public List<ExtRepositoryFileVersion> getExtRepositoryFileVersions(ExtRepositoryFileEntry extRepositoryFileEntry) throws PortalException {
        try {
            String url = this._sharepointURLHelper.getFileVersionsURL(extRepositoryFileEntry);
            JSONObject jsonObject = this._getJSONObject(url);
            return this._sharepointServerResponseConverter.getExtRepositoryFileVersions((SharepointFileEntry)extRepositoryFileEntry, jsonObject);
        }
        catch (UnirestException ue) {
            throw new PortalException((Throwable)ue);
        }
    }

    public <T extends ExtRepositoryObject> T getExtRepositoryObject(ExtRepositoryObjectType<T> extRepositoryObjectType, String extRepositoryObjectKey) throws PortalException {
        try {
            String url = this._sharepointURLHelper.getObjectURL(extRepositoryObjectType, extRepositoryObjectKey);
            JSONObject jsonObject = this._getJSONObject(url);
            return this._sharepointServerResponseConverter.getExtRepositoryObject(extRepositoryObjectType, jsonObject);
        }
        catch (UnirestException ue) {
            throw new PortalException((Throwable)ue);
        }
    }

    public <T extends ExtRepositoryObject> T getExtRepositoryObject(ExtRepositoryObjectType<T> extRepositoryObjectType, String extRepositoryFolderKey, String title) throws PortalException {
        if (extRepositoryObjectType == ExtRepositoryObjectType.OBJECT) {
            throw new UnsupportedOperationException();
        }
        List<T> extRepositoryObjects = this.getExtRepositoryObjects(extRepositoryObjectType, extRepositoryFolderKey);
        if (extRepositoryObjectType == ExtRepositoryObjectType.FILE) {
            for (ExtRepositoryFileEntry extRepositoryFileEntry : extRepositoryObjects) {
                if (!title.equals(extRepositoryFileEntry.getTitle())) continue;
                return (T)extRepositoryFileEntry;
            }
            return null;
        }
        for (ExtRepositoryFolder extRepositoryFolder : extRepositoryObjects) {
            if (!title.equals(extRepositoryFolder.getName())) continue;
            return (T)extRepositoryFolder;
        }
        return null;
    }

    public <T extends ExtRepositoryObject> List<T> getExtRepositoryObjects(ExtRepositoryObjectType<T> extRepositoryObjectType, String extRepositoryFolderKey) throws PortalException {
        try {
            if (extRepositoryObjectType == ExtRepositoryObjectType.FILE) {
                return this._getExtRepositoryFileEntries(extRepositoryFolderKey);
            }
            if (extRepositoryObjectType == ExtRepositoryObjectType.FOLDER) {
                return this._getExtRepositoryFolders(extRepositoryFolderKey);
            }
            List<T> extRepositoryFileEntries = this._getExtRepositoryFileEntries(extRepositoryFolderKey);
            List<T> extRepositoryFolders = this._getExtRepositoryFolders(extRepositoryFolderKey);
            ArrayList<T> extRepositoryObjects = new ArrayList<T>(extRepositoryFileEntries.size() + extRepositoryFolders.size());
            extRepositoryObjects.addAll(extRepositoryFileEntries);
            extRepositoryObjects.addAll(extRepositoryFolders);
            return extRepositoryObjects;
        }
        catch (UnirestException ue) {
            throw new PortalException((Throwable)ue);
        }
    }

    public int getExtRepositoryObjectsCount(ExtRepositoryObjectType<? extends ExtRepositoryObject> extRepositoryObjectType, String extRepositoryFolderKey) throws PortalException {
        try {
            String url = this._sharepointURLHelper.getObjectsCountURL(extRepositoryObjectType, extRepositoryFolderKey);
            JSONObject jsonObject = this._getJSONObject(url);
            return this._sharepointServerResponseConverter.getExtRepositoryObjectsCount(jsonObject);
        }
        catch (JSONException | UnirestException e) {
            throw new PortalException(e);
        }
    }

    public ExtRepositoryFolder getExtRepositoryParentFolder(ExtRepositoryObject extRepositoryObject) throws PortalException {
        String extRepositoryModelKey = extRepositoryObject.getExtRepositoryModelKey();
        if (extRepositoryModelKey.equals(this._rootFolder.getExtRepositoryModelKey())) {
            return null;
        }
        int pos = extRepositoryModelKey.lastIndexOf(47);
        String parentFolderPath = extRepositoryModelKey.substring(0, pos);
        if (parentFolderPath.equals(this._libraryPath) || Validator.isNull((String)parentFolderPath)) {
            return this._rootFolder;
        }
        return (ExtRepositoryFolder)this.getExtRepositoryObject(ExtRepositoryObjectType.FOLDER, parentFolderPath);
    }

    public String getLiferayLogin(String extRepositoryLogin) {
        return String.valueOf(PrincipalThreadLocal.getUserId());
    }

    public String getRootFolderKey() throws PortalException {
        return this._libraryPath;
    }

    public List<String> getSubfolderKeys(String extRepositoryFolderKey, boolean recurse) throws PortalException {
        if (!recurse) {
            List extRepositoryObjects = this.getExtRepositoryObjects(ExtRepositoryObjectType.FOLDER, extRepositoryFolderKey);
            Stream extRepositoryFolderStream = extRepositoryObjects.stream();
            return extRepositoryFolderStream.map(ExtRepositoryModel::getExtRepositoryModelKey).collect(Collectors.toList());
        }
        ArrayList<String> subfolderKeys = new ArrayList<String>();
        this._collectSubfolderKeys(extRepositoryFolderKey, subfolderKeys);
        return subfolderKeys;
    }

    public String[] getSupportedConfigurations() {
        throw new UnsupportedOperationException();
    }

    public String[][] getSupportedParameters() {
        throw new UnsupportedOperationException();
    }

    public void initRepository(UnicodeProperties typeSettingsProperties, CredentialsProvider credentialsProvider) throws PortalException {
        this._libraryPath = this._strip(GetterUtil.getString((String)typeSettingsProperties.getProperty("library-path")));
        this._rootFolder = new SharepointRootFolder(this._libraryPath);
        this._siteAbsoluteURL = this._strip(GetterUtil.getString((String)typeSettingsProperties.getProperty("site-absolute-url"), (String)"-"));
        this._sharepointURLHelper = new SharepointURLHelper(this._siteAbsoluteURL, this._sharepointSearchConfiguration.sharepointResultsSourceId());
        this._sharepointServerResponseConverter = new SharepointServerResponseConverter(this._sharepointURLHelper, this, this._siteAbsoluteURL, this._libraryPath);
    }

    public <T extends ExtRepositoryObject> T moveExtRepositoryObject(ExtRepositoryObjectType<T> extRepositoryObjectType, String extRepositoryObjectKey, String newExtRepositoryFolderKey, String newTitle) throws PortalException {
        if (extRepositoryObjectType != ExtRepositoryObjectType.FILE) {
            ExtRepositoryFolder extRepositoryFolder = this._copyExtRepositoryFolder(extRepositoryObjectKey, newExtRepositoryFolderKey, newTitle);
            this.deleteExtRepositoryObject((ExtRepositoryObjectType<? extends ExtRepositoryObject>)ExtRepositoryObjectType.FOLDER, extRepositoryObjectKey);
            return (T)extRepositoryFolder;
        }
        try {
            this._validateExtension(extRepositoryObjectKey, newTitle);
            String url = this._sharepointURLHelper.getMoveFileURL(extRepositoryObjectKey, newExtRepositoryFolderKey, newTitle);
            this._post(url);
            return this.getExtRepositoryObject(extRepositoryObjectType, newExtRepositoryFolderKey + "/" + newTitle);
        }
        catch (UnirestException ue) {
            throw new PortalException((Throwable)ue);
        }
    }

    public List<ExtRepositorySearchResult<?>> search(SearchContext searchContext, Query query, ExtRepositoryQueryMapper extRepositoryQueryMapper) throws PortalException {
        try {
            KQLQueryVisitor queryVisitor = new KQLQueryVisitor(extRepositoryQueryMapper, this._siteAbsoluteURL);
            KQLQuery kqlQuery = (KQLQuery)query.accept((QueryVisitor)queryVisitor);
            String url = this._sharepointURLHelper.getSearchURL(kqlQuery.toString(), searchContext.getStart(), searchContext.getEnd());
            JSONObject jsonObject = this._getJSONObject(url);
            return this._sharepointServerResponseConverter.getSearchResults(jsonObject);
        }
        catch (UnirestException ue) {
            throw new PortalException((Throwable)ue);
        }
    }

    public ExtRepositoryFileEntry updateExtRepositoryFileEntry(String extRepositoryFileEntryKey, String mimeType, InputStream inputStream) throws PortalException {
        try {
            String url = this._sharepointURLHelper.getUpdateFileURL(extRepositoryFileEntryKey);
            this._put(url, inputStream);
            return (ExtRepositoryFileEntry)this.getExtRepositoryObject(ExtRepositoryObjectType.FILE, extRepositoryFileEntryKey);
        }
        catch (UnirestException | IOException e) {
            throw new PortalException(e);
        }
    }

    private void _collectSubfolderKeys(String extRepositoryFolderKey, List<String> subfolderKeys) throws PortalException {
        List extRepositoryFolders = this.getExtRepositoryObjects(ExtRepositoryObjectType.FOLDER, extRepositoryFolderKey);
        for (ExtRepositoryFolder extRepositoryFolder : extRepositoryFolders) {
            String subfolderKey = extRepositoryFolder.getExtRepositoryModelKey();
            subfolderKeys.add(subfolderKey);
            this._collectSubfolderKeys(subfolderKey, subfolderKeys);
        }
    }

    private ExtRepositoryFolder _copyExtRepositoryFolder(String extRepositoryFolderKey, String newExtRepositoryFolderKey, String newTitle) throws PortalException {
        ExtRepositoryFolder originalExtRepositoryFolder = (ExtRepositoryFolder)this.getExtRepositoryObject(ExtRepositoryObjectType.FOLDER, extRepositoryFolderKey);
        if (Validator.isNull((String)newTitle)) {
            newTitle = originalExtRepositoryFolder.getName();
        }
        ExtRepositoryFolder newExtRepositoryFolder = this.addExtRepositoryFolder(newExtRepositoryFolderKey, newTitle, originalExtRepositoryFolder.getDescription());
        List extRepositoryFolders = this.getExtRepositoryObjects(ExtRepositoryObjectType.FOLDER, originalExtRepositoryFolder.getExtRepositoryModelKey());
        for (ExtRepositoryFolder extRepositoryFolder : extRepositoryFolders) {
            this._copyExtRepositoryFolder(extRepositoryFolder.getExtRepositoryModelKey(), newExtRepositoryFolder.getExtRepositoryModelKey(), null);
        }
        List extRepositoryFileEntries = this.getExtRepositoryObjects(ExtRepositoryObjectType.FILE, originalExtRepositoryFolder.getExtRepositoryModelKey());
        for (ExtRepositoryFileEntry extRepositoryFileEntry : extRepositoryFileEntries) {
            this.copyExtRepositoryObject(ExtRepositoryObjectType.FILE, extRepositoryFileEntry.getExtRepositoryModelKey(), newExtRepositoryFolder.getExtRepositoryModelKey(), extRepositoryFileEntry.getTitle());
        }
        return newExtRepositoryFolder;
    }

    private void _delete(String url) throws PortalException, UnirestException {
        HttpRequestWithBody httpRequestWithBody = Unirest.delete((String)url);
        httpRequestWithBody.header("Authorization", "Bearer " + this._getAccessToken());
        HttpResponse httpResponse = httpRequestWithBody.asBinary();
        if (httpResponse.getStatus() >= 300) {
            throw new PrincipalException(String.format("Unable to delete %s: %d %s", url, httpResponse.getStatus(), httpResponse.getStatusText()));
        }
    }

    private String _getAccessToken() throws PortalException {
        Token token = this._tokenStore.get(this._sharepointRepositoryConfiguration.name(), PrincipalThreadLocal.getUserId());
        if (token == null || token.isExpired()) {
            throw new PrincipalException();
        }
        return token.getAccessToken();
    }

    private <T extends ExtRepositoryObject> List<T> _getExtRepositoryFileEntries(String extRepositoryFolderKey) throws PortalException, UnirestException {
        String url = this._sharepointURLHelper.getFilesURL(extRepositoryFolderKey);
        JSONObject jsonObject = this._getJSONObject(url);
        return this._sharepointServerResponseConverter.getExtRepositoryFileEntries(jsonObject);
    }

    private <T extends ExtRepositoryObject> List<T> _getExtRepositoryFolders(String extRepositoryFolderKey) throws PortalException, UnirestException {
        String url = this._sharepointURLHelper.getFoldersURL(extRepositoryFolderKey);
        JSONObject jsonObject = this._getJSONObject(url);
        return this._sharepointServerResponseConverter.getExtRepositoryFolders(jsonObject);
    }

    private InputStream _getInputStream(SharepointModel sharepointModel) throws PortalException, UnirestException {
        return this._getInputStream(sharepointModel.getCanonicalContentURL());
    }

    private InputStream _getInputStream(String url) throws PortalException, UnirestException {
        GetRequest getRequest = Unirest.get((String)url);
        getRequest.header("Authorization", "Bearer " + this._getAccessToken());
        HttpResponse httpResponse = getRequest.asBinary();
        if (httpResponse.getStatus() >= 300) {
            throw new PrincipalException(String.format("Unable to get %s: %d %s", url, httpResponse.getStatus(), httpResponse.getStatusText()));
        }
        return (InputStream)httpResponse.getBody();
    }

    private JSONObject _getJSONObject(String url) throws PortalException, UnirestException {
        GetRequest getRequest = Unirest.get((String)url);
        getRequest.header("Accept", "application/json;odata=verbose");
        getRequest.header("Authorization", "Bearer " + this._getAccessToken());
        HttpResponse httpResponse = getRequest.asString();
        if (httpResponse.getStatus() >= 300) {
            throw new PrincipalException(String.format("Unable to get %s: %d %s", url, httpResponse.getStatus(), httpResponse.getStatusText()));
        }
        return JSONFactoryUtil.createJSONObject((String)((String)httpResponse.getBody()));
    }

    private void _post(String url) throws PortalException, UnirestException {
        HttpRequestWithBody httpRequestWithBody = Unirest.post((String)url);
        httpRequestWithBody.header("Authorization", "Bearer " + this._getAccessToken());
        HttpResponse httpResponse = httpRequestWithBody.asBinary();
        if (httpResponse.getStatus() >= 300) {
            throw new PrincipalException(String.format("Unable to post to %s: %d %s", url, httpResponse.getStatus(), httpResponse.getStatusText()));
        }
    }

    private JSONObject _post(String url, InputStream inputStream) throws IOException, PortalException, UnirestException {
        HttpRequestWithBody httpRequestWithBody = Unirest.post((String)url);
        httpRequestWithBody.body(FileUtil.getBytes((InputStream)inputStream));
        httpRequestWithBody.header("accept", "application/json; odata=verbose");
        httpRequestWithBody.header("Authorization", "Bearer " + this._getAccessToken());
        HttpResponse httpResponse = httpRequestWithBody.asString();
        if (httpResponse.getStatus() >= 300) {
            throw new PrincipalException(String.format("Unable to post to %s: %d %s", url, httpResponse.getStatus(), httpResponse.getStatusText()));
        }
        return JSONFactoryUtil.createJSONObject((String)((String)httpResponse.getBody()));
    }

    private JSONObject _post(String url, JSONObject jsonObject) throws IOException, PortalException, UnirestException {
        HttpRequestWithBody httpRequestWithBody = Unirest.post((String)url);
        httpRequestWithBody.header("accept", "application/json; odata=verbose");
        httpRequestWithBody.header("Authorization", "Bearer " + this._getAccessToken());
        httpRequestWithBody.header("Content-Type", "application/json; odata=verbose");
        httpRequestWithBody.body(jsonObject.toJSONString());
        HttpResponse httpResponse = httpRequestWithBody.asString();
        if (httpResponse.getStatus() >= 300) {
            throw new PrincipalException(String.format("Unable to post to %s: %d %s", url, httpResponse.getStatus(), httpResponse.getStatusText()));
        }
        return JSONFactoryUtil.createJSONObject((String)((String)httpResponse.getBody()));
    }

    private void _put(String url, InputStream inputStream) throws IOException, PortalException, UnirestException {
        HttpRequestWithBody httpRequestWithBody = Unirest.put((String)url);
        httpRequestWithBody.header("accept", "application/json; odata=verbose");
        httpRequestWithBody.header("Authorization", "Bearer " + this._getAccessToken());
        httpRequestWithBody.body(FileUtil.getBytes((InputStream)inputStream));
        HttpResponse httpResponse = httpRequestWithBody.asString();
        if (httpResponse.getStatus() >= 300) {
            throw new PrincipalException(String.format("Unable to post to %s: %d %s", url, httpResponse.getStatus(), httpResponse.getStatusText()));
        }
    }

    private String _strip(String s) {
        int j;
        int i = 0;
        while (s.charAt(i) == '/') {
            ++i;
        }
        for (j = s.length() - 1; j > i && s.charAt(j) == '/'; --j) {
        }
        if (i < j) {
            return s.substring(i, j + 1);
        }
        return s;
    }

    private void _validateExtension(String oldPath, String newPath) throws PortalException {
        String oldExtension = FileUtil.getExtension((String)oldPath);
        String newExtension = FileUtil.getExtension((String)newPath);
        if (!newExtension.equals(oldExtension)) {
            throw new SourceFileNameException("Sharepoint repository does not support changing the file extension");
        }
    }
}

