/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.sharepoint.rest.repository.internal.document.library.repository.external;

import com.liferay.document.library.repository.external.CredentialsProvider;
import com.liferay.document.library.repository.external.ExtRepository;
import com.liferay.document.library.repository.external.ExtRepositoryFileEntry;
import com.liferay.document.library.repository.external.ExtRepositoryFileVersion;
import com.liferay.document.library.repository.external.ExtRepositoryFileVersionDescriptor;
import com.liferay.document.library.repository.external.ExtRepositoryFolder;
import com.liferay.document.library.repository.external.ExtRepositoryObject;
import com.liferay.document.library.repository.external.ExtRepositoryObjectType;
import com.liferay.document.library.repository.external.ExtRepositorySearchResult;
import com.liferay.document.library.repository.external.search.ExtRepositoryQueryMapper;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.search.Query;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.util.AutoResetThreadLocal;
import com.liferay.portal.kernel.util.UnicodeProperties;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SharepointCachingExtRepository
implements ExtRepository {
    private static final ThreadLocal<Map<String, List<ExtRepositoryFileVersion>>> _extRepositoryFileVersionCache = new AutoResetThreadLocal("extRepositoryFileVersionCache", HashMap::new);
    private static final ThreadLocal<Map<String, ExtRepositoryObject>> _extRepositoryObjectCache = new AutoResetThreadLocal("extRepositoryObjectCache", HashMap::new);
    private static final ThreadLocal<Map<String, List<ExtRepositoryObject>>> _extRepositoryObjectsCache = new AutoResetThreadLocal("extRepositoryObjectsCache", HashMap::new);
    private static final ThreadLocal<Map<String, ExtRepositoryFolder>> _extRepositoryParentFolderCache = new AutoResetThreadLocal("extRepositoryParentFolderCache", HashMap::new);
    private final ExtRepository _extRepository;

    public SharepointCachingExtRepository(ExtRepository extRepository) {
        this._extRepository = extRepository;
    }

    public ExtRepositoryFileEntry addExtRepositoryFileEntry(String extRepositoryParentFolderKey, String mimeType, String title, String description, String changeLog, InputStream inputStream) throws PortalException {
        Map<String, List<ExtRepositoryObject>> extRepositoryObjectsCache = _extRepositoryObjectsCache.get();
        extRepositoryObjectsCache.remove(extRepositoryParentFolderKey);
        ExtRepositoryFileEntry extRepositoryFileEntry = this._extRepository.addExtRepositoryFileEntry(extRepositoryParentFolderKey, mimeType, title, description, changeLog, inputStream);
        Map<String, ExtRepositoryObject> extRepositoryObjectCache = _extRepositoryObjectCache.get();
        extRepositoryObjectCache.put(extRepositoryFileEntry.getExtRepositoryModelKey(), (ExtRepositoryObject)extRepositoryFileEntry);
        return extRepositoryFileEntry;
    }

    public ExtRepositoryFolder addExtRepositoryFolder(String extRepositoryParentFolderKey, String name, String description) throws PortalException {
        Map<String, List<ExtRepositoryObject>> extRepositoryObjectsCache = _extRepositoryObjectsCache.get();
        extRepositoryObjectsCache.remove(extRepositoryParentFolderKey);
        Map<String, ExtRepositoryObject> extRepositoryObjectCache = _extRepositoryObjectCache.get();
        ExtRepositoryFolder extRepositoryFolder = this._extRepository.addExtRepositoryFolder(extRepositoryParentFolderKey, name, description);
        extRepositoryObjectCache.put(extRepositoryFolder.getExtRepositoryModelKey(), (ExtRepositoryObject)extRepositoryFolder);
        return extRepositoryFolder;
    }

    public ExtRepositoryFileVersion cancelCheckOut(String extRepositoryFileEntryKey) throws PortalException {
        Map<String, ExtRepositoryObject> extRepositoryObjectCache = _extRepositoryObjectCache.get();
        extRepositoryObjectCache.remove(extRepositoryFileEntryKey);
        Map<String, List<ExtRepositoryFileVersion>> extRepositoryFileVersionCache = _extRepositoryFileVersionCache.get();
        extRepositoryFileVersionCache.remove(extRepositoryFileEntryKey);
        return this._extRepository.cancelCheckOut(extRepositoryFileEntryKey);
    }

    public void checkInExtRepositoryFileEntry(String extRepositoryFileEntryKey, boolean createMajorVersion, String changeLog) throws PortalException {
        Map<String, ExtRepositoryObject> extRepositoryObjectCache = _extRepositoryObjectCache.get();
        extRepositoryObjectCache.remove(extRepositoryFileEntryKey);
        Map<String, List<ExtRepositoryFileVersion>> extRepositoryFileVersionCache = _extRepositoryFileVersionCache.get();
        extRepositoryFileVersionCache.remove(extRepositoryFileEntryKey);
        this._extRepository.checkInExtRepositoryFileEntry(extRepositoryFileEntryKey, createMajorVersion, changeLog);
    }

    public ExtRepositoryFileEntry checkOutExtRepositoryFileEntry(String extRepositoryFileEntryKey) throws PortalException {
        Map<String, ExtRepositoryObject> extRepositoryObjectCache = _extRepositoryObjectCache.get();
        extRepositoryObjectCache.remove(extRepositoryFileEntryKey);
        Map<String, List<ExtRepositoryFileVersion>> extRepositoryFileVersionCache = _extRepositoryFileVersionCache.get();
        extRepositoryFileVersionCache.remove(extRepositoryFileEntryKey);
        return this._extRepository.checkOutExtRepositoryFileEntry(extRepositoryFileEntryKey);
    }

    public <T extends ExtRepositoryObject> T copyExtRepositoryObject(ExtRepositoryObjectType<T> extRepositoryObjectType, String extRepositoryFileEntryKey, String newExtRepositoryFolderKey, String newTitle) throws PortalException {
        return (T)this._extRepository.copyExtRepositoryObject(extRepositoryObjectType, extRepositoryFileEntryKey, newExtRepositoryFolderKey, newTitle);
    }

    public void deleteExtRepositoryObject(ExtRepositoryObjectType<? extends ExtRepositoryObject> extRepositoryObjectType, String extRepositoryObjectKey) throws PortalException {
        Map<String, ExtRepositoryObject> extRepositoryObjectCache = _extRepositoryObjectCache.get();
        extRepositoryObjectCache.remove(extRepositoryObjectKey);
        Map<String, List<ExtRepositoryObject>> extRepositoryObjectsCache = _extRepositoryObjectsCache.get();
        extRepositoryObjectsCache.clear();
        Map<String, ExtRepositoryFolder> extRepositoryParentFolderCache = _extRepositoryParentFolderCache.get();
        extRepositoryParentFolderCache.remove(extRepositoryObjectKey);
        if (extRepositoryObjectType == ExtRepositoryObjectType.FILE) {
            Map<String, List<ExtRepositoryFileVersion>> extRepositoryFileVersionCache = _extRepositoryFileVersionCache.get();
            extRepositoryFileVersionCache.clear();
        }
        this._extRepository.deleteExtRepositoryObject(extRepositoryObjectType, extRepositoryObjectKey);
    }

    public String getAuthType() {
        return this._extRepository.getAuthType();
    }

    public InputStream getContentStream(ExtRepositoryFileEntry extRepositoryFileEntry) throws PortalException {
        return this._extRepository.getContentStream(extRepositoryFileEntry);
    }

    public InputStream getContentStream(ExtRepositoryFileVersion extRepositoryFileVersion) throws PortalException {
        return this._extRepository.getContentStream(extRepositoryFileVersion);
    }

    public ExtRepositoryFileVersion getExtRepositoryFileVersion(ExtRepositoryFileEntry extRepositoryFileEntry, String version) throws PortalException {
        return this._extRepository.getExtRepositoryFileVersion(extRepositoryFileEntry, version);
    }

    public ExtRepositoryFileVersionDescriptor getExtRepositoryFileVersionDescriptor(String extRepositoryFileVersionKey) {
        return this._extRepository.getExtRepositoryFileVersionDescriptor(extRepositoryFileVersionKey);
    }

    public List<ExtRepositoryFileVersion> getExtRepositoryFileVersions(ExtRepositoryFileEntry extRepositoryFileEntry) throws PortalException {
        String extRepositoryModelKey;
        Map<String, List<ExtRepositoryFileVersion>> extRepositoryFileVersionCache = _extRepositoryFileVersionCache.get();
        if (extRepositoryFileVersionCache.containsKey(extRepositoryModelKey = extRepositoryFileEntry.getExtRepositoryModelKey())) {
            return extRepositoryFileVersionCache.get(extRepositoryModelKey);
        }
        List extRepositoryFileVersions = this._extRepository.getExtRepositoryFileVersions(extRepositoryFileEntry);
        extRepositoryFileVersionCache.put(extRepositoryModelKey, extRepositoryFileVersions);
        return extRepositoryFileVersions;
    }

    public <T extends ExtRepositoryObject> T getExtRepositoryObject(ExtRepositoryObjectType<T> extRepositoryObjectType, String extRepositoryObjectKey) throws PortalException {
        Map<String, ExtRepositoryObject> extRepositoryObjectCache = _extRepositoryObjectCache.get();
        if (extRepositoryObjectCache.containsKey(extRepositoryObjectKey)) {
            return (T)extRepositoryObjectCache.get(extRepositoryObjectKey);
        }
        ExtRepositoryObject extRepositoryObject = this._extRepository.getExtRepositoryObject(extRepositoryObjectType, extRepositoryObjectKey);
        extRepositoryObjectCache.put(extRepositoryObjectKey, extRepositoryObject);
        return (T)extRepositoryObject;
    }

    public <T extends ExtRepositoryObject> T getExtRepositoryObject(ExtRepositoryObjectType<T> extRepositoryObjectType, String extRepositoryFolderKey, String title) throws PortalException {
        return (T)this._extRepository.getExtRepositoryObject(extRepositoryObjectType, extRepositoryFolderKey, title);
    }

    public <T extends ExtRepositoryObject> List<T> getExtRepositoryObjects(ExtRepositoryObjectType<T> extRepositoryObjectType, String extRepositoryFolderKey) throws PortalException {
        Map<String, List<ExtRepositoryObject>> extRepositoryObjectsCache = _extRepositoryObjectsCache.get();
        if (extRepositoryObjectsCache.containsKey(extRepositoryFolderKey)) {
            return extRepositoryObjectsCache.get(extRepositoryFolderKey);
        }
        List extRepositoryObjects = this._extRepository.getExtRepositoryObjects(extRepositoryObjectType, extRepositoryFolderKey);
        Map<String, ExtRepositoryObject> extRepositoryObjectCache = _extRepositoryObjectCache.get();
        extRepositoryObjects.forEach(extRepositoryObject -> extRepositoryObjectCache.put(extRepositoryObject.getExtRepositoryModelKey(), (ExtRepositoryObject)extRepositoryObject));
        extRepositoryObjectsCache.put(extRepositoryFolderKey, extRepositoryObjects);
        return extRepositoryObjects;
    }

    public int getExtRepositoryObjectsCount(ExtRepositoryObjectType<? extends ExtRepositoryObject> extRepositoryObjectType, String extRepositoryFolderKey) throws PortalException {
        return this._extRepository.getExtRepositoryObjectsCount(extRepositoryObjectType, extRepositoryFolderKey);
    }

    public ExtRepositoryFolder getExtRepositoryParentFolder(ExtRepositoryObject extRepositoryObject) throws PortalException {
        Map<String, ExtRepositoryFolder> extRepositoryParentFolderCache = _extRepositoryParentFolderCache.get();
        if (extRepositoryParentFolderCache.containsKey(extRepositoryObject.getExtRepositoryModelKey())) {
            return extRepositoryParentFolderCache.get(extRepositoryObject.getExtRepositoryModelKey());
        }
        ExtRepositoryFolder extRepositoryParentFolder = this._extRepository.getExtRepositoryParentFolder(extRepositoryObject);
        extRepositoryParentFolderCache.put(extRepositoryObject.getExtRepositoryModelKey(), extRepositoryParentFolder);
        return extRepositoryParentFolder;
    }

    public String getLiferayLogin(String extRepositoryLogin) {
        return this._extRepository.getLiferayLogin(extRepositoryLogin);
    }

    public String getRootFolderKey() throws PortalException {
        return this._extRepository.getRootFolderKey();
    }

    public List<String> getSubfolderKeys(String extRepositoryFolderKey, boolean recurse) throws PortalException {
        return this._extRepository.getSubfolderKeys(extRepositoryFolderKey, recurse);
    }

    public String[] getSupportedConfigurations() {
        return this._extRepository.getSupportedConfigurations();
    }

    public String[][] getSupportedParameters() {
        return this._extRepository.getSupportedParameters();
    }

    public void initRepository(UnicodeProperties typeSettingsProperties, CredentialsProvider credentialsProvider) throws PortalException {
        this._extRepository.initRepository(typeSettingsProperties, credentialsProvider);
    }

    public <T extends ExtRepositoryObject> T moveExtRepositoryObject(ExtRepositoryObjectType<T> extRepositoryObjectType, String extRepositoryObjectKey, String newExtRepositoryFolderKey, String newTitle) throws PortalException {
        Map<String, ExtRepositoryFolder> extRepositoryParentFolderCache = _extRepositoryParentFolderCache.get();
        extRepositoryParentFolderCache.remove(extRepositoryObjectKey);
        Map<String, ExtRepositoryObject> extRepositoryObjectCache = _extRepositoryObjectCache.get();
        extRepositoryObjectCache.remove(extRepositoryObjectKey);
        Map<String, List<ExtRepositoryObject>> extRepositoryObjectsCache = _extRepositoryObjectsCache.get();
        extRepositoryObjectsCache.remove(extRepositoryObjectKey);
        Map<String, List<ExtRepositoryFileVersion>> extRepositoryFileVersionCache = _extRepositoryFileVersionCache.get();
        extRepositoryFileVersionCache.remove(extRepositoryObjectKey);
        return (T)this._extRepository.moveExtRepositoryObject(extRepositoryObjectType, extRepositoryObjectKey, newExtRepositoryFolderKey, newTitle);
    }

    public List<ExtRepositorySearchResult<?>> search(SearchContext searchContext, Query query, ExtRepositoryQueryMapper extRepositoryQueryMapper) throws PortalException {
        return this._extRepository.search(searchContext, query, extRepositoryQueryMapper);
    }

    public ExtRepositoryFileEntry updateExtRepositoryFileEntry(String extRepositoryFileEntryKey, String mimeType, InputStream inputStream) throws PortalException {
        ExtRepositoryFileEntry extRepositoryFileEntry = this._extRepository.updateExtRepositoryFileEntry(extRepositoryFileEntryKey, mimeType, inputStream);
        Map<String, ExtRepositoryObject> extRepositoryObjectCache = _extRepositoryObjectCache.get();
        extRepositoryObjectCache.put(extRepositoryFileEntryKey, (ExtRepositoryObject)extRepositoryFileEntry);
        Map<String, List<ExtRepositoryObject>> extRepositoryObjectsCache = _extRepositoryObjectsCache.get();
        extRepositoryObjectsCache.clear();
        Map<String, List<ExtRepositoryFileVersion>> extRepositoryFileVersionCache = _extRepositoryFileVersionCache.get();
        extRepositoryFileVersionCache.remove(extRepositoryFileEntryKey);
        return extRepositoryFileEntry;
    }
}

