/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.sharepoint.rest.repository.internal.document.library.repository.authorization.oauth2;

import com.liferay.document.library.repository.authorization.capability.AuthorizationException;
import com.liferay.document.library.repository.authorization.oauth2.Token;
import com.liferay.portal.kernel.json.JSONException;
import com.liferay.sharepoint.rest.repository.internal.configuration.SharepointRepositoryConfiguration;
import com.liferay.sharepoint.rest.repository.internal.document.library.repository.authorization.oauth2.SharepointRepositoryToken;
import com.mashape.unirest.http.HttpResponse;
import com.mashape.unirest.http.Unirest;
import com.mashape.unirest.http.exceptions.UnirestException;
import com.mashape.unirest.request.HttpRequestWithBody;
import com.mashape.unirest.request.body.MultipartBody;
import java.io.IOException;

public class SharepointRepositoryTokenBroker {
    private final SharepointRepositoryConfiguration _sharepointRepositoryConfiguration;

    public SharepointRepositoryTokenBroker(SharepointRepositoryConfiguration sharepointRepositoryConfiguration) {
        this._sharepointRepositoryConfiguration = sharepointRepositoryConfiguration;
    }

    public Token refreshAccessToken(Token token) throws AuthorizationException, IOException {
        try {
            HttpRequestWithBody httpRequestWithBody = Unirest.post((String)this._sharepointRepositoryConfiguration.authorizationTokenEndpoint());
            MultipartBody multipartBody = httpRequestWithBody.field("client_id", (Object)(this._sharepointRepositoryConfiguration.clientId() + "@" + this._sharepointRepositoryConfiguration.tenantId()));
            multipartBody = multipartBody.field("client_secret", this._sharepointRepositoryConfiguration.clientSecret());
            multipartBody = multipartBody.field("refresh_token", token.getRefreshToken());
            multipartBody = multipartBody.field("grant_type", "refresh_token");
            multipartBody = multipartBody.field("resource", this._sharepointRepositoryConfiguration.resource());
            HttpResponse httpResponse = multipartBody.asString();
            return SharepointRepositoryToken.newInstance((String)httpResponse.getBody(), token);
        }
        catch (JSONException | UnirestException e) {
            throw new IOException(e);
        }
    }

    public Token requestAccessToken(String code, String redirectURL) throws AuthorizationException, IOException {
        try {
            HttpRequestWithBody httpRequestWithBody = Unirest.post((String)this._sharepointRepositoryConfiguration.authorizationTokenEndpoint());
            MultipartBody multipartBody = httpRequestWithBody.field("client_id", (Object)(this._sharepointRepositoryConfiguration.clientId() + "@" + this._sharepointRepositoryConfiguration.tenantId()));
            multipartBody = multipartBody.field("client_secret", this._sharepointRepositoryConfiguration.clientSecret());
            multipartBody = multipartBody.field("code", code);
            multipartBody = multipartBody.field("grant_type", "authorization_code");
            multipartBody = multipartBody.field("redirect_uri", redirectURL);
            multipartBody = multipartBody.field("resource", this._sharepointRepositoryConfiguration.resource());
            HttpResponse httpResponse = multipartBody.asString();
            return SharepointRepositoryToken.newInstance((String)httpResponse.getBody());
        }
        catch (JSONException | UnirestException e) {
            throw new IOException(e);
        }
    }
}

