/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.sharepoint.rest.repository.internal.document.library.repository.authorization.oauth2;

import com.liferay.document.library.repository.authorization.oauth2.OAuth2AuthorizationException;
import com.liferay.document.library.repository.authorization.oauth2.Token;
import com.liferay.portal.kernel.json.JSONException;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.util.DateUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.sharepoint.rest.oauth2.model.SharepointOAuth2TokenEntry;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Date;

public class SharepointRepositoryToken
implements Token {
    private final String _accessToken;
    private final Date _expirationDate;
    private final String _refreshToken;

    public static final Token newInstance(SharepointOAuth2TokenEntry sharepointOAuth2TokenEntry) {
        if (sharepointOAuth2TokenEntry == null) {
            return null;
        }
        return new SharepointRepositoryToken(sharepointOAuth2TokenEntry.getAccessToken(), sharepointOAuth2TokenEntry.getRefreshToken(), sharepointOAuth2TokenEntry.getExpirationDate());
    }

    public static final Token newInstance(String json) throws JSONException, OAuth2AuthorizationException {
        return SharepointRepositoryToken.newInstance(json, null);
    }

    public static final Token newInstance(String json, Token token) throws JSONException, OAuth2AuthorizationException {
        JSONObject jsonObject = JSONFactoryUtil.createJSONObject((String)json);
        if (jsonObject.has("error")) {
            throw OAuth2AuthorizationException.getErrorException((String)jsonObject.getString("error"), (String)jsonObject.getString("description"));
        }
        String accessToken = jsonObject.getString("access_token");
        if (Validator.isNull((String)accessToken)) {
            throw new IllegalArgumentException(String.format("Invalid access token: %s", json));
        }
        String refreshToken = jsonObject.getString("refresh_token");
        if (token != null && Validator.isNull((String)refreshToken)) {
            refreshToken = token.getRefreshToken();
        }
        Instant instant = Instant.now();
        Date expirationDate = Date.from(instant.plus(jsonObject.getLong("expires_in"), ChronoUnit.SECONDS));
        return new SharepointRepositoryToken(accessToken, refreshToken, expirationDate);
    }

    public String getAccessToken() {
        return this._accessToken;
    }

    public Date getExpirationDate() {
        return this._expirationDate;
    }

    public String getRefreshToken() {
        return this._refreshToken;
    }

    public boolean isExpired() {
        return this._expirationDate.before(DateUtil.newDate());
    }

    private SharepointRepositoryToken(String accessToken, String refreshToken, Date expirationDate) {
        this._accessToken = accessToken;
        this._refreshToken = refreshToken;
        this._expirationDate = expirationDate;
    }
}

