/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.sharepoint.rest.repository.internal.document.library.repository.authorization.oauth2;

import com.liferay.document.library.repository.authorization.capability.AuthorizationException;
import com.liferay.document.library.repository.authorization.oauth2.OAuth2AuthorizationException;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import java.io.IOException;
import java.io.Serializable;
import javax.portlet.PortletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

public final class SharepointRepositoryRequestState
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final long _folderId;
    private final String _state;
    private final String _url;

    public static final SharepointRepositoryRequestState get(HttpServletRequest request) {
        HttpSession session = request.getSession();
        return (SharepointRepositoryRequestState)session.getAttribute(SharepointRepositoryRequestState.class.getName());
    }

    public static final void save(HttpServletRequest request, String state) {
        HttpSession session = request.getSession();
        PortletRequest portletRequest = (PortletRequest)request.getAttribute("javax.portlet.request");
        session.setAttribute(SharepointRepositoryRequestState.class.getName(), (Object)new SharepointRepositoryRequestState(ParamUtil.getLong((PortletRequest)portletRequest, (String)"folderId"), PortalUtil.getCurrentCompleteURL((HttpServletRequest)request), state));
    }

    public long getFolderId() {
        return this._folderId;
    }

    public void restore(HttpServletRequest request, HttpServletResponse response) throws IOException {
        HttpSession session = request.getSession();
        session.removeAttribute(SharepointRepositoryRequestState.class.getName());
        response.sendRedirect(this._url);
    }

    public void validate(String state) throws AuthorizationException {
        if (!state.equals(this._state)) {
            throw new OAuth2AuthorizationException.InvalidState(String.format("The Sharepoint server returned an invalid state %s that does not match the expected state %s", this._state, state));
        }
    }

    private SharepointRepositoryRequestState(long folderId, String url, String state) {
        this._folderId = folderId;
        this._url = url;
        this._state = state;
    }
}

