/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.sharepoint.rest.oauth2.service.persistence.impl;

import com.liferay.petra.sql.dsl.Table;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.configuration.Configuration;
import com.liferay.portal.kernel.dao.orm.Dialect;
import com.liferay.portal.kernel.dao.orm.EntityCache;
import com.liferay.portal.kernel.dao.orm.FinderCache;
import com.liferay.portal.kernel.dao.orm.FinderPath;
import com.liferay.portal.kernel.dao.orm.Query;
import com.liferay.portal.kernel.dao.orm.QueryPos;
import com.liferay.portal.kernel.dao.orm.QueryUtil;
import com.liferay.portal.kernel.dao.orm.Session;
import com.liferay.portal.kernel.dao.orm.SessionFactory;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.security.auth.CompanyThreadLocal;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ServiceContextThreadLocal;
import com.liferay.portal.kernel.service.persistence.BasePersistence;
import com.liferay.portal.kernel.service.persistence.impl.BasePersistenceImpl;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.PropsUtil;
import com.liferay.portal.kernel.util.ProxyUtil;
import com.liferay.sharepoint.rest.oauth2.exception.NoSuch2TokenEntryException;
import com.liferay.sharepoint.rest.oauth2.model.SharepointOAuth2TokenEntry;
import com.liferay.sharepoint.rest.oauth2.model.SharepointOAuth2TokenEntryTable;
import com.liferay.sharepoint.rest.oauth2.model.impl.SharepointOAuth2TokenEntryImpl;
import com.liferay.sharepoint.rest.oauth2.model.impl.SharepointOAuth2TokenEntryModelImpl;
import com.liferay.sharepoint.rest.oauth2.service.persistence.SharepointOAuth2TokenEntryPersistence;
import com.liferay.sharepoint.rest.oauth2.service.persistence.SharepointOAuth2TokenEntryUtil;
import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.sql.DataSource;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

@Component(service={SharepointOAuth2TokenEntryPersistence.class})
public class SharepointOAuth2TokenEntryPersistenceImpl
extends BasePersistenceImpl<SharepointOAuth2TokenEntry>
implements SharepointOAuth2TokenEntryPersistence {
    public static final String FINDER_CLASS_NAME_ENTITY = SharepointOAuth2TokenEntryImpl.class.getName();
    public static final String FINDER_CLASS_NAME_LIST_WITH_PAGINATION = FINDER_CLASS_NAME_ENTITY + ".List1";
    public static final String FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION = FINDER_CLASS_NAME_ENTITY + ".List2";
    private FinderPath _finderPathWithPaginationFindAll;
    private FinderPath _finderPathWithoutPaginationFindAll;
    private FinderPath _finderPathCountAll;
    private FinderPath _finderPathWithPaginationFindByUserId;
    private FinderPath _finderPathWithoutPaginationFindByUserId;
    private FinderPath _finderPathCountByUserId;
    private static final String _FINDER_COLUMN_USERID_USERID_2 = "sharepointOAuth2TokenEntry.userId = ?";
    private FinderPath _finderPathFetchByU_C;
    private static final String _FINDER_COLUMN_U_C_USERID_2 = "sharepointOAuth2TokenEntry.userId = ? AND ";
    private static final String _FINDER_COLUMN_U_C_CONFIGURATIONPID_2 = "sharepointOAuth2TokenEntry.configurationPid = ?";
    private static final String _FINDER_COLUMN_U_C_CONFIGURATIONPID_3 = "(sharepointOAuth2TokenEntry.configurationPid IS NULL OR sharepointOAuth2TokenEntry.configurationPid = '')";
    private int _valueObjectFinderCacheListThreshold;
    @Reference
    protected EntityCache entityCache;
    @Reference
    protected FinderCache finderCache;
    private static final String _SQL_SELECT_SHAREPOINTOAUTH2TOKENENTRY = "SELECT sharepointOAuth2TokenEntry FROM SharepointOAuth2TokenEntry sharepointOAuth2TokenEntry";
    private static final String _SQL_SELECT_SHAREPOINTOAUTH2TOKENENTRY_WHERE = "SELECT sharepointOAuth2TokenEntry FROM SharepointOAuth2TokenEntry sharepointOAuth2TokenEntry WHERE ";
    private static final String _SQL_COUNT_SHAREPOINTOAUTH2TOKENENTRY = "SELECT COUNT(sharepointOAuth2TokenEntry) FROM SharepointOAuth2TokenEntry sharepointOAuth2TokenEntry";
    private static final String _SQL_COUNT_SHAREPOINTOAUTH2TOKENENTRY_WHERE = "SELECT COUNT(sharepointOAuth2TokenEntry) FROM SharepointOAuth2TokenEntry sharepointOAuth2TokenEntry WHERE ";
    private static final String _ORDER_BY_ENTITY_ALIAS = "sharepointOAuth2TokenEntry.";
    private static final String _NO_SUCH_ENTITY_WITH_PRIMARY_KEY = "No SharepointOAuth2TokenEntry exists with the primary key ";
    private static final String _NO_SUCH_ENTITY_WITH_KEY = "No SharepointOAuth2TokenEntry exists with the key {";
    private static final Log _log = LogFactoryUtil.getLog(SharepointOAuth2TokenEntryPersistenceImpl.class);

    public List<SharepointOAuth2TokenEntry> findByUserId(long userId) {
        return this.findByUserId(userId, -1, -1, null);
    }

    public List<SharepointOAuth2TokenEntry> findByUserId(long userId, int start, int end) {
        return this.findByUserId(userId, start, end, null);
    }

    public List<SharepointOAuth2TokenEntry> findByUserId(long userId, int start, int end, OrderByComparator<SharepointOAuth2TokenEntry> orderByComparator) {
        return this.findByUserId(userId, start, end, orderByComparator, true);
    }

    public List<SharepointOAuth2TokenEntry> findByUserId(long userId, int start, int end, OrderByComparator<SharepointOAuth2TokenEntry> orderByComparator, boolean useFinderCache) {
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            if (useFinderCache) {
                finderPath = this._finderPathWithoutPaginationFindByUserId;
                finderArgs = new Object[]{userId};
            }
        } else if (useFinderCache) {
            finderPath = this._finderPathWithPaginationFindByUserId;
            finderArgs = new Object[]{userId, start, end, orderByComparator};
        }
        List list = null;
        if (useFinderCache && (list = (List)this.finderCache.getResult(finderPath, finderArgs, (BasePersistence)this)) != null && !list.isEmpty()) {
            for (SharepointOAuth2TokenEntry sharepointOAuth2TokenEntry : list) {
                if (userId == sharepointOAuth2TokenEntry.getUserId()) continue;
                list = null;
                break;
            }
        }
        if (list == null) {
            StringBundler sb = null;
            sb = orderByComparator != null ? new StringBundler(3 + orderByComparator.getOrderByFields().length * 2) : new StringBundler(3);
            sb.append(_SQL_SELECT_SHAREPOINTOAUTH2TOKENENTRY_WHERE);
            sb.append(_FINDER_COLUMN_USERID_USERID_2);
            if (orderByComparator != null) {
                this.appendOrderByComparator(sb, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
            } else {
                sb.append(" ORDER BY sharepointOAuth2TokenEntry.sharepointOAuth2TokenEntryId ASC");
            }
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                queryPos.add(userId);
                list = QueryUtil.list((Query)query, (Dialect)this.getDialect(), (int)start, (int)end);
                this.cacheResult(list);
                if (useFinderCache) {
                    this.finderCache.putResult(finderPath, finderArgs, (Object)list);
                }
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    public SharepointOAuth2TokenEntry findByUserId_First(long userId, OrderByComparator<SharepointOAuth2TokenEntry> orderByComparator) throws NoSuch2TokenEntryException {
        SharepointOAuth2TokenEntry sharepointOAuth2TokenEntry = this.fetchByUserId_First(userId, orderByComparator);
        if (sharepointOAuth2TokenEntry != null) {
            return sharepointOAuth2TokenEntry;
        }
        StringBundler sb = new StringBundler(4);
        sb.append(_NO_SUCH_ENTITY_WITH_KEY);
        sb.append("userId=");
        sb.append(userId);
        sb.append("}");
        throw new NoSuch2TokenEntryException(sb.toString());
    }

    public SharepointOAuth2TokenEntry fetchByUserId_First(long userId, OrderByComparator<SharepointOAuth2TokenEntry> orderByComparator) {
        List<SharepointOAuth2TokenEntry> list = this.findByUserId(userId, 0, 1, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public SharepointOAuth2TokenEntry findByUserId_Last(long userId, OrderByComparator<SharepointOAuth2TokenEntry> orderByComparator) throws NoSuch2TokenEntryException {
        SharepointOAuth2TokenEntry sharepointOAuth2TokenEntry = this.fetchByUserId_Last(userId, orderByComparator);
        if (sharepointOAuth2TokenEntry != null) {
            return sharepointOAuth2TokenEntry;
        }
        StringBundler sb = new StringBundler(4);
        sb.append(_NO_SUCH_ENTITY_WITH_KEY);
        sb.append("userId=");
        sb.append(userId);
        sb.append("}");
        throw new NoSuch2TokenEntryException(sb.toString());
    }

    public SharepointOAuth2TokenEntry fetchByUserId_Last(long userId, OrderByComparator<SharepointOAuth2TokenEntry> orderByComparator) {
        int count = this.countByUserId(userId);
        if (count == 0) {
            return null;
        }
        List<SharepointOAuth2TokenEntry> list = this.findByUserId(userId, count - 1, count, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public SharepointOAuth2TokenEntry[] findByUserId_PrevAndNext(long sharepointOAuth2TokenEntryId, long userId, OrderByComparator<SharepointOAuth2TokenEntry> orderByComparator) throws NoSuch2TokenEntryException {
        SharepointOAuth2TokenEntry sharepointOAuth2TokenEntry = this.findByPrimaryKey(sharepointOAuth2TokenEntryId);
        Session session = null;
        try {
            session = this.openSession();
            SharepointOAuth2TokenEntry[] array = new SharepointOAuth2TokenEntryImpl[]{this.getByUserId_PrevAndNext(session, sharepointOAuth2TokenEntry, userId, orderByComparator, true), sharepointOAuth2TokenEntry, this.getByUserId_PrevAndNext(session, sharepointOAuth2TokenEntry, userId, orderByComparator, false)};
            SharepointOAuth2TokenEntry[] sharepointOAuth2TokenEntryArray = array;
            return sharepointOAuth2TokenEntryArray;
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected SharepointOAuth2TokenEntry getByUserId_PrevAndNext(Session session, SharepointOAuth2TokenEntry sharepointOAuth2TokenEntry, long userId, OrderByComparator<SharepointOAuth2TokenEntry> orderByComparator, boolean previous) {
        List list;
        StringBundler sb = null;
        sb = orderByComparator != null ? new StringBundler(4 + orderByComparator.getOrderByConditionFields().length * 3 + orderByComparator.getOrderByFields().length * 3) : new StringBundler(3);
        sb.append(_SQL_SELECT_SHAREPOINTOAUTH2TOKENENTRY_WHERE);
        sb.append(_FINDER_COLUMN_USERID_USERID_2);
        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();
            if (orderByConditionFields.length > 0) {
                sb.append(" AND ");
            }
            for (int i = 0; i < orderByConditionFields.length; ++i) {
                sb.append(_ORDER_BY_ENTITY_ALIAS);
                sb.append(orderByConditionFields[i]);
                if (i + 1 < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" >= ? AND ");
                        continue;
                    }
                    sb.append(" <= ? AND ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" >= ? ");
                    continue;
                }
                sb.append(" <= ? ");
            }
            sb.append(" ORDER BY ");
            String[] orderByFields = orderByComparator.getOrderByFields();
            for (int i = 0; i < orderByFields.length; ++i) {
                sb.append(_ORDER_BY_ENTITY_ALIAS);
                sb.append(orderByFields[i]);
                if (i + 1 < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" ASC, ");
                        continue;
                    }
                    sb.append(" DESC, ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" ASC");
                    continue;
                }
                sb.append(" DESC");
            }
        } else {
            sb.append(" ORDER BY sharepointOAuth2TokenEntry.sharepointOAuth2TokenEntryId ASC");
        }
        String sql = sb.toString();
        Query query = session.createQuery(sql);
        query.setFirstResult(0);
        query.setMaxResults(2);
        QueryPos queryPos = QueryPos.getInstance((Query)query);
        queryPos.add(userId);
        if (orderByComparator != null) {
            for (Object orderByConditionValue : orderByComparator.getOrderByConditionValues((Object)sharepointOAuth2TokenEntry)) {
                queryPos.add(orderByConditionValue);
            }
        }
        if ((list = query.list()).size() == 2) {
            return (SharepointOAuth2TokenEntry)list.get(1);
        }
        return null;
    }

    public void removeByUserId(long userId) {
        for (SharepointOAuth2TokenEntry sharepointOAuth2TokenEntry : this.findByUserId(userId, -1, -1, null)) {
            this.remove((BaseModel)sharepointOAuth2TokenEntry);
        }
    }

    public int countByUserId(long userId) {
        FinderPath finderPath = this._finderPathCountByUserId;
        Object[] finderArgs = new Object[]{userId};
        Long count = (Long)this.finderCache.getResult(finderPath, finderArgs, (BasePersistence)this);
        if (count == null) {
            StringBundler sb = new StringBundler(2);
            sb.append(_SQL_COUNT_SHAREPOINTOAUTH2TOKENENTRY_WHERE);
            sb.append(_FINDER_COLUMN_USERID_USERID_2);
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                queryPos.add(userId);
                count = (Long)query.uniqueResult();
                this.finderCache.putResult(finderPath, finderArgs, (Object)count);
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public SharepointOAuth2TokenEntry findByU_C(long userId, String configurationPid) throws NoSuch2TokenEntryException {
        SharepointOAuth2TokenEntry sharepointOAuth2TokenEntry = this.fetchByU_C(userId, configurationPid);
        if (sharepointOAuth2TokenEntry == null) {
            StringBundler sb = new StringBundler(6);
            sb.append(_NO_SUCH_ENTITY_WITH_KEY);
            sb.append("userId=");
            sb.append(userId);
            sb.append(", configurationPid=");
            sb.append(configurationPid);
            sb.append("}");
            if (_log.isDebugEnabled()) {
                _log.debug((Object)sb.toString());
            }
            throw new NoSuch2TokenEntryException(sb.toString());
        }
        return sharepointOAuth2TokenEntry;
    }

    public SharepointOAuth2TokenEntry fetchByU_C(long userId, String configurationPid) {
        return this.fetchByU_C(userId, configurationPid, true);
    }

    public SharepointOAuth2TokenEntry fetchByU_C(long userId, String configurationPid, boolean useFinderCache) {
        SharepointOAuth2TokenEntry sharepointOAuth2TokenEntry;
        configurationPid = Objects.toString(configurationPid, "");
        Object[] finderArgs = null;
        if (useFinderCache) {
            finderArgs = new Object[]{userId, configurationPid};
        }
        Object result = null;
        if (useFinderCache) {
            result = this.finderCache.getResult(this._finderPathFetchByU_C, finderArgs, (BasePersistence)this);
        }
        if (result instanceof SharepointOAuth2TokenEntry && (userId != (sharepointOAuth2TokenEntry = (SharepointOAuth2TokenEntry)result).getUserId() || !Objects.equals(configurationPid, sharepointOAuth2TokenEntry.getConfigurationPid()))) {
            result = null;
        }
        if (result == null) {
            StringBundler sb = new StringBundler(4);
            sb.append(_SQL_SELECT_SHAREPOINTOAUTH2TOKENENTRY_WHERE);
            sb.append(_FINDER_COLUMN_U_C_USERID_2);
            boolean bindConfigurationPid = false;
            if (configurationPid.isEmpty()) {
                sb.append(_FINDER_COLUMN_U_C_CONFIGURATIONPID_3);
            } else {
                bindConfigurationPid = true;
                sb.append(_FINDER_COLUMN_U_C_CONFIGURATIONPID_2);
            }
            String sql = sb.toString();
            Session session = null;
            try {
                List list;
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                queryPos.add(userId);
                if (bindConfigurationPid) {
                    queryPos.add(configurationPid);
                }
                if ((list = query.list()).isEmpty()) {
                    if (useFinderCache) {
                        this.finderCache.putResult(this._finderPathFetchByU_C, finderArgs, (Object)list);
                    }
                } else {
                    SharepointOAuth2TokenEntry sharepointOAuth2TokenEntry2 = (SharepointOAuth2TokenEntry)list.get(0);
                    result = sharepointOAuth2TokenEntry2;
                    this.cacheResult(sharepointOAuth2TokenEntry2);
                }
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        if (result instanceof List) {
            return null;
        }
        return (SharepointOAuth2TokenEntry)result;
    }

    public SharepointOAuth2TokenEntry removeByU_C(long userId, String configurationPid) throws NoSuch2TokenEntryException {
        SharepointOAuth2TokenEntry sharepointOAuth2TokenEntry = this.findByU_C(userId, configurationPid);
        return (SharepointOAuth2TokenEntry)this.remove((BaseModel)sharepointOAuth2TokenEntry);
    }

    public int countByU_C(long userId, String configurationPid) {
        SharepointOAuth2TokenEntry sharepointOAuth2TokenEntry = this.fetchByU_C(userId, configurationPid);
        if (sharepointOAuth2TokenEntry == null) {
            return 0;
        }
        return 1;
    }

    public SharepointOAuth2TokenEntryPersistenceImpl() {
        this.setModelClass(SharepointOAuth2TokenEntry.class);
        this.setModelImplClass(SharepointOAuth2TokenEntryImpl.class);
        this.setModelPKClass(Long.TYPE);
        this.setTable((Table)SharepointOAuth2TokenEntryTable.INSTANCE);
    }

    public void cacheResult(SharepointOAuth2TokenEntry sharepointOAuth2TokenEntry) {
        this.entityCache.putResult(SharepointOAuth2TokenEntryImpl.class, (Serializable)Long.valueOf(sharepointOAuth2TokenEntry.getPrimaryKey()), (Serializable)sharepointOAuth2TokenEntry);
        this.finderCache.putResult(this._finderPathFetchByU_C, new Object[]{sharepointOAuth2TokenEntry.getUserId(), sharepointOAuth2TokenEntry.getConfigurationPid()}, (Object)sharepointOAuth2TokenEntry);
    }

    public void cacheResult(List<SharepointOAuth2TokenEntry> sharepointOAuth2TokenEntries) {
        if (this._valueObjectFinderCacheListThreshold == 0 || this._valueObjectFinderCacheListThreshold > 0 && sharepointOAuth2TokenEntries.size() > this._valueObjectFinderCacheListThreshold) {
            return;
        }
        for (SharepointOAuth2TokenEntry sharepointOAuth2TokenEntry : sharepointOAuth2TokenEntries) {
            if (this.entityCache.getResult(SharepointOAuth2TokenEntryImpl.class, (Serializable)Long.valueOf(sharepointOAuth2TokenEntry.getPrimaryKey())) != null) continue;
            this.cacheResult(sharepointOAuth2TokenEntry);
        }
    }

    public void clearCache() {
        this.entityCache.clearCache(SharepointOAuth2TokenEntryImpl.class);
        this.finderCache.clearCache(SharepointOAuth2TokenEntryImpl.class);
    }

    public void clearCache(SharepointOAuth2TokenEntry sharepointOAuth2TokenEntry) {
        this.entityCache.removeResult(SharepointOAuth2TokenEntryImpl.class, (BaseModel)sharepointOAuth2TokenEntry);
    }

    public void clearCache(List<SharepointOAuth2TokenEntry> sharepointOAuth2TokenEntries) {
        for (SharepointOAuth2TokenEntry sharepointOAuth2TokenEntry : sharepointOAuth2TokenEntries) {
            this.entityCache.removeResult(SharepointOAuth2TokenEntryImpl.class, (BaseModel)sharepointOAuth2TokenEntry);
        }
    }

    public void clearCache(Set<Serializable> primaryKeys) {
        this.finderCache.clearCache(SharepointOAuth2TokenEntryImpl.class);
        for (Serializable primaryKey : primaryKeys) {
            this.entityCache.removeResult(SharepointOAuth2TokenEntryImpl.class, primaryKey);
        }
    }

    protected void cacheUniqueFindersCache(SharepointOAuth2TokenEntryModelImpl sharepointOAuth2TokenEntryModelImpl) {
        Object[] args = new Object[]{sharepointOAuth2TokenEntryModelImpl.getUserId(), sharepointOAuth2TokenEntryModelImpl.getConfigurationPid()};
        this.finderCache.putResult(this._finderPathFetchByU_C, args, (Object)sharepointOAuth2TokenEntryModelImpl);
    }

    public SharepointOAuth2TokenEntry create(long sharepointOAuth2TokenEntryId) {
        SharepointOAuth2TokenEntryImpl sharepointOAuth2TokenEntry = new SharepointOAuth2TokenEntryImpl();
        sharepointOAuth2TokenEntry.setNew(true);
        sharepointOAuth2TokenEntry.setPrimaryKey(sharepointOAuth2TokenEntryId);
        sharepointOAuth2TokenEntry.setCompanyId(CompanyThreadLocal.getCompanyId());
        return sharepointOAuth2TokenEntry;
    }

    public SharepointOAuth2TokenEntry remove(long sharepointOAuth2TokenEntryId) throws NoSuch2TokenEntryException {
        return this.remove(Long.valueOf(sharepointOAuth2TokenEntryId));
    }

    public SharepointOAuth2TokenEntry remove(Serializable primaryKey) throws NoSuch2TokenEntryException {
        Session session = null;
        try {
            session = this.openSession();
            SharepointOAuth2TokenEntry sharepointOAuth2TokenEntry = (SharepointOAuth2TokenEntry)session.get(SharepointOAuth2TokenEntryImpl.class, primaryKey);
            if (sharepointOAuth2TokenEntry == null) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey));
                }
                throw new NoSuch2TokenEntryException(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey);
            }
            SharepointOAuth2TokenEntry sharepointOAuth2TokenEntry2 = (SharepointOAuth2TokenEntry)this.remove((BaseModel)sharepointOAuth2TokenEntry);
            return sharepointOAuth2TokenEntry2;
        }
        catch (NoSuch2TokenEntryException noSuchEntityException) {
            throw noSuchEntityException;
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected SharepointOAuth2TokenEntry removeImpl(SharepointOAuth2TokenEntry sharepointOAuth2TokenEntry) {
        Session session = null;
        try {
            session = this.openSession();
            if (!session.contains((Object)sharepointOAuth2TokenEntry)) {
                sharepointOAuth2TokenEntry = (SharepointOAuth2TokenEntry)session.get(SharepointOAuth2TokenEntryImpl.class, sharepointOAuth2TokenEntry.getPrimaryKeyObj());
            }
            if (sharepointOAuth2TokenEntry != null) {
                session.delete((Object)sharepointOAuth2TokenEntry);
            }
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
        if (sharepointOAuth2TokenEntry != null) {
            this.clearCache(sharepointOAuth2TokenEntry);
        }
        return sharepointOAuth2TokenEntry;
    }

    public SharepointOAuth2TokenEntry updateImpl(SharepointOAuth2TokenEntry sharepointOAuth2TokenEntry) {
        boolean isNew = sharepointOAuth2TokenEntry.isNew();
        if (!(sharepointOAuth2TokenEntry instanceof SharepointOAuth2TokenEntryModelImpl)) {
            InvocationHandler invocationHandler = null;
            if (ProxyUtil.isProxyClass(sharepointOAuth2TokenEntry.getClass())) {
                invocationHandler = ProxyUtil.getInvocationHandler((Object)sharepointOAuth2TokenEntry);
                throw new IllegalArgumentException("Implement ModelWrapper in sharepointOAuth2TokenEntry proxy " + invocationHandler.getClass());
            }
            throw new IllegalArgumentException("Implement ModelWrapper in custom SharepointOAuth2TokenEntry implementation " + sharepointOAuth2TokenEntry.getClass());
        }
        SharepointOAuth2TokenEntryModelImpl sharepointOAuth2TokenEntryModelImpl = (SharepointOAuth2TokenEntryModelImpl)sharepointOAuth2TokenEntry;
        if (isNew && sharepointOAuth2TokenEntry.getCreateDate() == null) {
            ServiceContext serviceContext = ServiceContextThreadLocal.getServiceContext();
            Date date = new Date();
            if (serviceContext == null) {
                sharepointOAuth2TokenEntry.setCreateDate(date);
            } else {
                sharepointOAuth2TokenEntry.setCreateDate(serviceContext.getCreateDate(date));
            }
        }
        Session session = null;
        try {
            session = this.openSession();
            if (isNew) {
                session.save((Object)sharepointOAuth2TokenEntry);
            } else {
                sharepointOAuth2TokenEntry = (SharepointOAuth2TokenEntry)session.merge((Object)sharepointOAuth2TokenEntry);
            }
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
        this.entityCache.putResult(SharepointOAuth2TokenEntryImpl.class, (BaseModel)sharepointOAuth2TokenEntryModelImpl, false, true);
        this.cacheUniqueFindersCache(sharepointOAuth2TokenEntryModelImpl);
        if (isNew) {
            sharepointOAuth2TokenEntry.setNew(false);
        }
        sharepointOAuth2TokenEntry.resetOriginalValues();
        return sharepointOAuth2TokenEntry;
    }

    public SharepointOAuth2TokenEntry findByPrimaryKey(Serializable primaryKey) throws NoSuch2TokenEntryException {
        SharepointOAuth2TokenEntry sharepointOAuth2TokenEntry = (SharepointOAuth2TokenEntry)this.fetchByPrimaryKey(primaryKey);
        if (sharepointOAuth2TokenEntry == null) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey));
            }
            throw new NoSuch2TokenEntryException(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey);
        }
        return sharepointOAuth2TokenEntry;
    }

    public SharepointOAuth2TokenEntry findByPrimaryKey(long sharepointOAuth2TokenEntryId) throws NoSuch2TokenEntryException {
        return this.findByPrimaryKey(Long.valueOf(sharepointOAuth2TokenEntryId));
    }

    public SharepointOAuth2TokenEntry fetchByPrimaryKey(long sharepointOAuth2TokenEntryId) {
        return (SharepointOAuth2TokenEntry)this.fetchByPrimaryKey(Long.valueOf(sharepointOAuth2TokenEntryId));
    }

    public List<SharepointOAuth2TokenEntry> findAll() {
        return this.findAll(-1, -1, null);
    }

    public List<SharepointOAuth2TokenEntry> findAll(int start, int end) {
        return this.findAll(start, end, null);
    }

    public List<SharepointOAuth2TokenEntry> findAll(int start, int end, OrderByComparator<SharepointOAuth2TokenEntry> orderByComparator) {
        return this.findAll(start, end, orderByComparator, true);
    }

    public List<SharepointOAuth2TokenEntry> findAll(int start, int end, OrderByComparator<SharepointOAuth2TokenEntry> orderByComparator, boolean useFinderCache) {
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            if (useFinderCache) {
                finderPath = this._finderPathWithoutPaginationFindAll;
                finderArgs = FINDER_ARGS_EMPTY;
            }
        } else if (useFinderCache) {
            finderPath = this._finderPathWithPaginationFindAll;
            finderArgs = new Object[]{start, end, orderByComparator};
        }
        List list = null;
        if (useFinderCache) {
            list = (List)this.finderCache.getResult(finderPath, finderArgs, (BasePersistence)this);
        }
        if (list == null) {
            StringBundler sb = null;
            String sql = null;
            if (orderByComparator != null) {
                sb = new StringBundler(2 + orderByComparator.getOrderByFields().length * 2);
                sb.append(_SQL_SELECT_SHAREPOINTOAUTH2TOKENENTRY);
                this.appendOrderByComparator(sb, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
                sql = sb.toString();
            } else {
                sql = _SQL_SELECT_SHAREPOINTOAUTH2TOKENENTRY;
                sql = sql.concat(" ORDER BY sharepointOAuth2TokenEntry.sharepointOAuth2TokenEntryId ASC");
            }
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                list = QueryUtil.list((Query)query, (Dialect)this.getDialect(), (int)start, (int)end);
                this.cacheResult(list);
                if (useFinderCache) {
                    this.finderCache.putResult(finderPath, finderArgs, (Object)list);
                }
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    public void removeAll() {
        for (SharepointOAuth2TokenEntry sharepointOAuth2TokenEntry : this.findAll()) {
            this.remove((BaseModel)sharepointOAuth2TokenEntry);
        }
    }

    public int countAll() {
        Long count = (Long)this.finderCache.getResult(this._finderPathCountAll, FINDER_ARGS_EMPTY, (BasePersistence)this);
        if (count == null) {
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(_SQL_COUNT_SHAREPOINTOAUTH2TOKENENTRY);
                count = (Long)query.uniqueResult();
                this.finderCache.putResult(this._finderPathCountAll, FINDER_ARGS_EMPTY, (Object)count);
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    protected EntityCache getEntityCache() {
        return this.entityCache;
    }

    protected String getPKDBName() {
        return "sharepointOAuth2TokenEntryId";
    }

    protected String getSelectSQL() {
        return _SQL_SELECT_SHAREPOINTOAUTH2TOKENENTRY;
    }

    protected Map<String, Integer> getTableColumnsMap() {
        return SharepointOAuth2TokenEntryModelImpl.TABLE_COLUMNS_MAP;
    }

    @Activate
    public void activate() {
        this._valueObjectFinderCacheListThreshold = GetterUtil.getInteger((String)PropsUtil.get((String)"value.object.finder.cache.list.threshold"));
        this._finderPathWithPaginationFindAll = new FinderPath(FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findAll", new String[0], new String[0], true);
        this._finderPathWithoutPaginationFindAll = new FinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findAll", new String[0], new String[0], true);
        this._finderPathCountAll = new FinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countAll", new String[0], new String[0], false);
        this._finderPathWithPaginationFindByUserId = new FinderPath(FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findByUserId", new String[]{Long.class.getName(), Integer.class.getName(), Integer.class.getName(), OrderByComparator.class.getName()}, new String[]{"userId"}, true);
        this._finderPathWithoutPaginationFindByUserId = new FinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findByUserId", new String[]{Long.class.getName()}, new String[]{"userId"}, true);
        this._finderPathCountByUserId = new FinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByUserId", new String[]{Long.class.getName()}, new String[]{"userId"}, false);
        this._finderPathFetchByU_C = new FinderPath(FINDER_CLASS_NAME_ENTITY, "fetchByU_C", new String[]{Long.class.getName(), String.class.getName()}, new String[]{"userId", "configurationPid"}, true);
        SharepointOAuth2TokenEntryUtil.setPersistence((SharepointOAuth2TokenEntryPersistence)this);
    }

    @Deactivate
    public void deactivate() {
        SharepointOAuth2TokenEntryUtil.setPersistence(null);
        this.entityCache.removeCache(SharepointOAuth2TokenEntryImpl.class.getName());
    }

    @Reference(target="(&(origin.bundle.symbolic.name=com.liferay.sharepoint.rest.oauth2.service)(name=service))", unbind="-")
    public void setConfiguration(Configuration configuration) {
    }

    @Reference(target="(origin.bundle.symbolic.name=com.liferay.sharepoint.rest.oauth2.service)", unbind="-")
    public void setDataSource(DataSource dataSource) {
        super.setDataSource(dataSource);
    }

    @Reference(target="(origin.bundle.symbolic.name=com.liferay.sharepoint.rest.oauth2.service)", unbind="-")
    public void setSessionFactory(SessionFactory sessionFactory) {
        super.setSessionFactory(sessionFactory);
    }

    protected FinderCache getFinderCache() {
        return this.finderCache;
    }
}

