/**
 * SPDX-FileCopyrightText: (c) 2000 Liferay, Inc. https://liferay.com
 * SPDX-License-Identifier: LGPL-2.1-or-later OR LicenseRef-Liferay-DXP-EULA-2.0.0-2023-06
 */

package com.liferay.sharepoint.rest.oauth2.internal.upgrade;

import com.liferay.portal.upgrade.registry.UpgradeStepRegistrator;
import com.liferay.sharepoint.rest.oauth2.internal.upgrade.v2_0_0.UpgradeCompanyId;

import org.osgi.service.component.annotations.Component;

/**
 * @author Alberto Chaparro
 */
@Component(
	immediate = true,
	service = {
		SharepointOauth2ServiceUpgrade.class, UpgradeStepRegistrator.class
	}
)
public class SharepointOauth2ServiceUpgrade implements UpgradeStepRegistrator {

	@Override
	public void register(UpgradeStepRegistrator.Registry registry) {
		registry.register("1.0.0", "2.0.0", new UpgradeCompanyId());
	}

}