/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.sharepoint.rest.oauth2.service.impl;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.User;
import com.liferay.sharepoint.rest.oauth2.model.SharepointOAuth2TokenEntry;
import com.liferay.sharepoint.rest.oauth2.service.base.SharepointOAuth2TokenEntryLocalServiceBaseImpl;
import java.util.Date;

public class SharepointOAuth2TokenEntryLocalServiceImpl
extends SharepointOAuth2TokenEntryLocalServiceBaseImpl {
    public SharepointOAuth2TokenEntry addSharepointOAuth2TokenEntry(long userId, String configurationPid, String accessToken, String refreshToken, Date expirationDate) throws PortalException {
        SharepointOAuth2TokenEntry sharepointOAuth2TokenEntry = this.sharepointOAuth2TokenEntryPersistence.fetchByU_C(userId, configurationPid);
        if (sharepointOAuth2TokenEntry != null) {
            sharepointOAuth2TokenEntry.setAccessToken(accessToken);
            sharepointOAuth2TokenEntry.setExpirationDate(expirationDate);
            sharepointOAuth2TokenEntry.setRefreshToken(refreshToken);
            return (SharepointOAuth2TokenEntry)this.sharepointOAuth2TokenEntryPersistence.update((BaseModel)sharepointOAuth2TokenEntry);
        }
        long sharepointOAuth2TokenEntryId = this.counterLocalService.increment();
        sharepointOAuth2TokenEntry = this.sharepointOAuth2TokenEntryPersistence.create(sharepointOAuth2TokenEntryId);
        sharepointOAuth2TokenEntry.setUserId(userId);
        User user = this.userLocalService.getUser(userId);
        sharepointOAuth2TokenEntry.setUserName(user.getFullName());
        Date now = new Date();
        sharepointOAuth2TokenEntry.setCreateDate(now);
        sharepointOAuth2TokenEntry.setAccessToken(accessToken);
        sharepointOAuth2TokenEntry.setConfigurationPid(configurationPid);
        sharepointOAuth2TokenEntry.setExpirationDate(expirationDate);
        sharepointOAuth2TokenEntry.setRefreshToken(refreshToken);
        return (SharepointOAuth2TokenEntry)this.sharepointOAuth2TokenEntryPersistence.update((BaseModel)sharepointOAuth2TokenEntry);
    }

    public void deleteSharepointOAuth2TokenEntry(long userId, String configurationPid) throws PortalException {
        this.sharepointOAuth2TokenEntryPersistence.removeByU_C(userId, configurationPid);
    }

    public void deleteUserSharepointOAuth2TokenEntries(long userId) {
        this.sharepointOAuth2TokenEntryPersistence.removeByUserId(userId);
    }

    public SharepointOAuth2TokenEntry fetchSharepointOAuth2TokenEntry(long userId, String configurationPid) {
        return this.sharepointOAuth2TokenEntryPersistence.fetchByU_C(userId, configurationPid);
    }

    public SharepointOAuth2TokenEntry getSharepointOAuth2TokenEntry(long userId, String configurationPid) throws PortalException {
        return this.sharepointOAuth2TokenEntryPersistence.findByU_C(userId, configurationPid);
    }

    public int getUserSharepointOAuth2TokenEntriesCount(long userId) {
        return this.sharepointOAuth2TokenEntryPersistence.countByUserId(userId);
    }
}

