/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 */

package com.liferay.sharepoint.rest.oauth2.model.impl;

import aQute.bnd.annotation.ProviderType;

import com.liferay.expando.kernel.model.ExpandoBridge;
import com.liferay.expando.kernel.util.ExpandoBridgeFactoryUtil;

import com.liferay.portal.kernel.bean.AutoEscapeBeanHandler;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.CacheModel;
import com.liferay.portal.kernel.model.ModelWrapper;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.model.impl.BaseModelImpl;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.UserLocalServiceUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ProxyUtil;
import com.liferay.portal.kernel.util.StringBundler;

import com.liferay.sharepoint.rest.oauth2.model.SharepointOAuth2TokenEntry;
import com.liferay.sharepoint.rest.oauth2.model.SharepointOAuth2TokenEntryModel;

import java.io.Serializable;

import java.sql.Types;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;

/**
 * The base model implementation for the SharepointOAuth2TokenEntry service. Represents a row in the &quot;SharepointOAuth2TokenEntry&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This implementation and its corresponding interface {@link SharepointOAuth2TokenEntryModel} exist only as a container for the default property accessors generated by ServiceBuilder. Helper methods and all application logic should be put in {@link SharepointOAuth2TokenEntryImpl}.
 * </p>
 *
 * @author Adolfo Pérez
 * @see SharepointOAuth2TokenEntryImpl
 * @see SharepointOAuth2TokenEntry
 * @see SharepointOAuth2TokenEntryModel
 * @generated
 */
@ProviderType
public class SharepointOAuth2TokenEntryModelImpl extends BaseModelImpl<SharepointOAuth2TokenEntry>
	implements SharepointOAuth2TokenEntryModel {
	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this class directly. All methods that expect a sharepoint o auth2 token entry model instance should use the {@link SharepointOAuth2TokenEntry} interface instead.
	 */
	public static final String TABLE_NAME = "SharepointOAuth2TokenEntry";
	public static final Object[][] TABLE_COLUMNS = {
			{ "sharepointOAuth2TokenEntryId", Types.BIGINT },
			{ "userId", Types.BIGINT },
			{ "userName", Types.VARCHAR },
			{ "createDate", Types.TIMESTAMP },
			{ "accessToken", Types.CLOB },
			{ "configurationPid", Types.VARCHAR },
			{ "expirationDate", Types.TIMESTAMP },
			{ "refreshToken", Types.CLOB }
		};
	public static final Map<String, Integer> TABLE_COLUMNS_MAP = new HashMap<String, Integer>();

	static {
		TABLE_COLUMNS_MAP.put("sharepointOAuth2TokenEntryId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("userId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("userName", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("createDate", Types.TIMESTAMP);
		TABLE_COLUMNS_MAP.put("accessToken", Types.CLOB);
		TABLE_COLUMNS_MAP.put("configurationPid", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("expirationDate", Types.TIMESTAMP);
		TABLE_COLUMNS_MAP.put("refreshToken", Types.CLOB);
	}

	public static final String TABLE_SQL_CREATE = "create table SharepointOAuth2TokenEntry (sharepointOAuth2TokenEntryId LONG not null primary key,userId LONG,userName VARCHAR(75) null,createDate DATE null,accessToken TEXT null,configurationPid VARCHAR(75) null,expirationDate DATE null,refreshToken TEXT null)";
	public static final String TABLE_SQL_DROP = "drop table SharepointOAuth2TokenEntry";
	public static final String ORDER_BY_JPQL = " ORDER BY sharepointOAuth2TokenEntry.sharepointOAuth2TokenEntryId ASC";
	public static final String ORDER_BY_SQL = " ORDER BY SharepointOAuth2TokenEntry.sharepointOAuth2TokenEntryId ASC";
	public static final String DATA_SOURCE = "liferayDataSource";
	public static final String SESSION_FACTORY = "liferaySessionFactory";
	public static final String TX_MANAGER = "liferayTransactionManager";
	public static final boolean ENTITY_CACHE_ENABLED = GetterUtil.getBoolean(com.liferay.sharepoint.rest.oauth2.service.util.ServiceProps.get(
				"value.object.entity.cache.enabled.com.liferay.sharepoint.rest.oauth2.model.SharepointOAuth2TokenEntry"),
			true);
	public static final boolean FINDER_CACHE_ENABLED = GetterUtil.getBoolean(com.liferay.sharepoint.rest.oauth2.service.util.ServiceProps.get(
				"value.object.finder.cache.enabled.com.liferay.sharepoint.rest.oauth2.model.SharepointOAuth2TokenEntry"),
			true);
	public static final boolean COLUMN_BITMASK_ENABLED = GetterUtil.getBoolean(com.liferay.sharepoint.rest.oauth2.service.util.ServiceProps.get(
				"value.object.column.bitmask.enabled.com.liferay.sharepoint.rest.oauth2.model.SharepointOAuth2TokenEntry"),
			true);
	public static final long CONFIGURATIONPID_COLUMN_BITMASK = 1L;
	public static final long USERID_COLUMN_BITMASK = 2L;
	public static final long SHAREPOINTOAUTH2TOKENENTRYID_COLUMN_BITMASK = 4L;
	public static final long LOCK_EXPIRATION_TIME = GetterUtil.getLong(com.liferay.sharepoint.rest.oauth2.service.util.ServiceProps.get(
				"lock.expiration.time.com.liferay.sharepoint.rest.oauth2.model.SharepointOAuth2TokenEntry"));

	public SharepointOAuth2TokenEntryModelImpl() {
	}

	@Override
	public long getPrimaryKey() {
		return _sharepointOAuth2TokenEntryId;
	}

	@Override
	public void setPrimaryKey(long primaryKey) {
		setSharepointOAuth2TokenEntryId(primaryKey);
	}

	@Override
	public Serializable getPrimaryKeyObj() {
		return _sharepointOAuth2TokenEntryId;
	}

	@Override
	public void setPrimaryKeyObj(Serializable primaryKeyObj) {
		setPrimaryKey(((Long)primaryKeyObj).longValue());
	}

	@Override
	public Class<?> getModelClass() {
		return SharepointOAuth2TokenEntry.class;
	}

	@Override
	public String getModelClassName() {
		return SharepointOAuth2TokenEntry.class.getName();
	}

	@Override
	public Map<String, Object> getModelAttributes() {
		Map<String, Object> attributes = new HashMap<String, Object>();

		attributes.put("sharepointOAuth2TokenEntryId",
			getSharepointOAuth2TokenEntryId());
		attributes.put("userId", getUserId());
		attributes.put("userName", getUserName());
		attributes.put("createDate", getCreateDate());
		attributes.put("accessToken", getAccessToken());
		attributes.put("configurationPid", getConfigurationPid());
		attributes.put("expirationDate", getExpirationDate());
		attributes.put("refreshToken", getRefreshToken());

		attributes.put("entityCacheEnabled", isEntityCacheEnabled());
		attributes.put("finderCacheEnabled", isFinderCacheEnabled());

		return attributes;
	}

	@Override
	public void setModelAttributes(Map<String, Object> attributes) {
		Long sharepointOAuth2TokenEntryId = (Long)attributes.get(
				"sharepointOAuth2TokenEntryId");

		if (sharepointOAuth2TokenEntryId != null) {
			setSharepointOAuth2TokenEntryId(sharepointOAuth2TokenEntryId);
		}

		Long userId = (Long)attributes.get("userId");

		if (userId != null) {
			setUserId(userId);
		}

		String userName = (String)attributes.get("userName");

		if (userName != null) {
			setUserName(userName);
		}

		Date createDate = (Date)attributes.get("createDate");

		if (createDate != null) {
			setCreateDate(createDate);
		}

		String accessToken = (String)attributes.get("accessToken");

		if (accessToken != null) {
			setAccessToken(accessToken);
		}

		String configurationPid = (String)attributes.get("configurationPid");

		if (configurationPid != null) {
			setConfigurationPid(configurationPid);
		}

		Date expirationDate = (Date)attributes.get("expirationDate");

		if (expirationDate != null) {
			setExpirationDate(expirationDate);
		}

		String refreshToken = (String)attributes.get("refreshToken");

		if (refreshToken != null) {
			setRefreshToken(refreshToken);
		}
	}

	@Override
	public long getSharepointOAuth2TokenEntryId() {
		return _sharepointOAuth2TokenEntryId;
	}

	@Override
	public void setSharepointOAuth2TokenEntryId(
		long sharepointOAuth2TokenEntryId) {
		_sharepointOAuth2TokenEntryId = sharepointOAuth2TokenEntryId;
	}

	@Override
	public long getUserId() {
		return _userId;
	}

	@Override
	public void setUserId(long userId) {
		_columnBitmask |= USERID_COLUMN_BITMASK;

		if (!_setOriginalUserId) {
			_setOriginalUserId = true;

			_originalUserId = _userId;
		}

		_userId = userId;
	}

	@Override
	public String getUserUuid() {
		try {
			User user = UserLocalServiceUtil.getUserById(getUserId());

			return user.getUuid();
		}
		catch (PortalException pe) {
			return "";
		}
	}

	@Override
	public void setUserUuid(String userUuid) {
	}

	public long getOriginalUserId() {
		return _originalUserId;
	}

	@Override
	public String getUserName() {
		if (_userName == null) {
			return "";
		}
		else {
			return _userName;
		}
	}

	@Override
	public void setUserName(String userName) {
		_userName = userName;
	}

	@Override
	public Date getCreateDate() {
		return _createDate;
	}

	@Override
	public void setCreateDate(Date createDate) {
		_createDate = createDate;
	}

	@Override
	public String getAccessToken() {
		if (_accessToken == null) {
			return "";
		}
		else {
			return _accessToken;
		}
	}

	@Override
	public void setAccessToken(String accessToken) {
		_accessToken = accessToken;
	}

	@Override
	public String getConfigurationPid() {
		if (_configurationPid == null) {
			return "";
		}
		else {
			return _configurationPid;
		}
	}

	@Override
	public void setConfigurationPid(String configurationPid) {
		_columnBitmask |= CONFIGURATIONPID_COLUMN_BITMASK;

		if (_originalConfigurationPid == null) {
			_originalConfigurationPid = _configurationPid;
		}

		_configurationPid = configurationPid;
	}

	public String getOriginalConfigurationPid() {
		return GetterUtil.getString(_originalConfigurationPid);
	}

	@Override
	public Date getExpirationDate() {
		return _expirationDate;
	}

	@Override
	public void setExpirationDate(Date expirationDate) {
		_expirationDate = expirationDate;
	}

	@Override
	public String getRefreshToken() {
		if (_refreshToken == null) {
			return "";
		}
		else {
			return _refreshToken;
		}
	}

	@Override
	public void setRefreshToken(String refreshToken) {
		_refreshToken = refreshToken;
	}

	public long getColumnBitmask() {
		return _columnBitmask;
	}

	@Override
	public ExpandoBridge getExpandoBridge() {
		return ExpandoBridgeFactoryUtil.getExpandoBridge(0,
			SharepointOAuth2TokenEntry.class.getName(), getPrimaryKey());
	}

	@Override
	public void setExpandoBridgeAttributes(ServiceContext serviceContext) {
		ExpandoBridge expandoBridge = getExpandoBridge();

		expandoBridge.setAttributes(serviceContext);
	}

	@Override
	public SharepointOAuth2TokenEntry toEscapedModel() {
		if (_escapedModel == null) {
			_escapedModel = (SharepointOAuth2TokenEntry)ProxyUtil.newProxyInstance(_classLoader,
					_escapedModelInterfaces, new AutoEscapeBeanHandler(this));
		}

		return _escapedModel;
	}

	@Override
	public Object clone() {
		SharepointOAuth2TokenEntryImpl sharepointOAuth2TokenEntryImpl = new SharepointOAuth2TokenEntryImpl();

		sharepointOAuth2TokenEntryImpl.setSharepointOAuth2TokenEntryId(getSharepointOAuth2TokenEntryId());
		sharepointOAuth2TokenEntryImpl.setUserId(getUserId());
		sharepointOAuth2TokenEntryImpl.setUserName(getUserName());
		sharepointOAuth2TokenEntryImpl.setCreateDate(getCreateDate());
		sharepointOAuth2TokenEntryImpl.setAccessToken(getAccessToken());
		sharepointOAuth2TokenEntryImpl.setConfigurationPid(getConfigurationPid());
		sharepointOAuth2TokenEntryImpl.setExpirationDate(getExpirationDate());
		sharepointOAuth2TokenEntryImpl.setRefreshToken(getRefreshToken());

		sharepointOAuth2TokenEntryImpl.resetOriginalValues();

		return sharepointOAuth2TokenEntryImpl;
	}

	@Override
	public int compareTo(SharepointOAuth2TokenEntry sharepointOAuth2TokenEntry) {
		long primaryKey = sharepointOAuth2TokenEntry.getPrimaryKey();

		if (getPrimaryKey() < primaryKey) {
			return -1;
		}
		else if (getPrimaryKey() > primaryKey) {
			return 1;
		}
		else {
			return 0;
		}
	}

	@Override
	public boolean equals(Object obj) {
		if (this == obj) {
			return true;
		}

		if (!(obj instanceof SharepointOAuth2TokenEntry)) {
			return false;
		}

		SharepointOAuth2TokenEntry sharepointOAuth2TokenEntry = (SharepointOAuth2TokenEntry)obj;

		long primaryKey = sharepointOAuth2TokenEntry.getPrimaryKey();

		if (getPrimaryKey() == primaryKey) {
			return true;
		}
		else {
			return false;
		}
	}

	@Override
	public int hashCode() {
		return (int)getPrimaryKey();
	}

	@Override
	public boolean isEntityCacheEnabled() {
		return ENTITY_CACHE_ENABLED;
	}

	@Override
	public boolean isFinderCacheEnabled() {
		return FINDER_CACHE_ENABLED;
	}

	@Override
	public void resetOriginalValues() {
		SharepointOAuth2TokenEntryModelImpl sharepointOAuth2TokenEntryModelImpl = this;

		sharepointOAuth2TokenEntryModelImpl._originalUserId = sharepointOAuth2TokenEntryModelImpl._userId;

		sharepointOAuth2TokenEntryModelImpl._setOriginalUserId = false;

		sharepointOAuth2TokenEntryModelImpl._originalConfigurationPid = sharepointOAuth2TokenEntryModelImpl._configurationPid;

		sharepointOAuth2TokenEntryModelImpl._columnBitmask = 0;
	}

	@Override
	public CacheModel<SharepointOAuth2TokenEntry> toCacheModel() {
		SharepointOAuth2TokenEntryCacheModel sharepointOAuth2TokenEntryCacheModel =
			new SharepointOAuth2TokenEntryCacheModel();

		sharepointOAuth2TokenEntryCacheModel.sharepointOAuth2TokenEntryId = getSharepointOAuth2TokenEntryId();

		sharepointOAuth2TokenEntryCacheModel.userId = getUserId();

		sharepointOAuth2TokenEntryCacheModel.userName = getUserName();

		String userName = sharepointOAuth2TokenEntryCacheModel.userName;

		if ((userName != null) && (userName.length() == 0)) {
			sharepointOAuth2TokenEntryCacheModel.userName = null;
		}

		Date createDate = getCreateDate();

		if (createDate != null) {
			sharepointOAuth2TokenEntryCacheModel.createDate = createDate.getTime();
		}
		else {
			sharepointOAuth2TokenEntryCacheModel.createDate = Long.MIN_VALUE;
		}

		sharepointOAuth2TokenEntryCacheModel.accessToken = getAccessToken();

		String accessToken = sharepointOAuth2TokenEntryCacheModel.accessToken;

		if ((accessToken != null) && (accessToken.length() == 0)) {
			sharepointOAuth2TokenEntryCacheModel.accessToken = null;
		}

		sharepointOAuth2TokenEntryCacheModel.configurationPid = getConfigurationPid();

		String configurationPid = sharepointOAuth2TokenEntryCacheModel.configurationPid;

		if ((configurationPid != null) && (configurationPid.length() == 0)) {
			sharepointOAuth2TokenEntryCacheModel.configurationPid = null;
		}

		Date expirationDate = getExpirationDate();

		if (expirationDate != null) {
			sharepointOAuth2TokenEntryCacheModel.expirationDate = expirationDate.getTime();
		}
		else {
			sharepointOAuth2TokenEntryCacheModel.expirationDate = Long.MIN_VALUE;
		}

		sharepointOAuth2TokenEntryCacheModel.refreshToken = getRefreshToken();

		String refreshToken = sharepointOAuth2TokenEntryCacheModel.refreshToken;

		if ((refreshToken != null) && (refreshToken.length() == 0)) {
			sharepointOAuth2TokenEntryCacheModel.refreshToken = null;
		}

		return sharepointOAuth2TokenEntryCacheModel;
	}

	@Override
	public String toString() {
		StringBundler sb = new StringBundler(17);

		sb.append("{sharepointOAuth2TokenEntryId=");
		sb.append(getSharepointOAuth2TokenEntryId());
		sb.append(", userId=");
		sb.append(getUserId());
		sb.append(", userName=");
		sb.append(getUserName());
		sb.append(", createDate=");
		sb.append(getCreateDate());
		sb.append(", accessToken=");
		sb.append(getAccessToken());
		sb.append(", configurationPid=");
		sb.append(getConfigurationPid());
		sb.append(", expirationDate=");
		sb.append(getExpirationDate());
		sb.append(", refreshToken=");
		sb.append(getRefreshToken());
		sb.append("}");

		return sb.toString();
	}

	@Override
	public String toXmlString() {
		StringBundler sb = new StringBundler(28);

		sb.append("<model><model-name>");
		sb.append(
			"com.liferay.sharepoint.rest.oauth2.model.SharepointOAuth2TokenEntry");
		sb.append("</model-name>");

		sb.append(
			"<column><column-name>sharepointOAuth2TokenEntryId</column-name><column-value><![CDATA[");
		sb.append(getSharepointOAuth2TokenEntryId());
		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>userId</column-name><column-value><![CDATA[");
		sb.append(getUserId());
		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>userName</column-name><column-value><![CDATA[");
		sb.append(getUserName());
		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>createDate</column-name><column-value><![CDATA[");
		sb.append(getCreateDate());
		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>accessToken</column-name><column-value><![CDATA[");
		sb.append(getAccessToken());
		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>configurationPid</column-name><column-value><![CDATA[");
		sb.append(getConfigurationPid());
		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>expirationDate</column-name><column-value><![CDATA[");
		sb.append(getExpirationDate());
		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>refreshToken</column-name><column-value><![CDATA[");
		sb.append(getRefreshToken());
		sb.append("]]></column-value></column>");

		sb.append("</model>");

		return sb.toString();
	}

	private static final ClassLoader _classLoader = SharepointOAuth2TokenEntry.class.getClassLoader();
	private static final Class<?>[] _escapedModelInterfaces = new Class[] {
			SharepointOAuth2TokenEntry.class, ModelWrapper.class
		};
	private long _sharepointOAuth2TokenEntryId;
	private long _userId;
	private long _originalUserId;
	private boolean _setOriginalUserId;
	private String _userName;
	private Date _createDate;
	private String _accessToken;
	private String _configurationPid;
	private String _originalConfigurationPid;
	private Date _expirationDate;
	private String _refreshToken;
	private long _columnBitmask;
	private SharepointOAuth2TokenEntry _escapedModel;
}