/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 */

package com.liferay.sharepoint.rest.oauth2.model.impl;

import aQute.bnd.annotation.ProviderType;

import com.liferay.sharepoint.rest.oauth2.model.SharepointOAuth2TokenEntry;
import com.liferay.sharepoint.rest.oauth2.service.SharepointOAuth2TokenEntryLocalServiceUtil;

/**
 * The extended model base implementation for the SharepointOAuth2TokenEntry service. Represents a row in the &quot;SharepointOAuth2TokenEntry&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This class exists only as a container for the default extended model level methods generated by ServiceBuilder. Helper methods and all application logic should be put in {@link SharepointOAuth2TokenEntryImpl}.
 * </p>
 *
 * @author Adolfo Pérez
 * @see SharepointOAuth2TokenEntryImpl
 * @see SharepointOAuth2TokenEntry
 * @generated
 */
@ProviderType
public abstract class SharepointOAuth2TokenEntryBaseImpl
	extends SharepointOAuth2TokenEntryModelImpl
	implements SharepointOAuth2TokenEntry {
	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this class directly. All methods that expect a sharepoint o auth2 token entry model instance should use the {@link SharepointOAuth2TokenEntry} interface instead.
	 */
	@Override
	public void persist() {
		if (this.isNew()) {
			SharepointOAuth2TokenEntryLocalServiceUtil.addSharepointOAuth2TokenEntry(this);
		}
		else {
			SharepointOAuth2TokenEntryLocalServiceUtil.updateSharepointOAuth2TokenEntry(this);
		}
	}
}